/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spells;

import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.plugins.magic.SpellEventType;
import com.elmakers.mine.bukkit.plugins.magic.SpellResult;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import org.bukkit.Bukkit;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class LevitateSpell
extends Spell {
    private long levitateEnded;
    private final long safetyLength = 10000L;

    public SpellResult onCast(ConfigurationNode parameters) {
        final float flightSpeed = (float)parameters.getDouble("speed", 0.6f);
        if (this.player.getAllowFlight()) {
            this.sendMessage("You feel heavier");
            this.player.setFlying(false);
            this.player.setAllowFlight(false);
            this.spells.registerEvent(SpellEventType.PLAYER_DAMAGE, this);
            this.levitateEnded = System.currentTimeMillis();
            return SpellResult.COST_FREE;
        }
        this.castMessage("You feel lighter");
        Vector velocity = this.player.getVelocity();
        velocity.setY(velocity.getY() + 2.0);
        this.player.setVelocity(velocity);
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.spells.getPlugin(), new Runnable(){

            public void run() {
                LevitateSpell.this.player.setFlySpeed(flightSpeed);
                LevitateSpell.this.player.setAllowFlight(true);
                LevitateSpell.this.player.setFlying(true);
            }
        }, 2L);
        return SpellResult.SUCCESS;
    }

    public void onPlayerDamage(EntityDamageEvent event) {
        if (event.getCause() != EntityDamageEvent.DamageCause.FALL) {
            return;
        }
        this.spells.unregisterEvent(SpellEventType.PLAYER_DAMAGE, this);
        if (this.levitateEnded == 0L) {
            return;
        }
        if (this.levitateEnded + 10000L > System.currentTimeMillis()) {
            event.setCancelled(true);
            this.levitateEnded = 0L;
        }
    }

    public void onLoad(ConfigurationNode node) {
        this.disableTargeting();
    }
}

