/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spells;

import com.elmakers.mine.bukkit.dao.BlockList;
import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.plugins.magic.SpellResult;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.inventory.ItemStack;

public class ConstructSpell
extends Spell {
    private ConstructionType defaultConstructionType = ConstructionType.SPHERE;
    private int defaultRadius = 2;
    private int timeToLive = 0;

    public SpellResult onCast(ConfigurationNode parameters) {
        this.targetThrough(Material.GLASS);
        Block target = this.getTarget().getBlock();
        if (target == null) {
            this.initializeTargeting(this.player);
            this.noTargetThrough(Material.GLASS);
            target = this.getTarget().getBlock();
        }
        if (target == null) {
            this.castMessage("No target");
            return SpellResult.NO_TARGET;
        }
        if (parameters.containsKey("y_offset")) {
            target = target.getRelative(BlockFace.UP, parameters.getInt("y_offset", 0));
        }
        if (!this.hasBuildPermission(target)) {
            this.castMessage("You don't have permission to build here.");
            return SpellResult.INSUFFICIENT_PERMISSION;
        }
        Material material = target.getType();
        byte data = target.getData();
        ItemStack buildWith = this.getBuildingMaterial();
        if (buildWith != null) {
            material = buildWith.getType();
            data = ConstructSpell.getItemData(buildWith);
        }
        ConstructionType conType = this.defaultConstructionType;
        boolean hollow = false;
        String fillType = parameters.getString("fill", "");
        hollow = fillType.equals("hollow");
        Material materialOverride = parameters.getMaterial("material");
        if (materialOverride != null) {
            material = materialOverride;
            data = 0;
        }
        int radius = parameters.getInt("radius", this.defaultRadius);
        String typeString = parameters.getString("type", "");
        ConstructionType testType = ConstructionType.parseString(typeString, ConstructionType.UNKNOWN);
        if (testType != ConstructionType.UNKNOWN) {
            conType = testType;
        }
        switch (conType) {
            case SPHERE: {
                this.constructSphere(target, radius, material, data, !hollow);
                break;
            }
            case CUBOID: {
                this.constructCuboid(target, radius, material, data, !hollow);
                break;
            }
            default: {
                return SpellResult.FAILURE;
            }
        }
        return SpellResult.SUCCESS;
    }

    public void constructCuboid(Block target, int radius, Material material, byte data, boolean fill) {
        this.fillArea(target, radius, material, data, fill, false);
    }

    public void constructSphere(Block target, int radius, Material material, byte data, boolean fill) {
        this.fillArea(target, radius, material, data, fill, true);
    }

    public void fillArea(Block target, int radius, Material material, byte data, boolean fill, boolean sphere) {
        BlockList constructedBlocks = new BlockList();
        int diameter = radius * 2;
        int midX = (diameter - 1) / 2;
        int midY = (diameter - 1) / 2;
        int midZ = (diameter - 1) / 2;
        int diameterOffset = diameter - 1;
        int radiusSquared = (radius - 1) * (radius - 1);
        int x = 0;
        while (x < radius) {
            int y = 0;
            while (y < radius) {
                int z = 0;
                while (z < radius) {
                    boolean fillBlock = false;
                    if (sphere) {
                        int distanceSquared = this.getDistanceSquared(x - midX, y - midY, z - midZ);
                        boolean bl = fillBlock = distanceSquared <= radiusSquared;
                        if (!fill) {
                            fillBlock = fillBlock && distanceSquared >= radiusSquared - 16;
                        }
                    } else {
                        boolean bl = fill ? true : (fillBlock = x == 0 || y == 0 || z == 0);
                    }
                    if (fillBlock) {
                        this.constructBlock(x, y, z, target, radius, material, data, constructedBlocks);
                        this.constructBlock(diameterOffset - x, y, z, target, radius, material, data, constructedBlocks);
                        this.constructBlock(x, diameterOffset - y, z, target, radius, material, data, constructedBlocks);
                        this.constructBlock(x, y, diameterOffset - z, target, radius, material, data, constructedBlocks);
                        this.constructBlock(diameterOffset - x, diameterOffset - y, z, target, radius, material, data, constructedBlocks);
                        this.constructBlock(x, diameterOffset - y, diameterOffset - z, target, radius, material, data, constructedBlocks);
                        this.constructBlock(diameterOffset - x, y, diameterOffset - z, target, radius, material, data, constructedBlocks);
                        this.constructBlock(diameterOffset - x, diameterOffset - y, diameterOffset - z, target, radius, material, data, constructedBlocks);
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        if (this.timeToLive == 0) {
            this.spells.addToUndoQueue(this.player, constructedBlocks);
        } else {
            constructedBlocks.setTimeToLive(this.timeToLive);
            this.spells.scheduleCleanup(constructedBlocks);
        }
        this.castMessage("Constructed " + constructedBlocks.size() + "blocks");
    }

    public int getDistanceSquared(int x, int y, int z) {
        return x * x + y * y + z * z;
    }

    public void constructBlock(int dx, int dy, int dz, Block centerPoint, int radius, Material material, byte data, BlockList constructedBlocks) {
        int x = centerPoint.getX() + dx - radius;
        int y = centerPoint.getY() + dy - radius;
        int z = centerPoint.getZ() + dz - radius;
        Block block = this.player.getWorld().getBlockAt(x, y, z);
        if (!this.isDestructible(block)) {
            return;
        }
        if (!this.hasBuildPermission(block)) {
            return;
        }
        constructedBlocks.add(block);
        block.setType(material);
        block.setData(data);
    }

    public boolean isDestructible(Block block) {
        return this.spells.getDestructibleMaterials().contains(block.getType());
    }

    public void onLoad(ConfigurationNode properties) {
        this.timeToLive = properties.getInt("undo", this.timeToLive);
    }

    public boolean usesMaterial() {
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ConstructionType {
        SPHERE,
        CUBOID,
        UNKNOWN;


        public static ConstructionType parseString(String s, ConstructionType defaultType) {
            ConstructionType construct = defaultType;
            ConstructionType[] constructionTypeArray = ConstructionType.values();
            int n = constructionTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ConstructionType t = constructionTypeArray[n2];
                if (t.name().equalsIgnoreCase(s)) {
                    construct = t;
                }
                ++n2;
            }
            return construct;
        }
    }
}

