/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spells;

import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.plugins.magic.SpellResult;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import java.lang.reflect.Field;
import java.util.Random;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Firework;
import org.bukkit.inventory.meta.FireworkMeta;

public class FireworkSpell
extends Spell {
    private FireworkEffect.Type fireworkType;
    private Color color1;
    private Color color2;
    private int power;
    private boolean flicker;
    private boolean trail;
    private static FireworkEffect.Type[] types = new FireworkEffect.Type[]{FireworkEffect.Type.BALL, FireworkEffect.Type.BALL_LARGE, FireworkEffect.Type.BURST, FireworkEffect.Type.CREEPER, FireworkEffect.Type.STAR};
    private static Color[] colors = new Color[]{Color.AQUA, Color.BLACK, Color.BLUE, Color.FUCHSIA, Color.GRAY, Color.GREEN, Color.LIME, Color.MAROON, Color.NAVY, Color.OLIVE, Color.ORANGE, Color.PURPLE, Color.RED, Color.SILVER, Color.TEAL, Color.WHITE, Color.YELLOW};

    public SpellResult onCast(ConfigurationNode parameters) {
        Random rand = new Random();
        this.color1 = this.getColor(rand.nextInt(17));
        this.color2 = this.getColor(rand.nextInt(17));
        this.power = rand.nextInt(2) + 1;
        this.fireworkType = this.getType(rand.nextInt(5));
        this.flicker = rand.nextBoolean();
        this.trail = rand.nextBoolean();
        this.power = parameters.getInt("size", this.power);
        if (parameters.containsKey("color1")) {
            this.color1 = this.getColor(parameters.getString("color1"));
        }
        if (parameters.containsKey("color2")) {
            this.color2 = this.getColor(parameters.getString("color2"));
        }
        if (parameters.containsKey("type")) {
            this.fireworkType = this.getType(parameters.getString("type"));
        }
        this.flicker = parameters.getBoolean("flicker", this.flicker);
        this.trail = parameters.getBoolean("trail", this.trail);
        int flareCount = parameters.getInt("count", 1);
        Block target = this.getTarget().getBlock();
        int i = 0;
        while (i < flareCount) {
            this.spawnFirework(target.getLocation(), flareCount);
            ++i;
        }
        this.castMessage("You fire some magical flares");
        return SpellResult.SUCCESS;
    }

    protected void spawnFirework(Location location, int spread) {
        Firework firework = (Firework)this.player.getWorld().spawnEntity(location, EntityType.FIREWORK);
        FireworkMeta meta = firework.getFireworkMeta();
        FireworkEffect effect = FireworkEffect.builder().flicker(this.flicker).withColor(this.color1).withFade(this.color2).with(this.fireworkType).trail(this.trail).build();
        meta.addEffect(effect);
        meta.setPower(this.power);
        firework.setFireworkMeta(meta);
    }

    protected FireworkEffect.Type getType(int i) {
        if (i < types.length) {
            return types[i];
        }
        return types[0];
    }

    protected Color getColor(int i) {
        if (i < colors.length) {
            return colors[i];
        }
        return colors[0];
    }

    protected Color getColor(String name) {
        try {
            Field colorConstant = Color.class.getField(name.toUpperCase());
            return (Color)colorConstant.get(null);
        }
        catch (Exception exception) {
            return Color.WHITE;
        }
    }

    protected FireworkEffect.Type getType(String name) {
        FireworkEffect.Type[] typeArray = FireworkEffect.Type.values();
        int n = typeArray.length;
        int n2 = 0;
        while (n2 < n) {
            FireworkEffect.Type t = typeArray[n2];
            if (t.name().equalsIgnoreCase(name)) {
                return t;
            }
            ++n2;
        }
        return FireworkEffect.Type.BALL;
    }

    public void onLoad(ConfigurationNode parameters) {
    }
}

