/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spells;

import com.elmakers.mine.bukkit.dao.BlockList;
import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.plugins.magic.SpellResult;
import com.elmakers.mine.bukkit.plugins.magic.Target;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public class DisintegrateSpell
extends Spell {
    private int playerDamage = 1;
    private int entityDamage = 100;

    public SpellResult onCast(ConfigurationNode parameters) {
        Entity targetEntity;
        Target target = this.getTarget();
        if (target == null) {
            this.castMessage("No target");
            return SpellResult.NO_TARGET;
        }
        if (target.isEntity() && (targetEntity = target.getEntity()) instanceof LivingEntity) {
            LivingEntity li = (LivingEntity)targetEntity;
            if (li instanceof Player) {
                li.damage((double)this.playerDamage);
            } else {
                li.damage((double)this.entityDamage);
            }
            this.castMessage("ZOT!");
            return SpellResult.SUCCESS;
        }
        if (!target.hasTarget()) {
            this.castMessage("No target");
            return SpellResult.NO_TARGET;
        }
        Block targetBlock = target.getBlock();
        BlockList disintigrated = new BlockList();
        disintigrated.add(targetBlock);
        if (!this.hasBuildPermission(targetBlock)) {
            this.castMessage("You don't have permission to build here.");
            return SpellResult.INSUFFICIENT_PERMISSION;
        }
        if (this.isUnderwater()) {
            targetBlock.setType(Material.STATIONARY_WATER);
        } else {
            targetBlock.setType(Material.AIR);
        }
        this.spells.addToUndoQueue(this.player, disintigrated);
        this.castMessage("ZAP!");
        return SpellResult.SUCCESS;
    }

    public void onLoad(ConfigurationNode properties) {
        this.playerDamage = properties.getInteger("player_damage", this.playerDamage);
        this.entityDamage = properties.getInteger("entity_damage", this.entityDamage);
    }
}

