/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic;

import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.plugins.magic.Wand;
import com.elmakers.mine.bukkit.utilities.RandomUtils;
import com.elmakers.mine.bukkit.utilities.WeightedPair;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import java.util.LinkedList;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WandLevel {
    private static TreeMap<Integer, WandLevel> levelMap = null;
    private static int[] levels = null;
    private final LinkedList<WeightedPair<Integer>> spellCountProbability = new LinkedList();
    private final LinkedList<WeightedPair<String>> spellProbability = new LinkedList();
    private final LinkedList<WeightedPair<Integer>> useProbability = new LinkedList();
    private final LinkedList<WeightedPair<Integer>> addUseProbability = new LinkedList();
    private final LinkedList<WeightedPair<Float>> costReductionProbability = new LinkedList();
    private final LinkedList<WeightedPair<Float>> damageReductionProbability = new LinkedList();
    private final LinkedList<WeightedPair<Float>> damageReductionPhysicalProbability = new LinkedList();
    private final LinkedList<WeightedPair<Float>> damageReductionProjectilesProbability = new LinkedList();
    private final LinkedList<WeightedPair<Float>> damageReductionFallingProbability = new LinkedList();
    private final LinkedList<WeightedPair<Float>> damageReductionFireProbability = new LinkedList();
    private final LinkedList<WeightedPair<Float>> damageReductionExplosionsProbability = new LinkedList();
    private final LinkedList<WeightedPair<Integer>> xpRegenerationProbability = new LinkedList();
    private final LinkedList<WeightedPair<Integer>> xpMaxProbability = new LinkedList();
    private final LinkedList<WeightedPair<Integer>> healthRegenerationProbability = new LinkedList();
    private final LinkedList<WeightedPair<Integer>> hungerRegenerationProbability = new LinkedList();
    private final LinkedList<WeightedPair<Float>> hasteProbability = new LinkedList();
    public static final int maxUses = 500;
    public static final int maxMaxXp = 10000;
    public static final int maxXpRegeneration = 100;
    public static final int maxRegeneration = 20;
    public static final float maxReduction = 0.9f;
    public static final float maxProtection = 0.9f;
    public static float maxWalkSpeedIncrease = 0.3f;

    public static WandLevel getLevel(int level) {
        if (levelMap == null) {
            return null;
        }
        if (!levelMap.containsKey(level)) {
            if (level > levelMap.lastKey()) {
                return levelMap.lastEntry().getValue();
            }
            return levelMap.firstEntry().getValue();
        }
        return levelMap.get(level);
    }

    public static void mapLevels(ConfigurationNode template) {
        levelMap = new TreeMap();
        String[] levelStrings = StringUtils.split((String)template.getString("levels"), (String)",");
        levels = new int[levelStrings.length];
        int i = 0;
        while (i < levels.length) {
            WandLevel.levels[i] = Integer.parseInt(levelStrings[i]);
            ++i;
        }
        int level = 1;
        while (level < levels[levels.length - 1]) {
            levelMap.put(level, new WandLevel(level, template));
            ++level;
        }
    }

    private WandLevel(int level, ConfigurationNode template) {
        int levelIndex = 0;
        int nextLevelIndex = 0;
        float distance = 1.0f;
        levelIndex = 0;
        while (levelIndex < levels.length) {
            if (level == levels[levelIndex] || levelIndex == levels.length - 1) {
                nextLevelIndex = levelIndex;
                distance = 0.0f;
                break;
            }
            if (level > levels[levelIndex]) {
                nextLevelIndex = levelIndex + 1;
                int previousLevel = levels[levelIndex];
                int nextLevel = levels[nextLevelIndex];
                distance = (float)(level - previousLevel) / (float)(nextLevel - previousLevel);
            }
            ++levelIndex;
        }
        RandomUtils.populateStringProbabilityMap(this.spellProbability, template.getNode("spells"), levelIndex, nextLevelIndex, distance);
        RandomUtils.populateIntegerProbabilityMap(this.spellCountProbability, template.getNode("spell_count"), levelIndex, nextLevelIndex, distance);
        RandomUtils.populateIntegerProbabilityMap(this.useProbability, template.getNode("uses"), levelIndex, nextLevelIndex, distance);
        RandomUtils.populateIntegerProbabilityMap(this.addUseProbability, template.getNode("add_uses"), levelIndex, nextLevelIndex, distance);
        RandomUtils.populateFloatProbabilityMap(this.costReductionProbability, template.getNode("cost_reduction"), levelIndex, nextLevelIndex, distance);
        RandomUtils.populateFloatProbabilityMap(this.damageReductionProbability, template.getNode("damage_reduction"), levelIndex, nextLevelIndex, distance);
        RandomUtils.populateFloatProbabilityMap(this.damageReductionPhysicalProbability, template.getNode("damage_reduction_physical"), levelIndex, nextLevelIndex, distance);
        RandomUtils.populateFloatProbabilityMap(this.damageReductionFallingProbability, template.getNode("damage_reduction_falling"), levelIndex, nextLevelIndex, distance);
        RandomUtils.populateFloatProbabilityMap(this.damageReductionProjectilesProbability, template.getNode("damage_reduction_projectiles"), levelIndex, nextLevelIndex, distance);
        RandomUtils.populateFloatProbabilityMap(this.damageReductionFireProbability, template.getNode("damage_reduction_fire"), levelIndex, nextLevelIndex, distance);
        RandomUtils.populateFloatProbabilityMap(this.damageReductionExplosionsProbability, template.getNode("damage_reduction_explosions"), levelIndex, nextLevelIndex, distance);
        RandomUtils.populateIntegerProbabilityMap(this.xpRegenerationProbability, template.getNode("xp_regeneration"), levelIndex, nextLevelIndex, distance);
        RandomUtils.populateIntegerProbabilityMap(this.xpMaxProbability, template.getNode("xp_max"), levelIndex, nextLevelIndex, distance);
        RandomUtils.populateIntegerProbabilityMap(this.healthRegenerationProbability, template.getNode("health_regeneration"), levelIndex, nextLevelIndex, distance);
        RandomUtils.populateIntegerProbabilityMap(this.hungerRegenerationProbability, template.getNode("hunger_regeneration"), levelIndex, nextLevelIndex, distance);
        RandomUtils.populateFloatProbabilityMap(this.hasteProbability, template.getNode("haste"), levelIndex, nextLevelIndex, distance);
    }

    private void randomizeWand(Wand wand, boolean additive) {
        int hungerRegeneration;
        int healthRegeneration;
        int xpMax;
        int xpRegeneration;
        float damageReductionExplosions;
        float damageReductionFire;
        float damageReductionFalling;
        float damageReductionProjectiles;
        float damageReductionPhysical;
        float damageReduction;
        Spell firstSpell = null;
        Integer spellCount = (Integer)RandomUtils.weightedRandom(this.spellCountProbability);
        int retries = 30;
        int i = 0;
        while (i < spellCount) {
            String spellKey = (String)RandomUtils.weightedRandom(this.spellProbability);
            if (wand.addSpell(spellKey)) {
                if (firstSpell == null) {
                    firstSpell = wand.getMaster().getSpell(spellKey);
                }
            } else if (retries-- > 0) {
                --i;
            }
            ++i;
        }
        ConfigurationNode wandProperties = new ConfigurationNode();
        float costReduction = wand.getCostReduction();
        if (costReduction < 0.9f) {
            wandProperties.setProperty("cost_reduction", Math.min(0.9f, costReduction + ((Float)RandomUtils.weightedRandom(this.costReductionProbability)).floatValue()));
        }
        if ((damageReduction = wand.getDamageReduction()) < 0.9f) {
            wandProperties.setProperty("damage_reduction", Math.min(0.9f, damageReduction + ((Float)RandomUtils.weightedRandom(this.damageReductionProbability)).floatValue()));
        }
        if ((damageReductionPhysical = wand.getDamageReductionPhysical()) < 0.9f) {
            wandProperties.setProperty("damage_reduction_physical", Math.min(0.9f, damageReductionPhysical + ((Float)RandomUtils.weightedRandom(this.damageReductionPhysicalProbability)).floatValue()));
        }
        if ((damageReductionProjectiles = wand.getDamageReductionProjectiles()) < 0.9f) {
            wandProperties.setProperty("damage_reduction_projectiles", Math.min(0.9f, damageReductionProjectiles + ((Float)RandomUtils.weightedRandom(this.damageReductionProjectilesProbability)).floatValue()));
        }
        if ((damageReductionFalling = wand.getDamageReductionFalling()) < 0.9f) {
            wandProperties.setProperty("damage_reduction_falling", Math.min(0.9f, damageReductionFalling + ((Float)RandomUtils.weightedRandom(this.damageReductionFallingProbability)).floatValue()));
        }
        if ((damageReductionFire = wand.getDamageReductionFire()) < 0.9f) {
            wandProperties.setProperty("damage_reduction_fire", Math.min(0.9f, damageReductionFire + ((Float)RandomUtils.weightedRandom(this.damageReductionFireProbability)).floatValue()));
        }
        if ((damageReductionExplosions = wand.getDamageReductionExplosions()) < 0.9f) {
            wandProperties.setProperty("damage_reduction_explosions", Math.min(0.9f, damageReductionExplosions + ((Float)RandomUtils.weightedRandom(this.damageReductionExplosionsProbability)).floatValue()));
        }
        if ((xpRegeneration = wand.getXpRegeneration()) < 100) {
            wandProperties.setProperty("xp_regeneration", Math.min(100, xpRegeneration + (Integer)RandomUtils.weightedRandom(this.xpRegenerationProbability)));
        }
        if ((xpMax = wand.getXpMax()) < 10000) {
            wandProperties.setProperty("xp_max", Math.min(10000, xpMax + (Integer)RandomUtils.weightedRandom(this.xpMaxProbability)));
        }
        if ((healthRegeneration = wand.getHealthRegeneration()) < 20) {
            wandProperties.setProperty("health_regeneration", Math.min(20, healthRegeneration + (Integer)RandomUtils.weightedRandom(this.healthRegenerationProbability)));
        }
        if ((hungerRegeneration = wand.getHungerRegeneration()) < 20) {
            wandProperties.setProperty("hunger_regeneration", Math.min(20, hungerRegeneration + (Integer)RandomUtils.weightedRandom(this.hungerRegenerationProbability)));
        }
        if (additive) {
            int wandUses = wand.getUses();
            if (wandUses > 0 && wandUses < 500) {
                wandProperties.setProperty("uses", Math.min(500, wandUses + (Integer)RandomUtils.weightedRandom(this.addUseProbability)));
            }
        } else {
            wandProperties.setProperty("uses", Math.min(500, (Integer)RandomUtils.weightedRandom(this.useProbability)));
            String spellName = "Nothing";
            if (firstSpell != null) {
                spellName = firstSpell.getName();
            }
            String updatedName = wand.getName();
            wand.setName(updatedName.replace("{Spell}", spellName));
        }
        wand.configureProperties(wandProperties);
    }

    public static void randomizeWand(Wand wand, boolean additive, int level) {
        WandLevel wandLevel = WandLevel.getLevel(level);
        wandLevel.randomizeWand(wand, additive);
    }

    public static Set<Integer> getLevels() {
        if (levels == null) {
            return null;
        }
        return levelMap.keySet();
    }
}

