/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic;

import com.elmakers.mine.bukkit.plugins.magic.CastingCost;
import com.elmakers.mine.bukkit.plugins.magic.CostReducer;
import com.elmakers.mine.bukkit.plugins.magic.PlayerSpells;
import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.plugins.magic.Spells;
import com.elmakers.mine.bukkit.plugins.magic.WandLevel;
import com.elmakers.mine.bukkit.utilities.InventoryUtils;
import com.elmakers.mine.bukkit.utilities.borrowed.Configuration;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import java.io.File;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Wand
implements CostReducer {
    private ItemStack item;
    private Spells spells;
    private PlayerSpells activePlayer;
    private String id;
    private String wandSpells = "";
    private String wandMaterials = "";
    private String activeSpell = "";
    private String activeMaterial = "";
    private String wandName = "";
    private float costReduction = 0.0f;
    private float cooldownReduction = 0.0f;
    private float damageReduction = 0.0f;
    private float damageReductionPhysical = 0.0f;
    private float damageReductionProjectiles = 0.0f;
    private float damageReductionFalling = 0.0f;
    private float damageReductionFire = 0.0f;
    private float damageReductionExplosions = 0.0f;
    private boolean hasInventory = false;
    private int uses = 0;
    private int xpRegeneration = 0;
    private int xpMax = 50;
    private int healthRegeneration = 0;
    private int hungerRegeneration = 0;
    private float walkSpeedIncrease = 0.0f;
    private int accumulatedXp = 0;
    private static DecimalFormat floatFormat = new DecimalFormat("#.###");
    public static Material WandMaterial = Material.BLAZE_ROD;
    public static Material EnchantableWandMaterial = Material.WOOD_SWORD;
    public static Material EraseMaterial = Material.SULPHUR;
    public static Material CopyMaterial = Material.PUMPKIN_SEEDS;
    protected static Map<String, ConfigurationNode> wandTemplates = new HashMap<String, ConfigurationNode>();
    private static final String propertiesFileName = "wands.yml";
    private static final String propertiesFileNameDefaults = "wands.defaults.yml";
    private static final String defaultWandName = "Wand";

    public Wand(Spells spells) {
        this.spells = spells;
        this.item = new ItemStack(WandMaterial);
        this.item = InventoryUtils.getCopy(this.item);
        ItemMeta itemMeta = this.item.getItemMeta();
        this.item.setItemMeta(itemMeta);
        InventoryUtils.addGlow(this.item);
        this.id = UUID.randomUUID().toString();
        this.wandName = defaultWandName;
        this.updateName();
        this.saveState();
    }

    public Wand(Spells spells, ItemStack item) {
        this.item = item;
        this.spells = spells;
        this.loadState();
    }

    public void setActiveSpell(String activeSpell) {
        this.activeSpell = activeSpell;
        this.updateName();
        this.updateInventoryNames();
        this.saveState();
    }

    public void setActiveMaterial(Material material, byte data) {
        this.activeMaterial = material == CopyMaterial ? "-1:0" : (material == EraseMaterial ? "0:0" : String.valueOf(material.getId()) + ":" + data);
        this.updateName();
        this.updateActiveMaterial();
        this.updateInventoryNames();
        this.saveState();
    }

    public int getXpRegeneration() {
        return this.xpRegeneration;
    }

    public int getXpMax() {
        return this.xpMax;
    }

    public int getHealthRegeneration() {
        return this.healthRegeneration;
    }

    public int getHungerRegeneration() {
        return this.hungerRegeneration;
    }

    @Override
    public float getCostReduction() {
        return this.costReduction;
    }

    public float getCooldownReduction() {
        return this.costReduction;
    }

    public boolean getHasInventory() {
        return this.hasInventory;
    }

    public float getDamageReduction() {
        return this.damageReduction;
    }

    public float getDamageReductionPhysical() {
        return this.damageReductionPhysical;
    }

    public float getDamageReductionProjectiles() {
        return this.damageReductionProjectiles;
    }

    public float getDamageReductionFalling() {
        return this.damageReductionFalling;
    }

    public float getDamageReductionFire() {
        return this.damageReductionFire;
    }

    public float getDamageReductionExplosions() {
        return this.damageReductionExplosions;
    }

    public int getUses() {
        return this.uses;
    }

    public String getName() {
        return this.wandName;
    }

    protected void setName(String name) {
        this.wandName = name;
        this.updateName();
    }

    public ItemStack getItem() {
        return this.item;
    }

    public void setItem(ItemStack item) {
        this.item = item;
    }

    protected void saveState() {
        Object wandNode = InventoryUtils.createNode(this.item, "wand");
        InventoryUtils.setMeta(wandNode, "id", this.id);
        InventoryUtils.setMeta(wandNode, "materials", this.wandMaterials);
        InventoryUtils.setMeta(wandNode, "spells", this.wandSpells);
        InventoryUtils.setMeta(wandNode, "active_spell", this.activeSpell);
        InventoryUtils.setMeta(wandNode, "active_material", this.activeMaterial);
        InventoryUtils.setMeta(wandNode, "name", this.wandName);
        InventoryUtils.setMeta(wandNode, "cost_reduction", floatFormat.format(this.costReduction));
        InventoryUtils.setMeta(wandNode, "cooldown_reduction", floatFormat.format(this.cooldownReduction));
        InventoryUtils.setMeta(wandNode, "damage_reduction", floatFormat.format(this.damageReduction));
        InventoryUtils.setMeta(wandNode, "damage_reduction_physical", floatFormat.format(this.damageReductionPhysical));
        InventoryUtils.setMeta(wandNode, "damage_reduction_projectiles", floatFormat.format(this.damageReductionProjectiles));
        InventoryUtils.setMeta(wandNode, "damage_reduction_falling", floatFormat.format(this.damageReductionFalling));
        InventoryUtils.setMeta(wandNode, "damage_reduction_fire", floatFormat.format(this.damageReductionFire));
        InventoryUtils.setMeta(wandNode, "damage_reduction_explosions", floatFormat.format(this.damageReductionExplosions));
        InventoryUtils.setMeta(wandNode, "cooldown_reduction", floatFormat.format(this.cooldownReduction));
        InventoryUtils.setMeta(wandNode, "haste", floatFormat.format(this.walkSpeedIncrease));
        InventoryUtils.setMeta(wandNode, "xp_regeneration", Integer.toString(this.xpRegeneration));
        InventoryUtils.setMeta(wandNode, "xp_max", Integer.toString(this.xpMax));
        InventoryUtils.setMeta(wandNode, "health_regeneration", Integer.toString(this.healthRegeneration));
        InventoryUtils.setMeta(wandNode, "hunger_regeneration", Integer.toString(this.hungerRegeneration));
        InventoryUtils.setMeta(wandNode, "uses", Integer.toString(this.uses));
        InventoryUtils.setMeta(wandNode, "has_inventory", Integer.toString(this.hasInventory ? 1 : 0));
    }

    protected void loadOldState(ItemStack item) {
        String[] wandPairs;
        this.id = InventoryUtils.getMeta(item, "magic_wand_id");
        this.id = this.id == null || this.id.length() == 0 ? UUID.randomUUID().toString() : this.id;
        String wandSettings = InventoryUtils.getMeta(item, "magic_wand");
        wandSettings = wandSettings == null ? "" : wandSettings;
        this.wandMaterials = InventoryUtils.getMeta(item, "magic_materials");
        this.wandMaterials = this.wandMaterials == null ? "" : this.wandMaterials;
        this.wandSpells = InventoryUtils.getMeta(item, "magic_spells");
        this.wandSpells = this.wandSpells == null ? "" : this.wandSpells;
        this.activeSpell = InventoryUtils.getMeta(item, "magic_active_spell");
        this.activeSpell = this.activeSpell == null ? "" : this.activeSpell;
        this.activeMaterial = InventoryUtils.getMeta(item, "magic_active_material");
        this.activeMaterial = this.activeMaterial == null ? "" : this.activeMaterial;
        this.wandName = InventoryUtils.getMeta(item, "magic_wand_name");
        this.wandName = this.wandName == null ? defaultWandName : this.wandName;
        String[] stringArray = wandPairs = StringUtils.split((String)wandSettings, (String)"&");
        int n = wandPairs.length;
        int n2 = 0;
        while (n2 < n) {
            String pair = stringArray[n2];
            String[] keyValue = StringUtils.split((String)pair, (String)"=");
            if (keyValue.length == 2) {
                String key = keyValue[0];
                float value = Float.parseFloat(keyValue[1]);
                if (key.equalsIgnoreCase("cr")) {
                    this.costReduction = value;
                } else if (key.equalsIgnoreCase("cdr")) {
                    this.cooldownReduction = value;
                } else if (key.equalsIgnoreCase("dr")) {
                    this.damageReduction = value;
                } else if (key.equalsIgnoreCase("drph")) {
                    this.damageReductionPhysical = value;
                } else if (key.equalsIgnoreCase("drpr")) {
                    this.damageReductionProjectiles = value;
                } else if (key.equalsIgnoreCase("drfa")) {
                    this.damageReductionFalling = value;
                } else if (key.equalsIgnoreCase("drfi")) {
                    this.damageReductionFire = value;
                } else if (key.equalsIgnoreCase("drex")) {
                    this.damageReductionExplosions = value;
                } else if (key.equalsIgnoreCase("uses")) {
                    this.uses = (int)value;
                } else if (key.equalsIgnoreCase("xpre")) {
                    this.xpRegeneration = (int)value;
                } else if (key.equalsIgnoreCase("xpmax")) {
                    this.xpMax = (int)value;
                } else if (key.equalsIgnoreCase("hereg")) {
                    this.healthRegeneration = (int)value;
                } else if (key.equalsIgnoreCase("hureg")) {
                    this.hungerRegeneration = (int)value;
                } else if (key.equalsIgnoreCase("hasi")) {
                    this.hasInventory = (int)value != 0;
                }
            }
            ++n2;
        }
    }

    protected void loadState() {
        Object wandNode = InventoryUtils.getNode(this.item, "wand");
        if (wandNode == null) {
            this.loadOldState(this.item);
            return;
        }
        this.id = InventoryUtils.getMeta(wandNode, "id");
        this.id = this.id == null || this.id.length() == 0 ? UUID.randomUUID().toString() : this.id;
        this.wandMaterials = InventoryUtils.getMeta(wandNode, "materials", this.wandMaterials);
        this.wandSpells = InventoryUtils.getMeta(wandNode, "spells", this.wandSpells);
        this.activeSpell = InventoryUtils.getMeta(wandNode, "active_spell", this.activeSpell);
        this.activeMaterial = InventoryUtils.getMeta(wandNode, "active_material", this.activeMaterial);
        this.wandName = InventoryUtils.getMeta(wandNode, "name", this.wandName);
        this.costReduction = Float.parseFloat(InventoryUtils.getMeta(wandNode, "cost_reduction", floatFormat.format(this.costReduction)));
        this.cooldownReduction = Float.parseFloat(InventoryUtils.getMeta(wandNode, "cooldown_reduction", floatFormat.format(this.cooldownReduction)));
        this.damageReduction = Float.parseFloat(InventoryUtils.getMeta(wandNode, "damage_reduction", floatFormat.format(this.damageReduction)));
        this.damageReductionPhysical = Float.parseFloat(InventoryUtils.getMeta(wandNode, "damage_reduction_physical", floatFormat.format(this.damageReductionPhysical)));
        this.damageReductionProjectiles = Float.parseFloat(InventoryUtils.getMeta(wandNode, "damage_reduction_projectiles", floatFormat.format(this.damageReductionProjectiles)));
        this.damageReductionFalling = Float.parseFloat(InventoryUtils.getMeta(wandNode, "damage_reduction_falling", floatFormat.format(this.damageReductionFalling)));
        this.damageReductionFire = Float.parseFloat(InventoryUtils.getMeta(wandNode, "damage_reduction_fire", floatFormat.format(this.damageReductionFire)));
        this.damageReductionExplosions = Float.parseFloat(InventoryUtils.getMeta(wandNode, "damage_reduction_explosions", floatFormat.format(this.damageReductionExplosions)));
        this.cooldownReduction = Float.parseFloat(InventoryUtils.getMeta(wandNode, "cooldown_reduction", floatFormat.format(this.cooldownReduction)));
        this.walkSpeedIncrease = Float.parseFloat(InventoryUtils.getMeta(wandNode, "haste", floatFormat.format(this.walkSpeedIncrease)));
        this.xpRegeneration = Integer.parseInt(InventoryUtils.getMeta(wandNode, "xp_regeneration", Integer.toString(this.xpRegeneration)));
        this.xpMax = Integer.parseInt(InventoryUtils.getMeta(wandNode, "xp_max", Integer.toString(this.xpMax)));
        this.healthRegeneration = Integer.parseInt(InventoryUtils.getMeta(wandNode, "health_regeneration", Integer.toString(this.healthRegeneration)));
        this.hungerRegeneration = Integer.parseInt(InventoryUtils.getMeta(wandNode, "hunger_regeneration", Integer.toString(this.hungerRegeneration)));
        this.uses = Integer.parseInt(InventoryUtils.getMeta(wandNode, "uses", Integer.toString(this.uses)));
        this.hasInventory = Integer.parseInt(InventoryUtils.getMeta(wandNode, "has_inventory", this.hasInventory ? "1" : "0")) != 0;
        this.walkSpeedIncrease = Math.min(WandLevel.maxWalkSpeedIncrease, this.walkSpeedIncrease);
    }

    public void removeMaterial(Material material, byte data) {
        Integer id = material.getId();
        String materialString = id.toString();
        materialString = String.valueOf(materialString) + ":" + data;
        String[] materials = this.getMaterials();
        LinkedList<String> materialMap = new LinkedList<String>();
        int i = 0;
        while (i < materials.length) {
            String[] pieces = StringUtils.split((String)materials[i], (String)"@");
            if (pieces.length > 0 && !pieces[0].equals(materialString)) {
                materialMap.add(materials[i]);
            }
            ++i;
        }
        this.setMaterials(materialMap);
        if (materialString.equalsIgnoreCase(this.activeMaterial)) {
            this.activeMaterial = "";
            this.updateActiveMaterial();
            this.updateName();
            if (this.isInventoryOpen()) {
                this.updateInventory();
            }
        }
    }

    public boolean addMaterial(Material material, byte data) {
        return this.addMaterial(material, data, true);
    }

    private boolean addMaterial(Material material, byte data, boolean makeActive) {
        Integer id = material.getId();
        String materialString = id.toString();
        if (material == EraseMaterial) {
            materialString = "0";
        } else if (material == CopyMaterial) {
            materialString = "-1";
        }
        materialString = String.valueOf(materialString) + ":" + data;
        String[] materials = this.getMaterials();
        TreeSet<String> materialMap = new TreeSet<String>();
        int i = 0;
        while (i < materials.length) {
            String[] pieces = StringUtils.split((String)materials[i], (String)"@");
            if (pieces.length > 0 && !pieces[0].equals(materialString)) {
                materialMap.add(materials[i]);
            }
            ++i;
        }
        if (makeActive || this.activeMaterial == null || this.activeMaterial.length() == 0) {
            this.activeMaterial = materialString;
        }
        boolean addedNew = !materialMap.contains(materialString);
        materialMap.add(materialString);
        this.setMaterials(materialMap);
        this.updateActiveMaterial();
        this.updateName();
        if (this.isInventoryOpen()) {
            this.updateInventory();
        }
        return addedNew;
    }

    private void setMaterials(Collection<String> materialNames) {
        this.wandMaterials = StringUtils.join(materialNames, (String)"|");
        this.setMaterialCount(materialNames.size());
        String[] spellNames = this.getSpells();
        this.hasInventory = spellNames.length + materialNames.size() > 1;
        this.saveState();
    }

    public String[] getMaterials() {
        return StringUtils.split((String)this.wandMaterials, (String)"|");
    }

    private boolean addSpells(Collection<String> spellNames) {
        String[] spells = this.getSpells();
        TreeSet<String> spellMap = new TreeSet<String>();
        boolean addedNew = false;
        String[] stringArray = spells;
        int n = spells.length;
        int n2 = 0;
        while (n2 < n) {
            String spell = stringArray[n2];
            spellMap.add(spell);
            ++n2;
        }
        for (String spellName : spellNames) {
            if (this.activeSpell == null || this.activeSpell.length() == 0) {
                this.activeSpell = spellName;
            }
            if (!spellMap.contains(spellName)) {
                addedNew = true;
            }
            spellMap.add(spellName);
            addedNew = true;
        }
        this.setSpells(spellMap);
        return addedNew;
    }

    public String[] getSpells() {
        return StringUtils.split((String)this.wandSpells, (String)"|");
    }

    public void removeSpell(String spellName) {
        String[] spells = this.getSpells();
        LinkedList<String> spellMap = new LinkedList<String>();
        int i = 0;
        while (i < spells.length) {
            String[] pieces = StringUtils.split((String)spells[i], (String)"@");
            if (pieces.length > 0 && !pieces[0].equals(spellName)) {
                spellMap.add(spells[i]);
            }
            ++i;
        }
        this.setSpells(spellMap);
        if (spellName.equalsIgnoreCase(this.activeSpell)) {
            this.activeSpell = "";
            this.updateName();
            if (this.isInventoryOpen()) {
                this.updateInventory();
            }
        }
    }

    public boolean addSpell(String spellName) {
        this.activeSpell = spellName;
        ArrayList<String> names = new ArrayList<String>();
        names.add(spellName);
        boolean addedNew = this.addSpells(names);
        this.updateName();
        if (this.isInventoryOpen()) {
            this.updateInventory();
        }
        return addedNew;
    }

    private void setSpells(Collection<String> spellNames) {
        this.wandSpells = StringUtils.join(spellNames, (String)"|");
        this.setSpellCount(spellNames.size());
        String[] materials = this.getMaterials();
        this.hasInventory = spellNames.size() + materials.length > 1;
        this.saveState();
    }

    private void setSpellCount(int spellCount) {
        this.updateLore(spellCount, this.getMaterials().length);
    }

    private void setMaterialCount(int materialCount) {
        this.updateLore(this.getSpells().length, materialCount);
    }

    private String getActiveWandName(Spell spell, String materialName) {
        int remaining;
        String name = this.wandName;
        if (this.hasInventory && spell != null) {
            if (materialName != null) {
                materialName = materialName.replace('_', ' ');
                name = ChatColor.GOLD + spell.getName() + ChatColor.GRAY + " " + materialName + ChatColor.WHITE + " (" + this.wandName + ")";
            } else {
                name = ChatColor.GOLD + spell.getName() + ChatColor.WHITE + " (" + this.wandName + ")";
            }
        }
        if ((remaining = this.getRemainingUses()) > 0) {
            name = String.valueOf(name) + " : " + ChatColor.RED + remaining + " Uses ";
        }
        return name;
    }

    private String getActiveWandName(Spell spell) {
        String[] pieces = StringUtils.split((String)this.activeMaterial, (String)":");
        String materialName = null;
        if (spell != null && spell.usesMaterial() && !spell.hasMaterialOverride() && pieces.length > 0 && pieces[0].length() > 0) {
            int materialId = Integer.parseInt(pieces[0]);
            if (materialId == 0) {
                materialName = "erase";
            } else if (materialId == -1) {
                materialName = "copy";
            } else {
                Material material = Material.getMaterial((int)materialId);
                materialName = material.name().toLowerCase();
            }
        }
        return this.getActiveWandName(spell, materialName);
    }

    private String getActiveWandName(Material material) {
        Spell spell = this.spells.getSpell(this.activeSpell);
        String materialName = null;
        if (spell != null && spell.usesMaterial() && !spell.hasMaterialOverride() && material != null) {
            materialName = material == EraseMaterial ? "erase" : (material == CopyMaterial ? "copy" : material.name().toLowerCase());
        }
        return this.getActiveWandName(spell, materialName);
    }

    private String getActiveWandName() {
        Spell spell = this.spells.getSpell(this.activeSpell);
        return this.getActiveWandName(spell);
    }

    public void updateName(boolean isActive) {
        ItemMeta meta = this.item.getItemMeta();
        meta.setDisplayName(isActive ? this.getActiveWandName() : this.wandName);
        this.item.setItemMeta(meta);
        InventoryUtils.addGlow(this.item);
        this.saveState();
    }

    private void updateName() {
        this.updateName(true);
    }

    private String getLevelString(String prefix, float amount) {
        String suffix = "I";
        if (amount >= 1.0f) {
            suffix = "X";
        } else if ((double)amount > 0.8) {
            suffix = "V";
        } else if ((double)amount > 0.6) {
            suffix = "IV";
        } else if ((double)amount > 0.4) {
            suffix = "III";
        } else if ((double)amount > 0.2) {
            suffix = "II";
        }
        return String.valueOf(prefix) + " " + suffix;
    }

    private void updateLore() {
        this.updateLore(this.getSpells().length, this.getMaterials().length);
    }

    private void updateLore(int spellCount, int materialCount) {
        ItemMeta meta = this.item.getItemMeta();
        ArrayList<String> lore = new ArrayList<String>();
        Spell spell = this.spells.getSpell(this.activeSpell);
        if (spell != null && spellCount == 1 && materialCount <= 1) {
            this.addSpellLore(spell, lore);
        } else {
            lore.add("Knows " + spellCount + " Spells");
            if (materialCount > 0) {
                lore.add("Has " + materialCount + " Materials");
            }
        }
        int remaining = this.getRemainingUses();
        if (remaining > 0) {
            lore.add(ChatColor.RED + remaining + " Uses Remaining");
        }
        if (this.costReduction > 0.0f) {
            lore.add(ChatColor.GOLD + this.getLevelString("Cost Reduction", this.costReduction));
        }
        if (this.cooldownReduction > 0.0f) {
            lore.add(ChatColor.GOLD + this.getLevelString("Cooldown Reduction", this.cooldownReduction));
        }
        if (this.walkSpeedIncrease > 0.0f) {
            lore.add(ChatColor.GOLD + this.getLevelString("Haste", this.walkSpeedIncrease / WandLevel.maxWalkSpeedIncrease));
        }
        if (this.xpRegeneration > 0) {
            lore.add(ChatColor.GOLD + this.getLevelString("XP Regeneration", this.xpRegeneration / 100));
        }
        if (this.damageReduction > 0.0f) {
            lore.add(ChatColor.GOLD + this.getLevelString("Protection", this.damageReduction));
        }
        if (this.damageReduction < 1.0f) {
            if (this.damageReductionPhysical > 0.0f) {
                lore.add(ChatColor.GOLD + this.getLevelString("Physical Protection", this.damageReductionPhysical));
            }
            if (this.damageReductionProjectiles > 0.0f) {
                lore.add(ChatColor.GOLD + this.getLevelString("Projectile Protection", this.damageReductionProjectiles));
            }
            if (this.damageReductionFalling > 0.0f) {
                lore.add(ChatColor.GOLD + this.getLevelString("Fall Protection", this.damageReductionFalling));
            }
            if (this.damageReductionFire > 0.0f) {
                lore.add(ChatColor.GOLD + this.getLevelString("Fire Protection", this.damageReductionFire));
            }
            if (this.damageReductionExplosions > 0.0f) {
                lore.add(ChatColor.GOLD + this.getLevelString("Blast Protection", this.damageReductionExplosions));
            }
        }
        if (this.healthRegeneration > 0) {
            lore.add(ChatColor.GOLD + this.getLevelString("Health Regeneration", this.healthRegeneration / 20));
        }
        if (this.hungerRegeneration > 0) {
            lore.add(ChatColor.GOLD + this.getLevelString("Anti-Hunger", this.hungerRegeneration / 20));
        }
        meta.setLore(lore);
        this.item.setItemMeta(meta);
        InventoryUtils.addGlow(this.item);
        this.saveState();
    }

    public int getRemainingUses() {
        int remaining = 0;
        if (this.uses > 0) {
            short durability = this.item.getDurability();
            remaining = Math.max(0, this.uses - durability);
        }
        return remaining;
    }

    public void makeEnchantable(boolean enchantable) {
        this.item.setType(enchantable ? EnchantableWandMaterial : WandMaterial);
        this.updateName();
    }

    public static boolean hasActiveWand(Player player) {
        ItemStack activeItem = player.getInventory().getItemInHand();
        return Wand.isWand(activeItem);
    }

    public static Wand getActiveWand(Spells spells, Player player) {
        ItemStack activeItem = player.getInventory().getItemInHand();
        if (Wand.isWand(activeItem)) {
            return new Wand(spells, activeItem);
        }
        return null;
    }

    public static boolean isWand(ItemStack item) {
        return !(item == null || item.getType() != WandMaterial && item.getType() != EnchantableWandMaterial || !InventoryUtils.hasMeta(item, "wand") && !InventoryUtils.hasMeta(item, "magic_wand"));
    }

    public static boolean isSpell(ItemStack item) {
        return item != null && item.getType() != WandMaterial && InventoryUtils.hasMeta(item, "spell");
    }

    protected void updateInventory() {
        if (this.activePlayer == null) {
            return;
        }
        this.updateInventory(this.activePlayer.getPlayer().getInventory().getHeldItemSlot());
    }

    protected void updateInventoryNames() {
        ItemStack[] contents;
        if (this.activePlayer == null || !this.isInventoryOpen()) {
            return;
        }
        ItemStack[] itemStackArray = contents = this.activePlayer.getPlayer().getInventory().getContents();
        int n = contents.length;
        int n2 = 0;
        while (n2 < n) {
            ItemStack item = itemStackArray[n2];
            if (item != null && item.getType() != Material.AIR && !Wand.isWand(item)) {
                this.updateInventoryName(item);
            }
            ++n2;
        }
    }

    protected void updateInventoryName(ItemStack item) {
        if (Wand.isSpell(item)) {
            Spell spell = this.activePlayer.getSpell(item.getType());
            if (spell != null) {
                this.updateSpellName(item, spell);
            }
        } else {
            this.updateMaterialName(item);
        }
    }

    protected void updateSpellName(ItemStack itemStack, Spell spell) {
        ItemMeta meta = itemStack.getItemMeta();
        meta.setDisplayName(this.getActiveWandName(spell));
        ArrayList<String> lore = new ArrayList<String>();
        this.addSpellLore(spell, lore);
        meta.setLore(lore);
        itemStack.setItemMeta(meta);
        InventoryUtils.addGlow(itemStack);
        Object spellNode = InventoryUtils.createNode(itemStack, "spell");
        InventoryUtils.setMeta(spellNode, "key", spell.getKey());
    }

    protected void updateMaterialName(ItemStack itemStack) {
        ItemMeta meta = itemStack.getItemMeta();
        meta.setDisplayName(this.getActiveWandName(itemStack.getType()));
        itemStack.setItemMeta(meta);
    }

    /*
     * WARNING - void declaration
     */
    private void updateInventory(int itemSlot) {
        void var11_14;
        if (this.activePlayer == null) {
            return;
        }
        Player player = this.activePlayer.getPlayer();
        PlayerInventory inventory = player.getInventory();
        inventory.clear();
        inventory.setItem(itemSlot, this.item);
        String[] spells = StringUtils.split((String)this.wandSpells, (String)"|");
        LinkedList<ItemStack> unpositionedSpells = new LinkedList<ItemStack>();
        int i = 0;
        while (i < spells.length) {
            String[] parts = StringUtils.split((String)spells[i], (String)"@");
            String spellName = parts[0];
            Spell spell = this.activePlayer.getSpell(spellName);
            if (spell != null) {
                int n;
                ItemStack itemStack = new ItemStack(spell.getMaterial(), 1);
                itemStack = InventoryUtils.getCopy(itemStack);
                this.updateSpellName(itemStack, spell);
                int n2 = n = parts.length > 1 ? Integer.parseInt(parts[1]) : itemSlot;
                if (parts.length > 1 && n != itemSlot) {
                    inventory.setItem(n, itemStack);
                } else {
                    unpositionedSpells.add(itemStack);
                }
            }
            ++i;
        }
        String[] materials = StringUtils.split((String)this.wandMaterials, (String)"|");
        LinkedList<ItemStack> unpositionedMaterials = new LinkedList<ItemStack>();
        HashMap<Integer, ItemStack> positioned = new HashMap<Integer, ItemStack>();
        ItemStack eraseStack = null;
        ItemStack copyStack = null;
        boolean bl = false;
        while (var11_14 < materials.length) {
            ArrayList<String> lore;
            String[] parts = StringUtils.split((String)materials[var11_14], (String)"@");
            String[] nameParts = StringUtils.split((String)parts[0], (String)":");
            int typeId = Integer.parseInt(nameParts[0]);
            if (typeId == 0) {
                typeId = EraseMaterial.getId();
            } else if (typeId == -1) {
                typeId = CopyMaterial.getId();
            }
            int dataId = nameParts.length > 1 ? Integer.parseInt(nameParts[1]) : 0;
            ItemStack itemStack = new ItemStack(typeId, 1, 0, Byte.valueOf((byte)dataId));
            itemStack = InventoryUtils.getCopy(itemStack);
            ItemMeta meta = itemStack.getItemMeta();
            if (typeId == EraseMaterial.getId()) {
                lore = new ArrayList<String>();
                lore.add("Fills with Air");
                meta.setLore(lore);
            } else if (typeId == CopyMaterial.getId()) {
                lore = new ArrayList();
                lore.add("Fills with the target material");
                meta.setLore(lore);
            } else {
                lore = new ArrayList();
                lore.add("Magic building material");
                meta.setLore(lore);
            }
            meta.setDisplayName(this.getActiveWandName(Material.getMaterial((int)typeId)));
            itemStack.setItemMeta(meta);
            int slot = parts.length > 1 ? Integer.parseInt(parts[1]) : itemSlot;
            ItemStack existing = inventory.getItem(slot);
            if (parts.length > 1 && slot != itemSlot && (existing == null || existing.getType() == Material.AIR)) {
                positioned.put(slot, itemStack);
            } else if (itemStack.getType() == EraseMaterial) {
                eraseStack = itemStack;
            } else if (itemStack.getType() == CopyMaterial) {
                copyStack = itemStack;
            } else {
                unpositionedMaterials.add(itemStack);
            }
            ++var11_14;
        }
        if (unpositionedMaterials.size() > 0) {
            int n = Math.min(unpositionedMaterials.size(), 3);
            int remainingSpaces = 8 - n;
            while (unpositionedSpells.size() > 0 && remainingSpaces > 0) {
                inventory.addItem(new ItemStack[]{(ItemStack)unpositionedSpells.remove()});
                --remainingSpaces;
            }
        }
        if (eraseStack != null) {
            Wand.addMaterialToInventory((Inventory)inventory, eraseStack);
        }
        if (copyStack != null) {
            Wand.addMaterialToInventory((Inventory)inventory, copyStack);
        }
        for (ItemStack itemStack : unpositionedMaterials) {
            Wand.addMaterialToInventory((Inventory)inventory, itemStack);
        }
        for (ItemStack itemStack : unpositionedSpells) {
            inventory.addItem(new ItemStack[]{itemStack});
        }
        for (Map.Entry entry : positioned.entrySet()) {
            int slot = (Integer)entry.getKey();
            ItemStack itemStack = (ItemStack)entry.getValue();
            ItemStack existing = inventory.getItem(slot);
            if (slot != itemSlot && (existing == null || existing.getType() == Material.AIR)) {
                inventory.setItem(slot, itemStack);
                continue;
            }
            Wand.addMaterialToInventory((Inventory)inventory, itemStack);
        }
        this.updateName();
        player.updateInventory();
    }

    protected void addSpellLore(Spell spell, List<String> lore) {
        lore.add(spell.getDescription());
        List<CastingCost> costs = spell.getCosts();
        if (costs != null) {
            for (CastingCost cost : costs) {
                if (!cost.hasCosts(this)) continue;
                lore.add(ChatColor.YELLOW + "Costs " + cost.getFullDescription(this));
            }
        }
    }

    private static void addMaterialToInventory(Inventory inventory, ItemStack stack) {
        int i = 8;
        while (i >= 0) {
            ItemStack existing = inventory.getItem(i);
            if (existing == null || existing.getType() == Material.AIR) {
                inventory.setItem(i, stack);
                return;
            }
            --i;
        }
        inventory.addItem(new ItemStack[]{stack});
    }

    public void saveInventory() {
        Integer position;
        String[] pieces;
        if (this.activePlayer == null) {
            return;
        }
        PlayerInventory inventory = this.activePlayer.getPlayer().getInventory();
        String[] currentSpells = this.getSpells();
        String[] currentMaterials = this.getMaterials();
        HashMap<String, Integer> spellMap = new HashMap<String, Integer>();
        HashMap<String, Integer> materialMap = new HashMap<String, Integer>();
        String[] stringArray = currentSpells;
        int n = currentSpells.length;
        int n2 = 0;
        while (n2 < n) {
            String spell = stringArray[n2];
            pieces = StringUtils.split((String)spell, (String)"@");
            position = pieces.length > 1 ? Integer.valueOf(Integer.parseInt(pieces[1])) : null;
            spellMap.put(pieces[0], position);
            ++n2;
        }
        stringArray = currentMaterials;
        n = currentMaterials.length;
        n2 = 0;
        while (n2 < n) {
            String material = stringArray[n2];
            pieces = StringUtils.split((String)material, (String)"@");
            position = pieces.length > 1 ? Integer.valueOf(Integer.parseInt(pieces[1])) : null;
            materialMap.put(pieces[0], position);
            ++n2;
        }
        ItemStack[] items = inventory.getContents();
        int i = 0;
        while (i < items.length) {
            if (items[i] != null && !Wand.isWand(items[i])) {
                Material material = items[i].getType();
                if (Wand.isSpell(items[i])) {
                    Spell spell = this.activePlayer.getSpell(material);
                    if (spell != null && spellMap.containsKey(spell.getKey())) {
                        spellMap.put(spell.getKey(), i);
                    }
                } else {
                    List<Material> buildingMaterials = this.activePlayer.getMaster().getBuildingMaterials();
                    if (material != Material.AIR && (buildingMaterials.contains(material) || material == EraseMaterial)) {
                        String materialKey = String.valueOf(material.getId()) + ":" + items[i].getData().getData();
                        if (material == EraseMaterial) {
                            materialKey = "0:0";
                        } else if (material == CopyMaterial) {
                            materialKey = "-1:0";
                        }
                        if (materialMap.containsKey(materialKey)) {
                            materialMap.put(materialKey, i);
                        }
                    }
                }
            }
            ++i;
        }
        ArrayList<String> spellNames = new ArrayList<String>();
        ArrayList<String> materialNames = new ArrayList<String>();
        for (Map.Entry spellEntry : spellMap.entrySet()) {
            position = (Integer)spellEntry.getValue();
            String spellName = (String)spellEntry.getKey();
            if (position != null) {
                spellName = String.valueOf(spellName) + "@" + position;
            }
            spellNames.add(spellName);
        }
        for (Map.Entry materialEntry : materialMap.entrySet()) {
            position = (Integer)materialEntry.getValue();
            String materialName = (String)materialEntry.getKey();
            if (position != null) {
                materialName = String.valueOf(materialName) + "@" + position;
            }
            materialNames.add(materialName);
        }
        this.setSpells(spellNames);
        this.setMaterials(materialNames);
        this.saveState();
    }

    public static boolean isActive(Player player) {
        ItemStack activeItem = player.getInventory().getItemInHand();
        return Wand.isWand(activeItem);
    }

    protected void randomize(int level, boolean additive) {
        if (!wandTemplates.containsKey("random")) {
            return;
        }
        ConfigurationNode randomTemplate = wandTemplates.get("random");
        if (!additive && randomTemplate.containsKey("name")) {
            this.wandName = randomTemplate.getString("name");
        }
        WandLevel.randomizeWand(this, additive, level);
    }

    public static Wand createWand(Spells spells, String templateName) {
        Wand wand = new Wand(spells);
        ArrayList<String> defaultSpells = new ArrayList<String>();
        String wandName = defaultWandName;
        if (templateName != null && templateName.length() > 0) {
            List<Object> materialList;
            if ((templateName.equals("random") || templateName.startsWith("random(")) && wandTemplates.containsKey("random")) {
                int level = 1;
                if (!templateName.equals("random")) {
                    String randomLevel = templateName.substring(templateName.indexOf(40) + 1, templateName.length() - 1);
                    level = Integer.parseInt(randomLevel);
                }
                wand.randomize(level, false);
                return wand;
            }
            if (!wandTemplates.containsKey(templateName)) {
                return null;
            }
            ConfigurationNode wandConfig = wandTemplates.get(templateName);
            wandName = wandConfig.getString("name", wandName);
            List<Object> spellList = wandConfig.getList("spells");
            if (spellList != null) {
                for (Object spellName : spellList) {
                    defaultSpells.add((String)spellName);
                }
            }
            if ((materialList = wandConfig.getList("materials")) != null) {
                for (Object materialNameAndData : materialList) {
                    String[] materialParts = StringUtils.split((String)((String)materialNameAndData), (char)':');
                    String materialName = materialParts[0];
                    byte data = 0;
                    if (materialParts.length > 1) {
                        data = Byte.parseByte(materialParts[1]);
                    }
                    if (materialName.equals("erase")) {
                        wand.addMaterial(EraseMaterial, (byte)0, false);
                        continue;
                    }
                    if (materialName.equals("copy") || materialName.equals("clone")) {
                        wand.addMaterial(CopyMaterial, (byte)0, false);
                        continue;
                    }
                    wand.addMaterial(ConfigurationNode.toMaterial(materialName), data, false);
                }
            }
            wand.configureProperties(wandConfig);
        }
        wand.addSpells(defaultSpells);
        wand.setName(wandName);
        return wand;
    }

    public void configureProperties(ConfigurationNode wandConfig) {
        this.costReduction = (float)wandConfig.getDouble("cost_reduction", this.costReduction);
        this.damageReduction = (float)wandConfig.getDouble("damage_reduction", this.damageReduction);
        this.damageReductionPhysical = (float)wandConfig.getDouble("damage_reduction_physical", this.damageReductionPhysical);
        this.damageReductionProjectiles = (float)wandConfig.getDouble("damage_reduction_projectiles", this.damageReductionPhysical);
        this.damageReductionFalling = (float)wandConfig.getDouble("damage_reduction_falling", this.damageReductionFalling);
        this.damageReductionFire = (float)wandConfig.getDouble("damage_reduction_fire", this.damageReductionFire);
        this.damageReductionExplosions = (float)wandConfig.getDouble("damage_reduction_explosions", this.damageReductionExplosions);
        this.xpRegeneration = wandConfig.getInt("xp_regeneration", this.xpRegeneration);
        this.xpMax = wandConfig.getInt("xp_max", this.xpMax);
        this.healthRegeneration = wandConfig.getInt("health_regeneration", this.healthRegeneration);
        this.hungerRegeneration = wandConfig.getInt("hunger_regeneration", this.hungerRegeneration);
        this.uses = wandConfig.getInt("uses", this.uses);
        float oldWalkSpeedIncrease = this.walkSpeedIncrease;
        this.walkSpeedIncrease = (float)wandConfig.getDouble("haste", this.walkSpeedIncrease);
        if (this.activePlayer != null && this.walkSpeedIncrease != oldWalkSpeedIncrease) {
            Player player = this.activePlayer.getPlayer();
            player.setWalkSpeed(player.getWalkSpeed() + this.walkSpeedIncrease - oldWalkSpeedIncrease);
        }
        this.saveState();
        this.updateName();
        this.updateLore();
    }

    public static void reset(Plugin plugin) {
        File dataFolder = plugin.getDataFolder();
        File propertiesFile = new File(dataFolder, propertiesFileName);
        propertiesFile.delete();
    }

    public static void load(Plugin plugin) {
        File dataFolder = plugin.getDataFolder();
        File propertiesFile = new File(dataFolder, propertiesFileName);
        if (!propertiesFile.exists()) {
            File oldDefaults = new File(dataFolder, propertiesFileNameDefaults);
            oldDefaults.delete();
            plugin.saveResource(propertiesFileNameDefaults, false);
            Wand.loadProperties(plugin.getResource(propertiesFileNameDefaults));
        } else {
            Wand.loadProperties(propertiesFile);
        }
    }

    private static void loadProperties(File propertiesFile) {
        Wand.loadProperties(new Configuration(propertiesFile));
    }

    private static void loadProperties(InputStream properties) {
        Wand.loadProperties(new Configuration(properties));
    }

    private static void loadProperties(Configuration properties) {
        properties.load();
        wandTemplates.clear();
        ConfigurationNode wandList = properties.getNode("wands");
        if (wandList == null) {
            return;
        }
        List<String> wandKeys = wandList.getKeys();
        for (String key : wandKeys) {
            ConfigurationNode wandNode = wandList.getNode(key);
            wandNode.setProperty("key", key);
            wandTemplates.put(key, wandNode);
            if (!key.equals("random")) continue;
            WandLevel.mapLevels(wandNode);
        }
    }

    public static Collection<ConfigurationNode> getWandTemplates() {
        return wandTemplates.values();
    }

    private void updateActiveMaterial() {
        if (this.activePlayer == null) {
            return;
        }
        if (this.activeMaterial == null) {
            this.activePlayer.clearBuildingMaterial();
        } else {
            String[] pieces = StringUtils.split((String)this.activeMaterial, (String)":");
            if (pieces.length > 0) {
                byte data = 0;
                if (pieces.length > 1) {
                    data = Byte.parseByte(pieces[1]);
                }
                int materialId = Integer.parseInt(pieces[0]);
                Material material = null;
                material = materialId == 0 ? EraseMaterial : (materialId == -1 ? CopyMaterial : Material.getMaterial((int)materialId));
                this.activePlayer.setBuildingMaterial(material, data);
            }
        }
    }

    private void openInventory(int itemSlot) {
        if (this.activePlayer == null) {
            return;
        }
        if (this.activePlayer.storeInventory(itemSlot, this.item)) {
            this.updateInventory(itemSlot);
            this.activePlayer.getPlayer().updateInventory();
        }
    }

    public void openInventory() {
        if (this.activePlayer == null) {
            return;
        }
        this.openInventory(this.activePlayer.getPlayer().getInventory().getHeldItemSlot());
    }

    private void closeInventory(int itemSlot) {
        this.saveInventory();
        if (this.activePlayer != null) {
            this.activePlayer.restoreInventory(itemSlot, this.item);
            this.activePlayer.getPlayer().updateInventory();
        }
    }

    public void closeInventory() {
        if (this.activePlayer == null) {
            return;
        }
        this.closeInventory(this.activePlayer.getPlayer().getInventory().getHeldItemSlot());
    }

    public void activate(PlayerSpells playerSpells) {
        this.activePlayer = playerSpells;
        if (this.walkSpeedIncrease > 0.0f) {
            Player player = this.activePlayer.getPlayer();
            player.setWalkSpeed(player.getWalkSpeed() + this.walkSpeedIncrease);
        }
        this.activePlayer.setActiveWand(this);
        this.accumulatedXp = 0;
        this.updateActiveMaterial();
        this.updateName();
    }

    public boolean isInventoryOpen() {
        return this.activePlayer != null && this.activePlayer.hasStoredInventory();
    }

    public void deactivate() {
        if (this.activePlayer == null) {
            return;
        }
        this.deactivate(this.activePlayer.getPlayer().getInventory().getHeldItemSlot());
    }

    public void deactivate(int itemSlot) {
        if (this.activePlayer == null) {
            return;
        }
        if (this.isInventoryOpen()) {
            this.closeInventory(itemSlot);
        }
        if (this.accumulatedXp > 0) {
            CastingCost.removeExperience(this.activePlayer.getPlayer(), this.accumulatedXp);
        }
        if (this.walkSpeedIncrease > 0.0f) {
            Player player = this.activePlayer.getPlayer();
            player.setWalkSpeed(player.getWalkSpeed() - this.walkSpeedIncrease);
        }
        this.accumulatedXp = 0;
        this.activePlayer.setActiveWand(null);
        this.activePlayer = null;
    }

    public boolean cast() {
        if (this.activePlayer == null) {
            return false;
        }
        Spell spell = this.activePlayer.getSpell(this.activeSpell);
        if (spell != null && spell.cast()) {
            this.use();
            return true;
        }
        return false;
    }

    protected void use() {
        if (this.activePlayer == null) {
            return;
        }
        if (this.uses > 0) {
            short durability = this.item.getDurability();
            if (durability >= this.uses - 1) {
                Player player = this.activePlayer.getPlayer();
                this.deactivate();
                PlayerInventory playerInventory = player.getInventory();
                playerInventory.setItemInHand(new ItemStack(Material.AIR, 1));
                player.updateInventory();
            } else {
                this.item.setDurability((short)(durability + 1));
                this.updateName();
                this.updateLore(this.getSpells().length, this.getMaterials().length);
            }
        }
    }

    public void processRegeneration() {
        if (this.activePlayer == null) {
            return;
        }
        Player player = this.activePlayer.getPlayer();
        if (this.xpRegeneration > 0 && (this.xpMax == 0 || player.getTotalExperience() < this.xpMax)) {
            player.giveExp(this.xpRegeneration);
            this.accumulatedXp += this.xpRegeneration;
        }
        if (this.healthRegeneration > 0 && player.getHealth() < 20.0) {
            player.setHealth(Math.min(20.0, player.getHealth() + (double)this.healthRegeneration));
        }
        if (this.hungerRegeneration > 0 && player.getFoodLevel() < 20) {
            player.setExhaustion(0.0f);
            player.setFoodLevel(Math.min(20, player.getFoodLevel() + this.hungerRegeneration));
        }
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof Wand)) {
            return false;
        }
        Wand otherWand = (Wand)other;
        if (this.id == null || otherWand.id == null) {
            return false;
        }
        return otherWand.id.equals(this.id);
    }

    public Spells getMaster() {
        return this.spells;
    }
}

