/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic;

import com.elmakers.mine.bukkit.dao.BlockList;
import com.elmakers.mine.bukkit.plugins.magic.CleanupBlocksTask;
import com.elmakers.mine.bukkit.plugins.magic.MagicPlugin;
import com.elmakers.mine.bukkit.plugins.magic.PlayerSpells;
import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.plugins.magic.SpellEventType;
import com.elmakers.mine.bukkit.plugins.magic.Wand;
import com.elmakers.mine.bukkit.plugins.magic.WandChestPopulator;
import com.elmakers.mine.bukkit.plugins.magic.WandLevel;
import com.elmakers.mine.bukkit.utilities.CSVParser;
import com.elmakers.mine.bukkit.utilities.SetActiveItemSlotTask;
import com.elmakers.mine.bukkit.utilities.UndoQueue;
import com.elmakers.mine.bukkit.utilities.borrowed.Configuration;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Server;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.bukkit.event.enchantment.EnchantItemEvent;
import org.bukkit.event.enchantment.PrepareItemEnchantEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.inventory.PrepareItemCraftEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.event.server.PluginEnableEvent;
import org.bukkit.event.world.WorldInitEvent;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitScheduler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Spells
implements Listener {
    private final String spellsFileName = "spells.yml";
    private final String propertiesFileName = "magic.yml";
    private final String spellsFileNameDefaults = "spells.defaults.yml";
    private final String propertiesFileNameDefaults = "magic.defaults.yml";
    static final String DEFAULT_BUILDING_MATERIALS = "0,1,2,3,4,5,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,33,34,35,41,42,43,45,46,47,48,49,52,53,55,56,57,58,60,61,62,65,66,67,73,74,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,100,101,102,103,104,105,106,107,108,109";
    static final String DEFAULT_TARGET_THROUGH_MATERIALS = "0";
    static final String STICKY_MATERIALS = "37,38,39,50,51,55,59,63,64,65,66,68,70,71,72,75,76,77,78,83";
    static final String STICKY_MATERIALS_DOUBLE_HEIGHT = "64,71,";
    private List<Material> buildingMaterials = new ArrayList<Material>();
    private List<Material> stickyMaterials = new ArrayList<Material>();
    private List<Material> stickyMaterialsDoubleHeight = new ArrayList<Material>();
    private List<Material> targetThroughMaterials = new ArrayList<Material>();
    private long physicsDisableTimeout = 0L;
    private int undoQueueDepth = 256;
    private boolean silent = false;
    private boolean quiet = true;
    private boolean soundsEnabled = true;
    private boolean blockPopulatorEnabled = false;
    private boolean enchantingEnabled = false;
    private ConfigurationNode blockPopulatorConfig = null;
    private HashMap<String, UndoQueue> playerUndoQueues = new HashMap();
    private final Logger log = Logger.getLogger("Minecraft");
    private final HashMap<String, Spell> spells = new HashMap();
    private final HashMap<Material, Spell> spellsByMaterial = new HashMap();
    private final HashMap<String, PlayerSpells> playerSpells = new HashMap();
    private Recipe wandRecipe = null;
    private Material wandRecipeUpperMaterial = Material.DIAMOND;
    private Material wandRecipeLowerMaterial = Material.BLAZE_ROD;
    private String recipeOutputTemplate = "random(1)";
    private MagicPlugin plugin = null;
    private Object regionManager = null;

    public PlayerSpells getPlayerSpells(Player player) {
        PlayerSpells spells = this.playerSpells.get(player.getName());
        if (spells == null) {
            spells = new PlayerSpells(this, player);
            this.playerSpells.put(player.getName(), spells);
        }
        spells.setPlayer(player);
        return spells;
    }

    public void createSpell(Spell template, String name, Material icon, String description, String category, String parameterString) {
        this.createSpell(template, name, icon, description, category, parameterString, null, null);
    }

    public void createSpell(Spell template, String name, Material icon, String description, String category, String parameterString, String propertiesString) {
        this.createSpell(template, name, icon, description, category, parameterString, propertiesString, null);
    }

    public void createSpell(Spell template, String name, Material icon, String description, String category, String parameterString, String propertiesString, String costsString) {
        ConfigurationNode spellNode = new ConfigurationNode();
        ConfigurationNode parameterNode = spellNode.createChild("parameters");
        ConfigurationNode propertiesNode = spellNode.createChild("properties");
        if (parameterString != null && parameterString.length() > 0) {
            String[] parameters = parameterString.split(" ");
            Spell.addParameters(parameters, parameterNode);
        }
        if (propertiesString != null && propertiesString.length() > 0) {
            String[] properties = propertiesString.split(" ");
            Spell.addParameters(properties, propertiesNode);
        }
        if (costsString != null && costsString.length() > 0) {
            ArrayList costs = new ArrayList();
            String[] costPairs = costsString.split(" ");
            int i = 0;
            while (i < costPairs.length - 1) {
                try {
                    int amount = Integer.parseInt(costPairs[i + 1]);
                    HashMap<String, Object> cost = new HashMap<String, Object>();
                    cost.put("material", costPairs[i]);
                    cost.put("amount", amount);
                    costs.add(cost);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                i += 2;
            }
            spellNode.setProperty("costs", costs);
        }
        spellNode.setProperty("description", description);
        spellNode.setProperty("icon", icon);
        spellNode.setProperty("category", category);
        template.initialize(this);
        template.load(name, spellNode);
        this.addSpell(template);
    }

    public void addSpell(Spell variant) {
        Spell conflict = this.spells.get(variant.getKey());
        if (conflict != null) {
            this.log.log(Level.WARNING, "Duplicate spell name: '" + conflict.getKey() + "'");
        } else {
            this.spells.put(variant.getKey(), variant);
        }
        Material m = variant.getMaterial();
        if (m != null && m != Material.AIR) {
            conflict = this.spellsByMaterial.get(m);
            if (conflict != null) {
                this.log.log(Level.WARNING, "Duplicate spell material: " + m.name() + " for " + conflict.getKey() + " and " + variant.getKey());
            } else {
                this.spellsByMaterial.put(variant.getMaterial(), variant);
            }
        }
    }

    public List<Material> getBuildingMaterials() {
        return this.buildingMaterials;
    }

    public List<Material> getTargetThroughMaterials() {
        return this.targetThroughMaterials;
    }

    public UndoQueue getUndoQueue(String playerName) {
        UndoQueue queue = this.playerUndoQueues.get(playerName);
        if (queue == null) {
            queue = new UndoQueue();
            queue.setMaxSize(this.undoQueueDepth);
            this.playerUndoQueues.put(playerName, queue);
        }
        return queue;
    }

    public void addToUndoQueue(Player player, BlockList blocks) {
        UndoQueue queue = this.getUndoQueue(player.getName());
        queue.add(blocks);
    }

    public boolean undoAny(Player player, Block target) {
        for (String playerName : this.playerUndoQueues.keySet()) {
            UndoQueue queue = this.playerUndoQueues.get(playerName);
            if (!queue.undo(target)) continue;
            if (!player.getName().equals(playerName)) {
                player.sendMessage("Undid one of " + playerName + "'s spells");
            }
            return true;
        }
        return false;
    }

    public boolean undo(String playerName) {
        UndoQueue queue = this.getUndoQueue(playerName);
        return queue.undo();
    }

    public boolean undo(String playerName, Block target) {
        UndoQueue queue = this.getUndoQueue(playerName);
        return queue.undo(target);
    }

    public BlockList getLastBlockList(String playerName, Block target) {
        UndoQueue queue = this.getUndoQueue(playerName);
        return queue.getLast(target);
    }

    public BlockList getLastBlockList(String playerName) {
        UndoQueue queue = this.getUndoQueue(playerName);
        return queue.getLast();
    }

    public void scheduleCleanup(BlockList blocks) {
        Server server = this.plugin.getServer();
        BukkitScheduler scheduler = server.getScheduler();
        long ticksToLive = blocks.getTimeToLive() * 20 / 1000;
        scheduler.scheduleSyncDelayedTask((Plugin)this.plugin, (Runnable)new CleanupBlocksTask(blocks), ticksToLive);
    }

    public void registerEvent(SpellEventType type, Spell spell) {
        PlayerSpells spells = this.getPlayerSpells(spell.getPlayer());
        spells.registerEvent(type, spell);
    }

    public void unregisterEvent(SpellEventType type, Spell spell) {
        PlayerSpells spells = this.getPlayerSpells(spell.getPlayer());
        spells.unregisterEvent(type, spell);
    }

    public boolean cancel(Player player) {
        PlayerSpells playerSpells = this.getPlayerSpells(player);
        return playerSpells.cancel();
    }

    public boolean isQuiet() {
        return this.quiet;
    }

    public boolean isSilent() {
        return this.silent;
    }

    public boolean soundsEnabled() {
        return this.soundsEnabled;
    }

    public boolean isSolid(Material mat) {
        return mat != Material.AIR && mat != Material.WATER && mat != Material.STATIONARY_WATER && mat != Material.LAVA && mat != Material.STATIONARY_LAVA;
    }

    public boolean isSticky(Material mat) {
        return this.stickyMaterials.contains(mat);
    }

    public boolean isStickyAndTall(Material mat) {
        return this.stickyMaterialsDoubleHeight.contains(mat);
    }

    public boolean isAffectedByGravity(Material mat) {
        return mat == Material.GRAVEL || mat == Material.SAND || mat == Material.WOOD_DOOR || mat == Material.IRON_DOOR;
    }

    public Logger getLog() {
        return this.log;
    }

    public MagicPlugin getPlugin() {
        return this.plugin;
    }

    public boolean hasBuildPermission(Player player, Location location) {
        return this.hasBuildPermission(player, location.getBlock());
    }

    public boolean hasBuildPermission(Player player, Block block) {
        if (this.regionManager == null) {
            return true;
        }
        try {
            Method canBuildMethod = this.regionManager.getClass().getMethod("canBuild", Player.class, Block.class);
            if (canBuildMethod != null) {
                return (Boolean)canBuildMethod.invoke(this.regionManager, player, block);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return true;
    }

    public void initialize(MagicPlugin plugin) {
        try {
            this.regionManager = plugin.getServer().getPluginManager().getPlugin("WorldGuard");
            Method canBuildMethod = this.regionManager.getClass().getMethod("canBuild", Player.class, Block.class);
            if (canBuildMethod != null) {
                this.log.info("WorldGuard found, will respect build permissions for construction spells");
            } else {
                this.regionManager = null;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.regionManager == null) {
            this.log.info("WorldGuard not found, not using a region manager.");
        }
        this.plugin = plugin;
        this.load();
        Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)plugin, new Runnable(){

            public void run() {
                for (PlayerSpells spells : Spells.this.playerSpells.values()) {
                    Player player = spells.getPlayer();
                    Wand wand = spells.getActiveWand();
                    if (!player.isOnline() || wand == null) continue;
                    wand.processRegeneration();
                }
            }
        }, 0L, 20L);
    }

    public void load() {
        File dataFolder = this.plugin.getDataFolder();
        dataFolder.mkdirs();
        File propertiesFile = new File(dataFolder, "magic.yml");
        if (!propertiesFile.exists()) {
            File oldDefaults = new File(dataFolder, "magic.defaults.yml");
            oldDefaults.delete();
            this.plugin.saveResource("magic.defaults.yml", false);
            this.loadProperties(this.plugin.getResource("magic.defaults.yml"));
        } else {
            this.loadProperties(propertiesFile);
        }
        File spellsFile = new File(dataFolder, "spells.yml");
        if (!spellsFile.exists()) {
            File oldDefaults = new File(dataFolder, "spells.defaults.yml");
            oldDefaults.delete();
            this.plugin.saveResource("spells.defaults.yml", false);
            this.load(this.plugin.getResource("spells.defaults.yml"));
        } else {
            this.load(spellsFile);
        }
        Wand.load((Plugin)this.plugin);
        this.log.info("Magic: Loaded " + this.spells.size() + " spells and " + Wand.getWandTemplates().size() + " wands");
    }

    protected void save(File spellsFile) {
        Configuration config = new Configuration(spellsFile);
        ConfigurationNode spellsNode = config.createChild("spells");
        for (Spell spell : this.spells.values()) {
            ConfigurationNode spellNode = spellsNode.createChild(spell.getKey());
            spell.save(spellNode);
        }
        config.save();
    }

    protected void load(File spellsFile) {
        this.load(new Configuration(spellsFile));
    }

    protected void load(InputStream spellsConfig) {
        this.load(new Configuration(spellsConfig));
    }

    protected void load(Configuration config) {
        config.load();
        ConfigurationNode spellsNode = config.getNode("spells");
        if (spellsNode == null) {
            return;
        }
        List<String> spellKeys = spellsNode.getKeys();
        for (String key : spellKeys) {
            ConfigurationNode spellNode;
            Spell newSpell = Spell.loadSpell(key, spellNode = spellsNode.getNode(key), this);
            if (newSpell == null) {
                this.log.warning("Magic: Error loading spell " + key);
                continue;
            }
            this.addSpell(newSpell);
        }
    }

    protected void loadProperties(File propertiesFile) {
        this.loadProperties(new Configuration(propertiesFile));
    }

    protected void loadProperties(InputStream properties) {
        this.loadProperties(new Configuration(properties));
    }

    protected void loadProperties(Configuration properties) {
        properties.load();
        ConfigurationNode generalNode = properties.getNode("general");
        this.undoQueueDepth = generalNode.getInteger("undo_depth", this.undoQueueDepth);
        this.silent = generalNode.getBoolean("silent", this.silent);
        this.quiet = generalNode.getBoolean("quiet", this.quiet);
        this.soundsEnabled = generalNode.getBoolean("sounds", this.soundsEnabled);
        this.blockPopulatorEnabled = generalNode.getBoolean("enable_block_populator", this.blockPopulatorEnabled);
        this.enchantingEnabled = generalNode.getBoolean("enable_enchanting", this.enchantingEnabled);
        this.blockPopulatorConfig = generalNode.getNode("populate_chests");
        this.buildingMaterials = generalNode.getMaterials("building", DEFAULT_BUILDING_MATERIALS);
        this.targetThroughMaterials = generalNode.getMaterials("target_through", DEFAULT_TARGET_THROUGH_MATERIALS);
        CSVParser csv = new CSVParser();
        this.stickyMaterials = csv.parseMaterials(STICKY_MATERIALS);
        this.stickyMaterialsDoubleHeight = csv.parseMaterials(STICKY_MATERIALS_DOUBLE_HEIGHT);
        Wand.WandMaterial = generalNode.getMaterial("wand_item", Wand.WandMaterial);
        Wand.CopyMaterial = generalNode.getMaterial("copy_item", Wand.CopyMaterial);
        Wand.EraseMaterial = generalNode.getMaterial("erase_item", Wand.EraseMaterial);
        Wand.EnchantableWandMaterial = generalNode.getMaterial("wand_item_enchantable", Wand.EnchantableWandMaterial);
        boolean craftingEnabled = generalNode.getBoolean("enable_crafting", false);
        if (craftingEnabled) {
            this.recipeOutputTemplate = generalNode.getString("crafting_output", this.recipeOutputTemplate);
            this.wandRecipeUpperMaterial = generalNode.getMaterial("crafting_material_upper", Material.DIAMOND);
            this.wandRecipeLowerMaterial = generalNode.getMaterial("crafting_material_lower", Material.BLAZE_ROD);
            Wand wand = new Wand(this);
            ShapedRecipe recipe = new ShapedRecipe(wand.getItem());
            recipe.shape(new String[]{"o", "i"}).setIngredient('o', this.wandRecipeUpperMaterial).setIngredient('i', this.wandRecipeLowerMaterial);
            this.wandRecipe = recipe;
        }
        properties.save();
    }

    public void clear() {
        this.playerSpells.clear();
        this.spells.clear();
        this.spellsByMaterial.clear();
    }

    public void reset() {
        this.log.info("Magic: Resetting all spells to default");
        this.clear();
        File dataFolder = this.plugin.getDataFolder();
        dataFolder.mkdirs();
        File spellsFile = new File(dataFolder, "spells.yml");
        spellsFile.delete();
        File magicFile = new File(dataFolder, "magic.yml");
        magicFile.delete();
        Wand.reset((Plugin)this.plugin);
        this.load();
    }

    public List<Spell> getAllSpells() {
        ArrayList<Spell> allSpells = new ArrayList<Spell>();
        allSpells.addAll(this.spells.values());
        return allSpells;
    }

    public boolean allowPhysics(Block block) {
        if (this.physicsDisableTimeout == 0L) {
            return true;
        }
        if (System.currentTimeMillis() > this.physicsDisableTimeout) {
            this.physicsDisableTimeout = 0L;
        }
        return false;
    }

    public void disablePhysics(int interval) {
        this.physicsDisableTimeout = System.currentTimeMillis() + (long)interval;
    }

    public boolean hasWandPermission(Player player) {
        return this.hasPermission(player, "Magic.wand.use", true);
    }

    public boolean hasPermission(Player player, String pNode, boolean defaultValue) {
        boolean isSet = player.isPermissionSet(pNode);
        return isSet ? player.hasPermission(pNode) : defaultValue;
    }

    public boolean hasPermission(Player player, String pNode) {
        return this.hasPermission(player, pNode, false);
    }

    @EventHandler
    public void onContainerClick(InventoryDragEvent event) {
        ItemStack oldStack = event.getOldCursor();
        if (oldStack != null && oldStack.hasItemMeta()) {
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler
    public void onPlayerEquip(PlayerItemHeldEvent event) {
        Player player = event.getPlayer();
        PlayerInventory inventory = player.getInventory();
        ItemStack next = inventory.getItem(event.getNewSlot());
        ItemStack previous = inventory.getItem(event.getPreviousSlot());
        PlayerSpells playerSpells = this.getPlayerSpells(player);
        Wand activeWand = playerSpells.getActiveWand();
        if (activeWand != null && Wand.isWand(previous)) {
            if (activeWand.isInventoryOpen()) {
                activeWand.setItem(previous);
                if (next != null && next.getType() != Material.AIR) {
                    Spell spell;
                    Spell spell2 = spell = Wand.isSpell(next) ? playerSpells.getSpell(next.getType()) : null;
                    if (spell != null) {
                        playerSpells.cancel();
                        activeWand.setActiveSpell(spell.getKey());
                    } else {
                        Material material = next.getType();
                        if (this.buildingMaterials.contains(material) || material == Wand.EraseMaterial || material == Wand.CopyMaterial) {
                            activeWand.setActiveMaterial(material, next.getData().getData());
                        }
                    }
                }
                Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, (Runnable)((Object)new SetActiveItemSlotTask(player, event.getPreviousSlot())), 1L);
                return;
            }
            activeWand.deactivate();
        }
        if (next != null && Wand.isWand(next)) {
            Wand newWand = new Wand(this, next);
            newWand.activate(playerSpells);
        }
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent event) {
        PlayerSpells spells = this.getPlayerSpells(event.getPlayer());
        spells.onPlayerMove(event);
    }

    @EventHandler
    public void onEntityDeath(EntityDeathEvent event) {
        if (event.getEntityType() == EntityType.PLAYER && event.getEntity() instanceof Player) {
            this.onPlayerDeath((Player)event.getEntity(), event);
        }
    }

    public void onPlayerDeath(Player player, EntityDeathEvent event) {
        PlayerSpells playerSpells = this.getPlayerSpells(player);
        String rule = player.getWorld().getGameRuleValue("keepInventory");
        Wand wand = playerSpells.getActiveWand();
        if (wand != null && !rule.equals("true")) {
            List drops = event.getDrops();
            drops.clear();
            drops.add(wand.getItem());
            if (playerSpells.hasStoredInventory()) {
                ItemStack[] stored = playerSpells.getStoredInventory().getContents();
                wand.deactivate();
                player.getInventory().clear();
                ItemStack[] itemStackArray = stored;
                int n = stored.length;
                int n2 = 0;
                while (n2 < n) {
                    ItemStack stack = itemStackArray[n2];
                    if (stack != null) {
                        drops.add(stack);
                    }
                    ++n2;
                }
            } else {
                wand.deactivate();
            }
        }
        playerSpells.onPlayerDeath(event);
    }

    public void onPlayerDamage(Player player, EntityDamageEvent event) {
        PlayerSpells spells = this.getPlayerSpells(player);
        spells.onPlayerDamage(event);
    }

    @EventHandler
    public void onEntityDamage(EntityDamageEvent event) {
        if (Player.class.isInstance(event.getEntity())) {
            Player player = (Player)event.getEntity();
            this.onPlayerDamage(player, event);
        }
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        boolean toggleInventory;
        Player player = event.getPlayer();
        PlayerSpells playerSpells = this.getPlayerSpells(player);
        Wand wand = playerSpells.getActiveWand();
        if (wand == null || !this.hasWandPermission(player)) {
            return;
        }
        if (event.getAction() == Action.LEFT_CLICK_AIR || event.getAction() == Action.LEFT_CLICK_BLOCK) {
            wand.cast();
        }
        boolean bl = toggleInventory = event.getAction() == Action.RIGHT_CLICK_AIR;
        if (!toggleInventory && event.getAction() == Action.RIGHT_CLICK_BLOCK) {
            Material material = event.getMaterial();
            boolean bl2 = toggleInventory = material != Material.CHEST && material != Material.WOODEN_DOOR && material != Material.IRON_DOOR_BLOCK && material != Material.ENDER_CHEST && material != Material.ANVIL && material != Material.BREWING_STAND && material != Material.ENCHANTMENT_TABLE && material != Material.STONE_BUTTON && material != Material.LEVER && material != Material.FURNACE;
        }
        if (toggleInventory) {
            if (!playerSpells.cancel()) {
                if (wand.getHasInventory()) {
                    if (wand.isInventoryOpen()) {
                        playerSpells.playSound(Sound.CHEST_CLOSE, 0.4f, 0.2f);
                        wand.closeInventory();
                    } else {
                        playerSpells.playSound(Sound.CHEST_OPEN, 0.4f, 0.2f);
                        wand.openInventory();
                    }
                }
            } else {
                playerSpells.playSound(Sound.NOTE_BASS, 1.0f, 0.7f);
            }
        }
    }

    @EventHandler
    public void onBlockPhysics(BlockPhysicsEvent event) {
        if (!this.allowPhysics(event.getBlock())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        PlayerSpells playerSpells = this.getPlayerSpells(player);
        Wand wand = Wand.getActiveWand(this, player);
        if (wand != null) {
            wand.activate(playerSpells);
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        PlayerSpells playerSpells = this.getPlayerSpells(player);
        Wand wand = playerSpells.getActiveWand();
        if (wand != null) {
            wand.deactivate();
        }
        playerSpells.restoreInventory();
        playerSpells.onPlayerQuit(event);
    }

    @EventHandler
    public void onPluginDisable(PluginDisableEvent event) {
        for (PlayerSpells spells : this.playerSpells.values()) {
            Player player = spells.getPlayer();
            Wand wand = spells.getActiveWand();
            if (wand != null) {
                wand.deactivate();
            }
            spells.restoreInventory();
            player.updateInventory();
        }
    }

    @EventHandler
    public void onPluginEnable(PluginEnableEvent event) {
        Player[] players;
        Player[] playerArray = players = this.plugin.getServer().getOnlinePlayers();
        int n = players.length;
        int n2 = 0;
        while (n2 < n) {
            Player player = playerArray[n2];
            Wand wand = Wand.getActiveWand(this, player);
            if (wand != null) {
                PlayerSpells spells = this.getPlayerSpells(player);
                wand.activate(spells);
                player.updateInventory();
            }
            ++n2;
        }
        if (this.wandRecipe != null) {
            this.plugin.getServer().addRecipe(this.wandRecipe);
        }
    }

    @EventHandler
    public void onPrepareCraftItem(PrepareItemCraftEvent event) {
        Recipe recipe = event.getRecipe();
        if (this.wandRecipe != null && recipe.getResult().getType() == Wand.WandMaterial) {
            CraftingInventory inventory = event.getInventory();
            if (!inventory.contains(this.wandRecipeLowerMaterial) || !inventory.contains(this.wandRecipeUpperMaterial)) {
                return;
            }
            Wand wand = Wand.createWand(this, this.recipeOutputTemplate);
            if (wand == null) {
                wand = new Wand(this);
            }
            event.getInventory().setResult(wand.getItem());
        }
    }

    @EventHandler
    public void onCraftItem(CraftItemEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        PlayerSpells spells = this.getPlayerSpells(player);
        if (spells.hasStoredInventory()) {
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler
    public void onInventoryOpen(InventoryOpenEvent event) {
        if (!(event.getPlayer() instanceof Player) || event.getView().getType() == InventoryType.CRAFTING) {
            return;
        }
        Player player = (Player)event.getPlayer();
        PlayerSpells playerSpells = this.getPlayerSpells(player);
        Wand wand = playerSpells.getActiveWand();
        if (wand != null) {
            wand.deactivate();
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        Wand wand;
        ItemStack current;
        ItemStack cursor;
        InventoryType.SlotType slotType;
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        if (event.getInventory().getType() == InventoryType.ENCHANTING && (slotType = event.getSlotType()) == InventoryType.SlotType.CRAFTING) {
            cursor = event.getCursor();
            current = event.getCurrentItem();
            if (Wand.isWand(cursor)) {
                wand = new Wand(this, cursor);
                wand.makeEnchantable(true);
            }
            if (Wand.isWand(current)) {
                wand = new Wand(this, current);
                wand.makeEnchantable(false);
            }
        }
        if (event.getInventory().getType() == InventoryType.ANVIL) {
            slotType = event.getSlotType();
            cursor = event.getCursor();
            current = event.getCurrentItem();
            if (slotType == InventoryType.SlotType.CRAFTING) {
                if (Wand.isWand(cursor)) {
                    wand = new Wand(this, cursor);
                    wand.updateName(false);
                }
                if (Wand.isWand(current)) {
                    wand = new Wand(this, current);
                    wand.updateName(true);
                }
            }
            if (slotType == InventoryType.SlotType.RESULT && Wand.isWand(current)) {
                ItemMeta meta = current.getItemMeta();
                String newName = meta.getDisplayName();
                Wand wand2 = new Wand(this, current);
                wand2.setName(newName);
            }
        }
    }

    @EventHandler
    public void onInventoryClosed(InventoryCloseEvent event) {
        if (!(event.getPlayer() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getPlayer();
        PlayerSpells playerSpells = this.getPlayerSpells(player);
        Wand previousWand = playerSpells.getActiveWand();
        if (previousWand != null && previousWand.isInventoryOpen()) {
            previousWand.saveInventory();
        }
        Wand wand = Wand.getActiveWand(this, player);
        boolean changedWands = false;
        if (previousWand != null && wand == null) {
            changedWands = true;
        }
        if (previousWand == null && wand != null) {
            changedWands = true;
        }
        if (previousWand != null && wand != null && !previousWand.equals(wand)) {
            changedWands = true;
        }
        if (changedWands) {
            boolean inventoryWasOpen = false;
            if (previousWand != null) {
                inventoryWasOpen = previousWand.isInventoryOpen();
                previousWand.deactivate();
            }
            if (wand != null) {
                wand.activate(playerSpells);
                if (inventoryWasOpen) {
                    wand.openInventory();
                }
            }
        }
    }

    @EventHandler
    public void onPlayerPickupItem(PlayerPickupItemEvent event) {
        PlayerSpells spells = this.getPlayerSpells(event.getPlayer());
        if (spells.hasStoredInventory()) {
            event.setCancelled(true);
            if (spells.addToStoredInventory(event.getItem().getItemStack())) {
                event.getItem().remove();
            }
        } else {
            PlayerInventory inventory = event.getPlayer().getInventory();
            ItemStack inHand = inventory.getItemInHand();
            ItemStack pickup = event.getItem().getItemStack();
            if (Wand.isWand(pickup) && (inHand == null || inHand.getType() == Material.AIR)) {
                Wand wand = new Wand(this, pickup);
                event.setCancelled(true);
                event.getItem().remove();
                inventory.setItem(inventory.getHeldItemSlot(), pickup);
                wand.activate(spells);
            }
        }
    }

    @EventHandler
    public void onPlayerDropItem(PlayerDropItemEvent event) {
        Player player = event.getPlayer();
        PlayerSpells spells = this.getPlayerSpells(player);
        Wand activeWand = spells.getActiveWand();
        if (activeWand != null) {
            ItemStack inHand = event.getPlayer().getInventory().getItemInHand();
            if (Wand.isWand(event.getItemDrop().getItemStack()) && (inHand == null || inHand.getType() == Material.AIR)) {
                activeWand.deactivate();
                player.setItemInHand(new ItemStack(Material.AIR, 1));
            } else {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onEnchantItem(EnchantItemEvent event) {
        if (this.enchantingEnabled && Wand.isWand(event.getItem())) {
            event.getEnchantsToAdd().clear();
            int level = event.getExpLevelCost();
            Wand wand = new Wand(this, event.getItem());
            WandLevel.randomizeWand(wand, true, level);
        }
    }

    @EventHandler
    public void onPrepareEnchantItem(PrepareItemEnchantEvent event) {
        if (Wand.isWand(event.getItem())) {
            Set<Integer> levelSet = WandLevel.getLevels();
            ArrayList<Integer> levels = new ArrayList<Integer>();
            levels.addAll(levelSet);
            int[] offered = event.getExpLevelCostsOffered();
            int bonusLevels = event.getEnchantmentBonus();
            int i = 0;
            while (i < offered.length) {
                int levelIndex = (int)((float)i * (float)levels.size() / (float)offered.length);
                levelIndex = (int)((float)levelIndex + (float)bonusLevels * (float)((i + 1) / offered.length));
                levelIndex = Math.min(levelIndex, levels.size() - 1);
                offered[i] = (Integer)levels.get(levelIndex);
                ++i;
            }
            event.setCancelled(false);
        }
    }

    @EventHandler
    public void onWorldInit(WorldInitEvent event) {
        if (this.blockPopulatorEnabled && this.blockPopulatorConfig != null) {
            World world = event.getWorld();
            world.getPopulators().add(new WandChestPopulator(this, this.blockPopulatorConfig));
        }
    }

    public Spell getSpell(Material material) {
        return this.spellsByMaterial.get(material);
    }

    public Spell getSpell(String name) {
        return this.spells.get(name);
    }
}

