/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic;

import com.elmakers.mine.bukkit.plugins.magic.CostReducer;
import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.plugins.magic.SpellEventType;
import com.elmakers.mine.bukkit.plugins.magic.SpellResult;
import com.elmakers.mine.bukkit.plugins.magic.Spells;
import com.elmakers.mine.bukkit.plugins.magic.Wand;
import com.elmakers.mine.bukkit.utilities.InventoryUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public class PlayerSpells
implements CostReducer {
    protected Player player;
    protected Spells master;
    protected HashMap<String, Spell> spells = new HashMap();
    private Inventory storedInventory = null;
    private Wand activeWand = null;
    private final List<Spell> movementListeners = new ArrayList<Spell>();
    private final List<Spell> quitListeners = new ArrayList<Spell>();
    private final List<Spell> deathListeners = new ArrayList<Spell>();
    private final List<Spell> damageListeners = new ArrayList<Spell>();
    private float costReduction = 0.0f;
    private float cooldownReduction = 0.0f;
    private ItemStack buildingMaterial = null;

    public void setCostReduction(float reduction) {
        this.costReduction = reduction;
    }

    public boolean hasStoredInventory() {
        return this.storedInventory != null;
    }

    public Inventory getStoredInventory() {
        return this.storedInventory;
    }

    public float getCostReduction() {
        return this.activeWand == null ? this.costReduction : this.activeWand.getCostReduction() + this.costReduction;
    }

    public float getCooldownReduction() {
        return this.activeWand == null ? this.cooldownReduction : this.activeWand.getCooldownReduction() + this.cooldownReduction;
    }

    public void setCooldownReduction(float reduction) {
        this.cooldownReduction = reduction;
    }

    public boolean addToStoredInventory(ItemStack item) {
        if (this.storedInventory == null) {
            return false;
        }
        HashMap remainder = this.storedInventory.addItem(new ItemStack[]{item});
        for (ItemStack remains : remainder.values()) {
            this.player.getWorld().dropItemNaturally(this.player.getLocation(), remains);
        }
        return true;
    }

    public boolean storeInventory(int keepSlot, ItemStack keepItem) {
        PlayerInventory inventory = this.player.getInventory();
        if (this.storedInventory != null) {
            return false;
        }
        if (keepItem != null) {
            inventory.clear(keepSlot);
        }
        this.storedInventory = InventoryUtils.createInventory(null, inventory.getSize(), "Magic.Wand.StoredInventory");
        ItemStack[] contents = inventory.getContents();
        int i = 0;
        while (i < contents.length) {
            if (Wand.isSpell(contents[i])) {
                contents[i] = null;
            }
            ++i;
        }
        this.storedInventory.setContents(contents);
        inventory.clear();
        if (keepItem != null) {
            inventory.setItem(keepSlot, keepItem);
        }
        return true;
    }

    public boolean storeInventory() {
        return this.storeInventory(this.player.getInventory().getHeldItemSlot(), this.player.getInventory().getItemInHand());
    }

    public boolean restoreInventory() {
        return this.restoreInventory(this.player.getInventory().getHeldItemSlot(), this.player.getInventory().getItemInHand());
    }

    public boolean restoreInventory(int keepSlot, ItemStack keepItem) {
        if (this.storedInventory == null) {
            return false;
        }
        PlayerInventory inventory = this.player.getInventory();
        inventory.setContents(this.storedInventory.getContents());
        this.storedInventory = null;
        if (keepItem != null) {
            ItemStack occupied = inventory.getItem(keepSlot);
            inventory.setItem(keepSlot, keepItem);
            if (occupied != null) {
                HashMap remainder = inventory.addItem(new ItemStack[]{occupied});
                for (ItemStack remains : remainder.values()) {
                    this.player.getWorld().dropItemNaturally(this.player.getLocation(), remains);
                }
            }
        }
        return true;
    }

    public void registerEvent(SpellEventType type, Spell spell) {
        switch (type) {
            case PLAYER_MOVE: {
                if (this.movementListeners.contains(spell)) break;
                this.movementListeners.add(spell);
                break;
            }
            case PLAYER_QUIT: {
                if (this.quitListeners.contains(spell)) break;
                this.quitListeners.add(spell);
                break;
            }
            case PLAYER_DAMAGE: {
                if (this.damageListeners.contains(spell)) break;
                this.damageListeners.add(spell);
                break;
            }
            case PLAYER_DEATH: {
                if (this.deathListeners.contains(spell)) break;
                this.deathListeners.add(spell);
            }
        }
    }

    public void setPlayer(Player player) {
        this.player = player;
    }

    public void unregisterEvent(SpellEventType type, Spell spell) {
        switch (type) {
            case PLAYER_MOVE: {
                this.movementListeners.remove(spell);
                break;
            }
            case PLAYER_DAMAGE: {
                this.damageListeners.remove(spell);
                break;
            }
            case PLAYER_QUIT: {
                this.quitListeners.remove(spell);
                break;
            }
            case PLAYER_DEATH: {
                this.deathListeners.remove(spell);
            }
        }
    }

    public PlayerSpells(Spells master, Player player) {
        this.master = master;
        this.player = player;
    }

    public Player getPlayer() {
        return this.player;
    }

    public boolean cancel() {
        boolean result = false;
        for (Spell spell : this.spells.values()) {
            boolean bl = result = result || spell.cancel();
        }
        return result;
    }

    public void onPlayerQuit(PlayerQuitEvent event) {
        ArrayList<Spell> active = new ArrayList<Spell>();
        active.addAll(this.quitListeners);
        for (Spell listener : active) {
            listener.onPlayerQuit(event);
        }
    }

    public void onPlayerMove(PlayerMoveEvent event) {
        ArrayList<Spell> active = new ArrayList<Spell>();
        active.addAll(this.movementListeners);
        for (Spell listener : active) {
            listener.onPlayerMove(event);
        }
    }

    public void onPlayerDeath(EntityDeathEvent event) {
        ArrayList<Spell> active = new ArrayList<Spell>();
        active.addAll(this.deathListeners);
        for (Spell listener : active) {
            if (this.player != listener.getPlayer()) continue;
            listener.onPlayerDeath(event);
        }
    }

    public void onPlayerDamage(EntityDamageEvent event) {
        ArrayList<Spell> active = new ArrayList<Spell>();
        active.addAll(this.damageListeners);
        for (Spell listener : active) {
            listener.onPlayerDamage(event);
        }
        if (event.isCancelled()) {
            return;
        }
        float reduction = 0.0f;
        if (this.activeWand != null) {
            reduction = this.activeWand.getDamageReduction();
            switch (event.getCause()) {
                case CONTACT: 
                case ENTITY_ATTACK: {
                    reduction += this.activeWand.getDamageReductionPhysical();
                    break;
                }
                case PROJECTILE: {
                    reduction += this.activeWand.getDamageReductionProjectiles();
                    break;
                }
                case FALL: {
                    reduction += this.activeWand.getDamageReductionFalling();
                    break;
                }
                case FIRE: 
                case FIRE_TICK: 
                case LAVA: {
                    reduction += this.activeWand.getDamageReductionFire();
                    break;
                }
                case BLOCK_EXPLOSION: 
                case ENTITY_EXPLOSION: {
                    reduction += this.activeWand.getDamageReductionExplosions();
                }
            }
        }
        if (reduction >= 1.0f) {
            event.setCancelled(true);
            return;
        }
        if (reduction > 0.0f) {
            int newDamage = (int)Math.floor((double)(1.0f - reduction) * event.getDamage());
            if (newDamage == 0) {
                newDamage = 1;
            }
            event.setDamage((double)newDamage);
        }
    }

    public Spell getSpell(Material material) {
        Spell spell = this.master.getSpell(material);
        if (spell == null || !spell.hasSpellPermission(this.player)) {
            return null;
        }
        return this.getSpell(spell.getKey());
    }

    public Spell getSpell(String name) {
        Spell spell = this.master.getSpell(name);
        if (spell == null || !spell.hasSpellPermission(this.player)) {
            return null;
        }
        Spell playerSpell = this.spells.get(spell.getKey());
        if (playerSpell == null) {
            playerSpell = (Spell)spell.clone();
            this.spells.put(spell.getKey(), playerSpell);
        }
        playerSpell.setPlayer(this.player);
        return playerSpell;
    }

    public Spells getMaster() {
        return this.master;
    }

    public Inventory getInventory() {
        return this.hasStoredInventory() ? this.getStoredInventory() : this.player.getInventory();
    }

    public Wand getActiveWand() {
        ItemStack currentItem;
        if (this.activeWand != null && Wand.isWand(currentItem = this.player.getItemInHand())) {
            this.activeWand.setItem(currentItem);
        }
        return this.activeWand;
    }

    public void setActiveWand(Wand activeWand) {
        this.activeWand = activeWand;
    }

    public void setBuildingMaterial(Material material, byte data) {
        if (material == Wand.CopyMaterial) {
            this.buildingMaterial = null;
            return;
        }
        if (material == Wand.EraseMaterial) {
            material = Material.AIR;
        }
        this.buildingMaterial = new ItemStack(material, 1, 0, Byte.valueOf(data));
    }

    public void clearBuildingMaterial() {
        this.buildingMaterial = null;
    }

    public ItemStack getBuildingMaterial() {
        return this.buildingMaterial;
    }

    public boolean hasBuildPermission(Location location) {
        return this.master.hasBuildPermission(this.player, location);
    }

    public boolean hasBuildPermission(Block block) {
        return this.master.hasBuildPermission(this.player, block);
    }

    public void onCast(SpellResult result) {
        switch (result) {
            case SUCCESS: {
                break;
            }
            case INSUFFICIENT_RESOURCES: {
                this.playSound(Sound.NOTE_BASS, 1.0f, 1.0f);
                break;
            }
            case COOLDOWN: {
                this.playSound(Sound.NOTE_SNARE_DRUM, 1.0f, 1.0f);
                break;
            }
            case NO_TARGET: {
                this.playSound(Sound.NOTE_STICKS, 1.0f, 1.0f);
                break;
            }
            case COST_FREE: {
                break;
            }
            default: {
                this.playSound(Sound.NOTE_BASS_DRUM, 1.0f, 1.0f);
            }
        }
    }

    public void playSound(Sound sound, float volume, float pitch) {
        if (this.master.soundsEnabled()) {
            this.player.playSound(this.player.getLocation(), sound, volume, pitch);
        }
    }
}

