/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic;

import com.elmakers.mine.bukkit.dao.BlockData;
import com.elmakers.mine.bukkit.plugins.magic.PlayerSpells;
import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.plugins.magic.SpellGroup;
import com.elmakers.mine.bukkit.plugins.magic.Spells;
import com.elmakers.mine.bukkit.plugins.magic.Wand;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class MagicPlugin
extends JavaPlugin {
    private final Spells spells = new Spells();
    private final Logger log = Logger.getLogger("Minecraft");

    public Spells getSpells() {
        return this.spells;
    }

    public void onEnable() {
        this.initialize();
        BlockData.setServer(this.getServer());
        PluginManager pm = this.getServer().getPluginManager();
        pm.registerEvents((Listener)this.spells, (Plugin)this);
        PluginDescriptionFile pdfFile = this.getDescription();
        this.log.info(String.valueOf(pdfFile.getName()) + " version " + pdfFile.getVersion() + " is enabled");
    }

    protected void initialize() {
        this.spells.initialize(this);
    }

    public boolean onCommand(CommandSender sender, Command cmd, String commandLabel, String[] args) {
        String commandName = cmd.getName();
        if (commandName.equalsIgnoreCase("magic") && args.length > 0) {
            String subCommand = args[0];
            if (sender instanceof Player && !this.spells.hasPermission((Player)sender, "Magic.commands.magic." + subCommand)) {
                return true;
            }
            if (subCommand.equalsIgnoreCase("reload")) {
                this.spells.clear();
                this.spells.load();
                return true;
            }
            if (subCommand.equalsIgnoreCase("reset")) {
                this.spells.reset();
                return true;
            }
        }
        if (!(sender instanceof Player)) {
            if (commandName.equalsIgnoreCase("spells")) {
                this.listSpells(sender, -1, null);
                return true;
            }
            if (commandName.equalsIgnoreCase("wand") && args.length > 0 && args[0].equalsIgnoreCase("list")) {
                this.onWandList(sender);
                return true;
            }
            return false;
        }
        Player player = (Player)sender;
        if (commandName.equalsIgnoreCase("wand")) {
            String subCommand = "";
            String[] args2 = args;
            if (args.length > 0) {
                subCommand = args[0];
                args2 = new String[args.length - 1];
                int i = 1;
                while (i < args.length) {
                    args2[i - 1] = args[i];
                    ++i;
                }
            }
            if (subCommand.equalsIgnoreCase("list")) {
                if (!this.spells.hasPermission(player, "Magic.commands.wand." + subCommand)) {
                    return true;
                }
                this.onWandList((CommandSender)player);
                return true;
            }
            if (subCommand.equalsIgnoreCase("add")) {
                if (!this.spells.hasPermission(player, "Magic.commands.wand." + subCommand)) {
                    return true;
                }
                this.onWandAdd(player, args2);
                return true;
            }
            if (subCommand.equalsIgnoreCase("configure")) {
                if (!this.spells.hasPermission(player, "Magic.commands.wand." + subCommand)) {
                    return true;
                }
                this.onWandConfigure(player, args2);
                return true;
            }
            if (subCommand.equalsIgnoreCase("remove")) {
                if (!this.spells.hasPermission(player, "Magic.commands.wand." + subCommand)) {
                    return true;
                }
                this.onWandRemove(player, args2);
                return true;
            }
            if (subCommand.equalsIgnoreCase("name")) {
                if (!this.spells.hasPermission(player, "Magic.commands.wand." + subCommand)) {
                    return true;
                }
                this.onWandName(player, args2);
                return true;
            }
            if (!this.spells.hasPermission(player, "Magic.commands.wand")) {
                return true;
            }
            return this.onWand(player, args);
        }
        if (commandName.equalsIgnoreCase("cast")) {
            if (!this.spells.hasPermission(player, "Magic.commands.cast")) {
                return true;
            }
            return this.onCast(player, args);
        }
        if (commandName.equalsIgnoreCase("spells")) {
            if (!this.spells.hasPermission(player, "Magic.commands.spells")) {
                return true;
            }
            return this.onSpells(player, args);
        }
        return false;
    }

    public boolean onWandList(CommandSender sender) {
        Collection<ConfigurationNode> templates = Wand.getWandTemplates();
        TreeMap<String, ConfigurationNode> nameMap = new TreeMap<String, ConfigurationNode>();
        for (ConfigurationNode templateConfig : templates) {
            nameMap.put(templateConfig.getString("key"), templateConfig);
        }
        for (ConfigurationNode templateConfig : nameMap.values()) {
            String key = templateConfig.getString("key");
            String name = templateConfig.getString("name");
            String description = templateConfig.getString("description");
            description = ChatColor.YELLOW + description;
            if (!name.equals(key)) {
                description = ChatColor.BLUE + name + ChatColor.WHITE + " : " + description;
            }
            sender.sendMessage(ChatColor.AQUA + key + ChatColor.WHITE + " : " + description);
        }
        return true;
    }

    public boolean onWandConfigure(Player player, String[] parameters) {
        if (parameters.length < 2) {
            player.sendMessage("Use: /wand configure <property> <value>");
            player.sendMessage("Properties: cost_reduction, uses, health_regeneration, hunger_regeneration, xp_regeneration,");
            player.sendMessage("  xp_max, damage_reduction, damage_reduction_physical, damage_reduction_projectiles,");
            player.sendMessage("  damage_reduction_falling,damage_reduction_fire, damage_reduction_explosions");
            return true;
        }
        PlayerSpells playerSpells = this.spells.getPlayerSpells(player);
        Wand wand = playerSpells.getActiveWand();
        if (wand == null) {
            player.sendMessage("Equip a wand first (use /wand if needed)");
            return true;
        }
        ConfigurationNode node = new ConfigurationNode();
        node.setProperty(parameters[0], parameters[1]);
        wand.deactivate();
        wand.configureProperties(node);
        wand.activate(playerSpells);
        return true;
    }

    public boolean onWandAdd(Player player, String[] parameters) {
        if (parameters.length < 1) {
            player.sendMessage("Use: /wand add <spell|material> [material]");
            return true;
        }
        PlayerSpells playerSpells = this.spells.getPlayerSpells(player);
        Wand wand = playerSpells.getActiveWand();
        if (wand == null) {
            player.sendMessage("Equip a wand first (use /wand if needed)");
            return true;
        }
        String spellName = parameters[0];
        if (spellName.equals("material")) {
            if (parameters.length < 2) {
                player.sendMessage("Use: /wand add material <material> [data]");
                return true;
            }
            String materialName = parameters[1];
            byte data = 0;
            Material material = Material.AIR;
            if (materialName.equals("erase")) {
                material = Wand.EraseMaterial;
            } else if (materialName.equals("clone") || materialName.equals("copy")) {
                material = Wand.CopyMaterial;
            } else {
                List<Material> buildingMaterials = this.spells.getBuildingMaterials();
                material = ConfigurationNode.toMaterial(materialName);
                if (material == null || material == Material.AIR || !buildingMaterials.contains(material)) {
                    player.sendMessage(String.valueOf(materialName) + " is not a valid material");
                    return true;
                }
                if (parameters.length > 2) {
                    data = (byte)Integer.parseInt(parameters[2]);
                }
            }
            wand.addMaterial(material, data);
            return true;
        }
        Spell spell = playerSpells.getSpell(spellName);
        if (spell == null) {
            player.sendMessage("Spell '" + spellName + "' unknown, Use /spells for spell list");
            return true;
        }
        wand.addSpell(spellName);
        return true;
    }

    public boolean onWandRemove(Player player, String[] parameters) {
        if (parameters.length < 1) {
            player.sendMessage("Use: /wand remove <spell|material> [material]");
            return true;
        }
        PlayerSpells playerSpells = this.spells.getPlayerSpells(player);
        Wand wand = playerSpells.getActiveWand();
        if (wand == null) {
            player.sendMessage("Equip a wand first (use /wand if needed)");
            return true;
        }
        String spellName = parameters[0];
        if (spellName.equals("material")) {
            if (parameters.length < 2) {
                player.sendMessage("Use: /wand remove material <material> [data]");
                return true;
            }
            String materialName = parameters[1];
            Material material = Material.AIR;
            byte data = 0;
            if (materialName.equals("erase")) {
                material = Wand.EraseMaterial;
            } else if (materialName.equals("copy") || materialName.equals("clone")) {
                material = Wand.CopyMaterial;
            } else {
                material = ConfigurationNode.toMaterial(materialName);
                if (parameters.length > 2) {
                    data = (byte)Integer.parseInt(parameters[2]);
                }
            }
            wand.removeMaterial(material, data);
            return true;
        }
        wand.removeSpell(spellName);
        return true;
    }

    public boolean onWandName(Player player, String[] parameters) {
        if (parameters.length < 1) {
            player.sendMessage("Use: /wand name <name>");
            return true;
        }
        PlayerSpells playerSpells = this.spells.getPlayerSpells(player);
        Wand wand = playerSpells.getActiveWand();
        if (wand == null) {
            player.sendMessage("Equip a wand first (use /wand if needed)");
            return true;
        }
        wand.setName(StringUtils.join((Object[])parameters, (String)" "));
        return true;
    }

    public boolean onWand(Player player, String[] parameters) {
        Wand wand;
        PlayerSpells playerSpells;
        Wand currentWand;
        String wandName = null;
        if (parameters.length > 0) {
            wandName = parameters[0];
        }
        if ((currentWand = (playerSpells = this.spells.getPlayerSpells(player)).getActiveWand()) != null) {
            currentWand.closeInventory();
        }
        if ((wand = Wand.createWand(this.spells, wandName)) == null) {
            player.sendMessage("No wand defined with key " + wandName);
            return true;
        }
        PlayerInventory inventory = player.getInventory();
        ItemStack inHand = inventory.getItemInHand();
        if (inHand == null || inHand.getType() == Material.AIR) {
            inventory.setItem(inventory.getHeldItemSlot(), wand.getItem());
            wand.activate(playerSpells);
        } else {
            player.getInventory().addItem(new ItemStack[]{wand.getItem()});
        }
        return true;
    }

    public boolean onCast(Player player, String[] castParameters) {
        if (castParameters.length < 1) {
            return false;
        }
        String spellName = castParameters[0];
        String[] parameters = new String[castParameters.length - 1];
        int i = 1;
        while (i < castParameters.length) {
            parameters[i - 1] = castParameters[i];
            ++i;
        }
        PlayerSpells playerSpells = this.spells.getPlayerSpells(player);
        Spell spell = playerSpells.getSpell(spellName);
        if (spell == null) {
            return false;
        }
        playerSpells.setCostReduction(1.0f);
        playerSpells.setCooldownReduction(1.0f);
        spell.cast(parameters);
        playerSpells.setCostReduction(0.0f);
        playerSpells.setCooldownReduction(0.0f);
        return true;
    }

    public boolean onReload(CommandSender sender, String[] parameters) {
        this.spells.load();
        sender.sendMessage("Configuration reloaded.");
        return true;
    }

    public boolean onSpells(Player player, String[] parameters) {
        int pageNumber = 1;
        String category = null;
        if (parameters.length > 0) {
            try {
                pageNumber = Integer.parseInt(parameters[0]);
            }
            catch (NumberFormatException ex) {
                pageNumber = 1;
                category = parameters[0];
            }
        }
        this.listSpells((CommandSender)player, pageNumber, category);
        return true;
    }

    public void listSpellsByCategory(CommandSender sender, String category) {
        ArrayList<Spell> categorySpells = new ArrayList<Spell>();
        List<Spell> spellVariants = this.spells.getAllSpells();
        Player player = sender instanceof Player ? (Player)sender : null;
        for (Spell spell : spellVariants) {
            if (!spell.getCategory().equalsIgnoreCase(category) || player != null && !spell.hasSpellPermission(player)) continue;
            categorySpells.add(spell);
        }
        if (categorySpells.size() == 0) {
            player.sendMessage("You don't know any spells");
            return;
        }
        Collections.sort(categorySpells);
        for (Spell spell : categorySpells) {
            String name = spell.getName();
            String description = spell.getDescription();
            if (!name.equals(spell.getKey())) {
                description = String.valueOf(name) + " : " + description;
            }
            player.sendMessage(ChatColor.AQUA + spell.getKey() + ChatColor.BLUE + " [" + spell.getMaterial().name().toLowerCase() + "] : " + ChatColor.YELLOW + description);
        }
    }

    public void listCategories(Player player) {
        HashMap<String, Integer> spellCounts = new HashMap<String, Integer>();
        ArrayList<String> spellGroups = new ArrayList<String>();
        List<Spell> spellVariants = this.spells.getAllSpells();
        for (Spell spell : spellVariants) {
            if (!spell.hasSpellPermission(player)) continue;
            Integer spellCount = (Integer)spellCounts.get(spell.getCategory());
            if (spellCount == null || spellCount == 0) {
                spellCounts.put(spell.getCategory(), 1);
                spellGroups.add(spell.getCategory());
                continue;
            }
            spellCounts.put(spell.getCategory(), spellCount + 1);
        }
        if (spellGroups.size() == 0) {
            player.sendMessage("You don't know any spells");
            return;
        }
        Collections.sort(spellGroups);
        for (String group : spellGroups) {
            player.sendMessage(String.valueOf(group) + " [" + spellCounts.get(group) + "]");
        }
    }

    public void listSpells(CommandSender sender, int pageNumber, String category) {
        if (category != null) {
            this.listSpellsByCategory(sender, category);
            return;
        }
        Player player = sender instanceof Player ? (Player)sender : null;
        HashMap<String, SpellGroup> spellGroups = new HashMap<String, SpellGroup>();
        List<Spell> spellVariants = this.spells.getAllSpells();
        int spellCount = 0;
        for (Spell spell : spellVariants) {
            if (player != null && !spell.hasSpellPermission(player)) continue;
            ++spellCount;
            SpellGroup group = (SpellGroup)spellGroups.get(spell.getCategory());
            if (group == null) {
                group = new SpellGroup();
                group.groupName = spell.getCategory();
                spellGroups.put(group.groupName, group);
            }
            group.spells.add(spell);
        }
        ArrayList sortedGroups = new ArrayList();
        sortedGroups.addAll(spellGroups.values());
        Collections.sort(sortedGroups);
        int maxLines = -1;
        if (pageNumber >= 0) {
            maxLines = 5;
            int maxPages = spellCount / maxLines + 1;
            if (pageNumber > maxPages) {
                pageNumber = maxPages;
            }
            sender.sendMessage("You know " + spellCount + " spells. [" + pageNumber + "/" + maxPages + "]");
        } else {
            sender.sendMessage("Listing " + spellCount + " spells.");
        }
        int currentPage = 1;
        int lineCount = 0;
        int printedCount = 0;
        block1: for (SpellGroup group : sortedGroups) {
            if (printedCount > maxLines && maxLines > 0) break;
            boolean isFirst = true;
            Collections.sort(group.spells);
            for (Spell spell : group.spells) {
                if (printedCount > maxLines && maxLines > 0) continue block1;
                if (currentPage == pageNumber || maxLines < 0) {
                    if (isFirst) {
                        sender.sendMessage(String.valueOf(group.groupName) + ":");
                        isFirst = false;
                    }
                    String name = spell.getName();
                    String description = spell.getDescription();
                    if (!name.equals(spell.getKey())) {
                        description = String.valueOf(name) + " : " + description;
                    }
                    sender.sendMessage(ChatColor.AQUA + spell.getKey() + ChatColor.BLUE + " [" + spell.getMaterial().name().toLowerCase() + "] : " + ChatColor.YELLOW + description);
                    ++printedCount;
                }
                if (++lineCount != maxLines) continue;
                lineCount = 0;
                ++currentPage;
            }
        }
    }

    public void onDisable() {
        this.spells.clear();
    }
}

