/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic;

import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.plugins.magic.Wand;
import com.elmakers.mine.bukkit.utilities.RandomUtils;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WandLevel {
    private static TreeMap<Integer, WandLevel> levelMap = null;
    private static int[] levels = null;
    private final TreeMap<Float, Integer> spellCountProbability = new TreeMap();
    private final TreeMap<Float, String> spellProbability = new TreeMap();

    public static WandLevel getLevel(int level) {
        if (levelMap == null) {
            return null;
        }
        if (!levelMap.containsKey(level)) {
            if (level > levelMap.lastKey()) {
                return levelMap.lastEntry().getValue();
            }
            return levelMap.firstEntry().getValue();
        }
        return levelMap.get(level);
    }

    public static void mapLevels(ConfigurationNode template) {
        levelMap = new TreeMap();
        String[] levelStrings = StringUtils.split((String)template.getString("levels"), (String)",");
        levels = new int[levelStrings.length];
        int i = 0;
        while (i < levels.length) {
            WandLevel.levels[i] = Integer.parseInt(levelStrings[i]);
            ++i;
        }
        int level = 1;
        while (level < levels[levels.length - 1]) {
            levelMap.put(level, new WandLevel(level, template));
            ++level;
        }
    }

    private WandLevel(int level, ConfigurationNode template) {
        int levelIndex = 0;
        int nextLevelIndex = 0;
        float distance = 1.0f;
        levelIndex = 0;
        while (levelIndex < levels.length) {
            if (level == levels[levelIndex] || levelIndex == levels.length - 1) {
                nextLevelIndex = levelIndex;
                distance = 0.0f;
                break;
            }
            if (level > levels[levelIndex]) {
                nextLevelIndex = levelIndex + 1;
                int previousLevel = levels[levelIndex];
                int nextLevel = levels[nextLevelIndex];
                distance = (float)(level - previousLevel) / (float)(nextLevel - previousLevel);
            }
            ++levelIndex;
        }
        Float currentThreshold = Float.valueOf(0.0f);
        ConfigurationNode spellCountNode = template.getNode("spell_count_probability");
        if (spellCountNode != null) {
            List<String> keys = spellCountNode.getKeys();
            for (String key : keys) {
                Integer spellCount = Integer.parseInt(key);
                String[] thresholdList = spellCountNode.getString(key).split(",");
                float previousThreshold = Float.parseFloat(thresholdList[levelIndex]);
                float nextThreshold = Float.parseFloat(thresholdList[nextLevelIndex]);
                Float threshold = Float.valueOf(previousThreshold + distance * (nextThreshold - previousThreshold));
                currentThreshold = Float.valueOf(currentThreshold.floatValue() + threshold.floatValue());
                this.spellCountProbability.put(currentThreshold, spellCount);
            }
        }
        currentThreshold = Float.valueOf(0.0f);
        ConfigurationNode spellsNode = template.getNode("spells");
        if (spellsNode != null) {
            List<String> keys = spellsNode.getKeys();
            Iterator<String> iterator = keys.iterator();
            while (iterator.hasNext()) {
                String key;
                String spellName = key = iterator.next();
                String[] thresholdList = spellsNode.getString(key).split(",");
                float previousThreshold = Float.parseFloat(thresholdList[levelIndex]);
                float nextThreshold = Float.parseFloat(thresholdList[nextLevelIndex]);
                Float threshold = Float.valueOf(previousThreshold + distance * (nextThreshold - previousThreshold));
                currentThreshold = Float.valueOf(currentThreshold.floatValue() + threshold.floatValue());
                this.spellProbability.put(currentThreshold, spellName);
            }
        }
    }

    private void randomizeWand(Wand wand, boolean additive) {
        Spell firstSpell = null;
        Integer spellCount = RandomUtils.weightedRandom(this.spellCountProbability);
        int i = 0;
        while (i < spellCount) {
            String spellKey = RandomUtils.weightedRandom(this.spellProbability);
            wand.addSpell(spellKey);
            if (firstSpell == null) {
                firstSpell = wand.getMaster().getSpell(spellKey);
            }
            ++i;
        }
        if (!additive) {
            String spellName = "Nothing";
            if (firstSpell != null) {
                spellName = firstSpell.getName();
            }
            String updatedName = wand.getName();
            wand.setName(updatedName.replace("{Spell}", spellName));
        }
    }

    public static void randomizeWand(Wand wand, boolean additive, int level) {
        WandLevel wandLevel = WandLevel.getLevel(level);
        wandLevel.randomizeWand(wand, additive);
    }

    public static Set<Integer> getLevels() {
        if (levels == null) {
            return null;
        }
        return levelMap.keySet();
    }
}

