/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic;

import com.elmakers.mine.bukkit.plugins.magic.Spells;
import com.elmakers.mine.bukkit.plugins.magic.Wand;
import com.elmakers.mine.bukkit.utilities.RandomUtils;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.TreeMap;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Chunk;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.Chest;
import org.bukkit.generator.BlockPopulator;
import org.bukkit.inventory.ItemStack;

public class WandChestPopulator
extends BlockPopulator {
    private static final Logger log = Logger.getLogger("Minecraft");
    private final Spells spells;
    private final TreeMap<Float, Integer> baseProbability = new TreeMap();
    private final TreeMap<Float, String> wandProbability = new TreeMap();

    public WandChestPopulator(Spells spells, ConfigurationNode config) {
        this.spells = spells;
        Float currentThreshold = Float.valueOf(0.0f);
        ConfigurationNode base = config.getNode("base_probability");
        if (base != null) {
            List<String> keys = base.getKeys();
            for (String key : keys) {
                Integer wandCount = Integer.parseInt(key);
                Float threshold = Float.valueOf((float)base.getDouble(key, 0.0));
                currentThreshold = Float.valueOf(currentThreshold.floatValue() + threshold.floatValue());
                this.baseProbability.put(currentThreshold, wandCount);
            }
        }
        currentThreshold = Float.valueOf(0.0f);
        ConfigurationNode wands = config.getNode("wand_probability");
        if (wands != null) {
            List<String> keys = wands.getKeys();
            Iterator<String> iterator = keys.iterator();
            while (iterator.hasNext()) {
                String key;
                String wandName = key = iterator.next();
                Float threshold = Float.valueOf((float)wands.getDouble(key, 0.0));
                currentThreshold = Float.valueOf(currentThreshold.floatValue() + threshold.floatValue());
                this.wandProbability.put(currentThreshold, wandName);
            }
        }
    }

    protected String[] populateChest(Chest chest) {
        Integer wandCount = RandomUtils.weightedRandom(this.baseProbability);
        String[] wandNames = new String[wandCount.intValue()];
        int i = 0;
        while (i < wandCount) {
            String wandName = RandomUtils.weightedRandom(this.wandProbability);
            Wand wand = Wand.createWand(this.spells, wandName);
            if (wand != null) {
                chest.getInventory().addItem(new ItemStack[]{wand.getItem()});
            } else {
                wandName = "*" + wandName;
            }
            wandNames[i] = wandName;
            ++i;
        }
        return wandNames;
    }

    public void populate(World world, Random random, Chunk source) {
        int x = 0;
        while (x < 15) {
            int z = 0;
            while (z < 15) {
                int y = 0;
                while (y < 255) {
                    Chest chest;
                    Object[] wandNames;
                    Block block = source.getBlock(x, y, z);
                    if (block.getType() == Material.CHEST && (wandNames = this.populateChest(chest = (Chest)block.getState())).length > 0) {
                        log.info("Added wands to chest: " + StringUtils.join((Object[])wandNames, (String)", ") + " at " + (x + source.getX() * 16) + "," + y + "," + (z + source.getZ() * 16));
                    }
                    ++y;
                }
                ++z;
            }
            ++x;
        }
    }
}

