/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spells;

import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.plugins.magic.SpellResult;
import com.elmakers.mine.bukkit.plugins.magic.Target;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import org.bukkit.Location;

public class BoomSpell
extends Spell {
    protected int defaultSize = 1;

    public SpellResult createExplosionAt(Location target, float size, boolean incendiary) {
        if (target == null) {
            this.castMessage("No target");
            return SpellResult.NO_TARGET;
        }
        this.player.getWorld().createExplosion(target.getBlock().getLocation(), size, incendiary);
        return SpellResult.SUCCESS;
    }

    public SpellResult onCast(ConfigurationNode parameters) {
        int size = parameters.getInt("size", this.defaultSize);
        boolean useFire = parameters.getBoolean("fire", false);
        String targetType = parameters.getString("target", "");
        if (targetType.equals("here")) {
            this.player.damage(100.0);
            return this.createExplosionAt(this.player.getLocation(), size, useFire);
        }
        Target target = this.getTarget();
        if (!target.hasTarget()) {
            this.castMessage("No target");
            return SpellResult.NO_TARGET;
        }
        return this.createExplosionAt(target.getLocation(), size, useFire);
    }
}

