/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utilities;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigInteger;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InventoryUtils {
    private static String versionPrefix = "";
    private static Class<?> class_ItemStack;
    private static Class<?> class_NBTBase;
    private static Class<?> class_NBTTagCompound;
    private static Class<?> class_NBTTagList;
    private static Class<?> class_CraftInventoryCustom;
    private static Class<?> class_CraftItemStack;

    static {
        try {
            String className = Bukkit.getServer().getClass().getName();
            String[] packages = className.split("\\.");
            if (packages.length == 5) {
                versionPrefix = String.valueOf(packages[3]) + ".";
            }
            class_ItemStack = InventoryUtils.fixBukkitClass("net.minecraft.server.ItemStack");
            class_NBTBase = InventoryUtils.fixBukkitClass("net.minecraft.server.NBTBase");
            class_NBTTagCompound = InventoryUtils.fixBukkitClass("net.minecraft.server.NBTTagCompound");
            class_NBTTagList = InventoryUtils.fixBukkitClass("net.minecraft.server.NBTTagList");
            class_CraftInventoryCustom = InventoryUtils.fixBukkitClass("org.bukkit.craftbukkit.inventory.CraftInventoryCustom");
            class_CraftItemStack = InventoryUtils.fixBukkitClass("org.bukkit.craftbukkit.inventory.CraftItemStack");
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    private static Class<?> fixBukkitClass(String className) {
        className = className.replace("org.bukkit.craftbukkit.", "org.bukkit.craftbukkit." + versionPrefix);
        className = className.replace("net.minecraft.server.", "net.minecraft.server." + versionPrefix);
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected static Object getNMSCopy(ItemStack stack) {
        Object nms = null;
        try {
            Method copyMethod = class_CraftItemStack.getMethod("asNMSCopy", stack.getClass());
            nms = copyMethod.invoke(null, stack);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        return nms;
    }

    protected static Object getHandle(ItemStack stack) {
        Object handle = null;
        try {
            Field handleField = stack.getClass().getDeclaredField("handle");
            handleField.setAccessible(true);
            handle = handleField.get(stack);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        return handle;
    }

    protected static Object getTag(Object mcItemStack) {
        Object tag = null;
        try {
            Field tagField = class_ItemStack.getField("tag");
            tag = tagField.get(mcItemStack);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        return tag;
    }

    public static ItemStack getCopy(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        try {
            Object craft = InventoryUtils.getNMSCopy(stack);
            Method mirrorMethod = class_CraftItemStack.getMethod("asCraftMirror", craft.getClass());
            stack = (ItemStack)mirrorMethod.invoke(null, craft);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        return stack;
    }

    public static String getMeta(ItemStack stack, String tag, String defaultValue) {
        String result = InventoryUtils.getMeta(stack, tag);
        return result == null ? defaultValue : result;
    }

    public static String getMeta(ItemStack stack, String tag) {
        Object tagObject;
        String meta;
        block6: {
            Object craft;
            block5: {
                if (stack == null) {
                    return null;
                }
                meta = null;
                craft = InventoryUtils.getHandle(stack);
                if (craft != null) break block5;
                return null;
            }
            tagObject = InventoryUtils.getTag(craft);
            if (tagObject != null) break block6;
            return null;
        }
        try {
            Method getStringMethod = class_NBTTagCompound.getMethod("getString", String.class);
            meta = (String)getStringMethod.invoke(tagObject, tag);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        return meta;
    }

    public static void setMeta(ItemStack stack, String tag, String value) {
        if (stack == null) {
            return;
        }
        try {
            Object craft = InventoryUtils.getHandle(stack);
            Object tagObject = InventoryUtils.getTag(craft);
            Method setStringMethod = class_NBTTagCompound.getMethod("setString", String.class, String.class);
            setStringMethod.invoke(tagObject, tag, value);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    public static void addGlow(ItemStack stack) {
        if (stack == null) {
            return;
        }
        try {
            Object craft = InventoryUtils.getHandle(stack);
            Object tagObject = InventoryUtils.getTag(craft);
            Object enchList = class_NBTTagList.newInstance();
            Method setMethod = class_NBTTagCompound.getMethod("set", String.class, class_NBTBase);
            setMethod.invoke(tagObject, "ench", enchList);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    public static String inventoryToString(Inventory inventory) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutput = new DataOutputStream(outputStream);
        try {
            Object itemList = class_NBTTagList.newInstance();
            int i = 0;
            while (i < inventory.getSize()) {
                Object outputObject = class_NBTTagCompound.newInstance();
                Object craft = null;
                ItemStack is = inventory.getItem(i);
                craft = is != null ? InventoryUtils.getNMSCopy(is) : null;
                if (craft != null && class_ItemStack.isInstance(craft)) {
                    Method saveMethod = class_ItemStack.getMethod("save", outputObject.getClass());
                    saveMethod.invoke(craft, outputObject);
                }
                Method addMethod = class_NBTTagList.getMethod("add", class_NBTBase);
                addMethod.invoke(itemList, outputObject);
                ++i;
            }
            Method saveMethod = class_NBTBase.getMethod("a", class_NBTBase, DataOutput.class);
            saveMethod.invoke(null, itemList, dataOutput);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        return new BigInteger(1, outputStream.toByteArray()).toString(32);
    }

    public static Inventory stringToInventory(String data, String name) {
        Inventory inventory = null;
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(new BigInteger(data, 32).toByteArray());
            Method loadMethod = class_NBTBase.getMethod("a", DataInput.class);
            Object itemList = loadMethod.invoke(null, new DataInputStream(inputStream));
            Method sizeMethod = class_NBTTagList.getMethod("size", new Class[0]);
            Method getMethod = class_NBTTagList.getMethod("get", Integer.TYPE);
            int listSize = (Integer)sizeMethod.invoke(itemList, new Object[0]);
            Method isEmptyMethod = class_NBTTagCompound.getMethod("isEmpty", new Class[0]);
            Method setItemMethod = class_CraftInventoryCustom.getMethod("setItem", Integer.TYPE, ItemStack.class);
            inventory = InventoryUtils.createInventory(null, listSize, name);
            int i = 0;
            while (i < listSize) {
                Object inputObject = getMethod.invoke(itemList, i);
                if (!((Boolean)isEmptyMethod.invoke(inputObject, new Object[0])).booleanValue()) {
                    Method createMethod = class_ItemStack.getMethod("createStack", inputObject.getClass());
                    Object newStack = createMethod.invoke(null, inputObject);
                    Method bukkitCopyMethod = class_CraftItemStack.getMethod("asBukkitCopy", class_ItemStack);
                    Object newCraftStack = bukkitCopyMethod.invoke(null, newStack);
                    setItemMethod.invoke((Object)inventory, i, newCraftStack);
                }
                ++i;
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        return inventory;
    }

    public static Inventory createInventory(InventoryHolder holder, int size, String name) {
        Inventory inventory = null;
        try {
            Constructor<?> inventoryConstructor = class_CraftInventoryCustom.getConstructor(InventoryHolder.class, Integer.TYPE, String.class);
            inventory = (Inventory)inventoryConstructor.newInstance(holder, size, ChatColor.translateAlternateColorCodes((char)'&', (String)name));
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        return inventory;
    }

    public static boolean inventorySetItem(Inventory inventory, int index, ItemStack item) {
        try {
            Method setItemMethod = class_CraftInventoryCustom.getMethod("setItem", Integer.TYPE, ItemStack.class);
            setItemMethod.invoke((Object)inventory, index, item);
            return true;
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return false;
        }
    }
}

