/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spells;

import com.elmakers.mine.bukkit.dao.BlockList;
import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.plugins.magic.SpellResult;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;

public class AlterSpell
extends Spell {
    static final String DEFAULT_ADJUSTABLES = "3 ,5, 6, 8, 9, 10,11,12,17,162,18,161,23,24,27,28,29,31,33,35,37,38,43,44,50,52,53,54,55,58,59,60,61,62,63,64,65,66,67,68,69,71,75,76,77,81,83,85,86,93,94,95,98,99,100,104,105,108,109,114,115,125,126,128,134,135,136,140,141,142,144,155,156,159,160,171,172,175";
    static final String DEFAULT_ADJUST_MAX = "2 ,5, 5 ,15,15,15,15,1 ,15,15 ,3 ,1  ,5 ,2 ,9 ,9 ,5 ,2 ,5 ,15,8 ,8 ,15,15,5, 15,3 ,5 ,15,5 ,7 ,8 ,5 ,5 ,15,15,3 ,9 ,3 ,2 ,14,15,5 ,5 ,15,15,15,5 ,0 ,5 ,5 ,5 ,3 ,15,15 ,7  ,7  ,3  ,3  ,3  ,7  ,15 ,15 ,3  ,3  ,3  ,3  ,15 ,7  ,7  ,4  ,4  ,3  ,15 ,15 ,15 ,15 ,6";
    static final String DEFAULT_ADJUST_MIN = "0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0  ,0 ,0  ,2 ,0 ,0, 0, 0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,2 ,0 ,2 ,0 ,0 ,2 ,2 ,0 ,0 ,0 ,0 ,0 ,5 ,6 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,3 ,2 ,2 ,2 ,0 ,0 ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0";
    static final String DEFAULT_RECURSABLES = "5,17,18,59,104,105,115,141,142";
    private List<Integer> adjustableMaterials = new ArrayList<Integer>();
    private List<Integer> maxData = new ArrayList<Integer>();
    private List<Integer> minData = new ArrayList<Integer>();
    private List<Integer> recursableMaterials = new ArrayList<Integer>();
    private int recurseDistance = 32;

    public SpellResult onCast(ConfigurationNode parameters) {
        Block targetBlock = this.getTargetBlock();
        if (targetBlock == null) {
            this.castMessage("No target");
            return SpellResult.NO_TARGET;
        }
        if (!this.adjustableMaterials.contains(targetBlock.getTypeId())) {
            this.castMessage("Can't adjust " + targetBlock.getType().name().toLowerCase());
            return SpellResult.FAILURE;
        }
        if (!this.hasBuildPermission(targetBlock)) {
            this.castMessage("You don't have permission to build here.");
            return SpellResult.INSUFFICIENT_PERMISSION;
        }
        BlockList undoList = new BlockList();
        byte originalData = targetBlock.getData();
        int materialIndex = this.adjustableMaterials.indexOf(targetBlock.getTypeId());
        int minValue = this.minData.get(materialIndex);
        int maxValue = this.maxData.get(materialIndex);
        int dataSize = maxValue - minValue + 1;
        byte data = (byte)((originalData - minValue + 1) % dataSize + minValue);
        boolean recursive = this.recursableMaterials.contains(targetBlock.getTypeId());
        this.adjust(targetBlock, data, undoList, recursive, 0);
        this.spells.addToUndoQueue(this.player, undoList);
        this.castMessage("Adjusting " + targetBlock.getType().name().toLowerCase() + " from " + originalData + " to " + data);
        return SpellResult.SUCCESS;
    }

    protected void adjust(Block block, byte dataValue, BlockList adjustedBlocks, boolean recursive, int rDepth) {
        adjustedBlocks.add(block);
        block.setData(dataValue);
        if (recursive && rDepth < this.recurseDistance) {
            Material targetMaterial = block.getType();
            this.tryAdjust(block.getRelative(BlockFace.NORTH), dataValue, targetMaterial, adjustedBlocks, rDepth + 1);
            this.tryAdjust(block.getRelative(BlockFace.WEST), dataValue, targetMaterial, adjustedBlocks, rDepth + 1);
            this.tryAdjust(block.getRelative(BlockFace.SOUTH), dataValue, targetMaterial, adjustedBlocks, rDepth + 1);
            this.tryAdjust(block.getRelative(BlockFace.EAST), dataValue, targetMaterial, adjustedBlocks, rDepth + 1);
            this.tryAdjust(block.getRelative(BlockFace.UP), dataValue, targetMaterial, adjustedBlocks, rDepth + 1);
            this.tryAdjust(block.getRelative(BlockFace.DOWN), dataValue, targetMaterial, adjustedBlocks, rDepth + 1);
        }
    }

    protected void tryAdjust(Block target, byte dataValue, Material targetMaterial, BlockList adjustedBlocks, int rDepth) {
        if (target.getType() != targetMaterial || adjustedBlocks.contains(target)) {
            return;
        }
        this.adjust(target, dataValue, adjustedBlocks, true, rDepth);
    }

    public void onLoad(ConfigurationNode properties) {
        this.recurseDistance = properties.getInteger("depth", this.recurseDistance);
        this.recursableMaterials = csv.parseIntegers(DEFAULT_RECURSABLES);
        this.adjustableMaterials = csv.parseIntegers(DEFAULT_ADJUSTABLES);
        this.maxData = csv.parseIntegers(DEFAULT_ADJUST_MAX);
        this.minData = csv.parseIntegers(DEFAULT_ADJUST_MIN);
        if (this.adjustableMaterials.size() != this.maxData.size() || this.maxData.size() != this.minData.size()) {
            this.spells.getLog().warning("Spells:Alter: Mis-match in adjustable material lists!");
        }
    }
}

