/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic;

import com.elmakers.mine.bukkit.dao.BlockList;
import com.elmakers.mine.bukkit.plugins.magic.CleanupBlocksTask;
import com.elmakers.mine.bukkit.plugins.magic.MagicPlugin;
import com.elmakers.mine.bukkit.plugins.magic.PlayerSpells;
import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.plugins.magic.SpellEventType;
import com.elmakers.mine.bukkit.plugins.magic.Wand;
import com.elmakers.mine.bukkit.utilities.CSVParser;
import com.elmakers.mine.bukkit.utilities.UndoQueue;
import com.elmakers.mine.bukkit.utilities.borrowed.Configuration;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Server;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.event.server.PluginEnableEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitScheduler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Spells
implements Listener {
    private final String spellsFileName = "spells.yml";
    private final String propertiesFileName = "magic.yml";
    private final String spellsFileNameDefaults = "spells.defaults.yml";
    private final String propertiesFileNameDefaults = "magic.defaults.yml";
    static final String DEFAULT_BUILDING_MATERIALS = "0,1,2,3,4,5,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,33,34,35,41,42,43,45,46,47,48,49,52,53,55,56,57,58,60,61,62,65,66,67,73,74,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,100,101,102,103,104,105,106,107,108,109";
    static final String DEFAULT_TARGET_THROUGH_MATERIALS = "0";
    static final String STICKY_MATERIALS = "37,38,39,50,51,55,59,63,64,65,66,68,70,71,72,75,76,77,78,83";
    static final String STICKY_MATERIALS_DOUBLE_HEIGHT = "64,71,";
    private List<Material> buildingMaterials = new ArrayList<Material>();
    private List<Material> stickyMaterials = new ArrayList<Material>();
    private List<Material> stickyMaterialsDoubleHeight = new ArrayList<Material>();
    private List<Material> targetThroughMaterials = new ArrayList<Material>();
    private long physicsDisableTimeout = 0L;
    private int undoQueueDepth = 256;
    private boolean silent = false;
    private boolean quiet = true;
    private boolean soundsEnabled = true;
    private HashMap<String, UndoQueue> playerUndoQueues = new HashMap();
    private final Logger log = Logger.getLogger("Minecraft");
    private final HashMap<String, Spell> spells = new HashMap();
    private final HashMap<Material, Spell> spellsByMaterial = new HashMap();
    private final HashMap<String, PlayerSpells> playerSpells = new HashMap();
    private MagicPlugin plugin = null;
    private Object regionManager = null;

    public PlayerSpells getPlayerSpells(Player player) {
        PlayerSpells spells = this.playerSpells.get(player.getName());
        if (spells == null) {
            spells = new PlayerSpells(this, player);
            this.playerSpells.put(player.getName(), spells);
        }
        spells.setPlayer(player);
        return spells;
    }

    public void createSpell(Spell template, String name, Material icon, String description, String category, String parameterString) {
        this.createSpell(template, name, icon, description, category, parameterString, null, null);
    }

    public void createSpell(Spell template, String name, Material icon, String description, String category, String parameterString, String propertiesString) {
        this.createSpell(template, name, icon, description, category, parameterString, propertiesString, null);
    }

    public void createSpell(Spell template, String name, Material icon, String description, String category, String parameterString, String propertiesString, String costsString) {
        ConfigurationNode spellNode = new ConfigurationNode();
        ConfigurationNode parameterNode = spellNode.createChild("parameters");
        ConfigurationNode propertiesNode = spellNode.createChild("properties");
        if (parameterString != null && parameterString.length() > 0) {
            String[] parameters = parameterString.split(" ");
            Spell.addParameters(parameters, parameterNode);
        }
        if (propertiesString != null && propertiesString.length() > 0) {
            String[] properties = propertiesString.split(" ");
            Spell.addParameters(properties, propertiesNode);
        }
        if (costsString != null && costsString.length() > 0) {
            ArrayList costs = new ArrayList();
            String[] costPairs = costsString.split(" ");
            int i = 0;
            while (i < costPairs.length - 1) {
                try {
                    int amount = Integer.parseInt(costPairs[i + 1]);
                    HashMap<String, Object> cost = new HashMap<String, Object>();
                    cost.put("material", costPairs[i]);
                    cost.put("amount", amount);
                    costs.add(cost);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                i += 2;
            }
            spellNode.setProperty("costs", costs);
        }
        spellNode.setProperty("description", description);
        spellNode.setProperty("icon", icon);
        spellNode.setProperty("category", category);
        template.initialize(this);
        template.load(name, spellNode);
        this.addSpell(template);
    }

    public void addSpell(Spell variant) {
        Spell conflict = this.spells.get(variant.getKey());
        if (conflict != null) {
            this.log.log(Level.WARNING, "Duplicate spell name: '" + conflict.getKey() + "'");
        } else {
            this.spells.put(variant.getKey(), variant);
        }
        Material m = variant.getMaterial();
        if (m != null && m != Material.AIR) {
            conflict = this.spellsByMaterial.get(m);
            if (conflict != null) {
                this.log.log(Level.WARNING, "Duplicate spell material: " + m.name() + " for " + conflict.getKey() + " and " + variant.getKey());
            } else {
                this.spellsByMaterial.put(variant.getMaterial(), variant);
            }
        }
    }

    public List<Material> getBuildingMaterials() {
        return this.buildingMaterials;
    }

    public List<Material> getTargetThroughMaterials() {
        return this.targetThroughMaterials;
    }

    public UndoQueue getUndoQueue(String playerName) {
        UndoQueue queue = this.playerUndoQueues.get(playerName);
        if (queue == null) {
            queue = new UndoQueue();
            queue.setMaxSize(this.undoQueueDepth);
            this.playerUndoQueues.put(playerName, queue);
        }
        return queue;
    }

    public void addToUndoQueue(Player player, BlockList blocks) {
        UndoQueue queue = this.getUndoQueue(player.getName());
        queue.add(blocks);
    }

    public boolean undoAny(Player player, Block target) {
        for (String playerName : this.playerUndoQueues.keySet()) {
            UndoQueue queue = this.playerUndoQueues.get(playerName);
            if (!queue.undo(target)) continue;
            if (!player.getName().equals(playerName)) {
                player.sendMessage("Undid one of " + playerName + "'s spells");
            }
            return true;
        }
        return false;
    }

    public boolean undo(String playerName) {
        UndoQueue queue = this.getUndoQueue(playerName);
        return queue.undo();
    }

    public boolean undo(String playerName, Block target) {
        UndoQueue queue = this.getUndoQueue(playerName);
        return queue.undo(target);
    }

    public BlockList getLastBlockList(String playerName, Block target) {
        UndoQueue queue = this.getUndoQueue(playerName);
        return queue.getLast(target);
    }

    public BlockList getLastBlockList(String playerName) {
        UndoQueue queue = this.getUndoQueue(playerName);
        return queue.getLast();
    }

    public void scheduleCleanup(BlockList blocks) {
        Server server = this.plugin.getServer();
        BukkitScheduler scheduler = server.getScheduler();
        long ticksToLive = blocks.getTimeToLive() * 20 / 1000;
        scheduler.scheduleSyncDelayedTask((Plugin)this.plugin, (Runnable)new CleanupBlocksTask(blocks), ticksToLive);
    }

    public void registerEvent(SpellEventType type, Spell spell) {
        PlayerSpells spells = this.getPlayerSpells(spell.getPlayer());
        spells.registerEvent(type, spell);
    }

    public void unregisterEvent(SpellEventType type, Spell spell) {
        PlayerSpells spells = this.getPlayerSpells(spell.getPlayer());
        spells.unregisterEvent(type, spell);
    }

    public boolean cancel(Player player) {
        PlayerSpells playerSpells = this.getPlayerSpells(player);
        return playerSpells.cancel();
    }

    public boolean isQuiet() {
        return this.quiet;
    }

    public boolean isSilent() {
        return this.silent;
    }

    public boolean soundsEnabled() {
        return this.soundsEnabled;
    }

    public boolean isSolid(Material mat) {
        return mat != Material.AIR && mat != Material.WATER && mat != Material.STATIONARY_WATER && mat != Material.LAVA && mat != Material.STATIONARY_LAVA;
    }

    public boolean isSticky(Material mat) {
        return this.stickyMaterials.contains(mat);
    }

    public boolean isStickyAndTall(Material mat) {
        return this.stickyMaterialsDoubleHeight.contains(mat);
    }

    public boolean isAffectedByGravity(Material mat) {
        return mat == Material.GRAVEL || mat == Material.SAND || mat == Material.WOOD_DOOR || mat == Material.IRON_DOOR;
    }

    public Logger getLog() {
        return this.log;
    }

    public MagicPlugin getPlugin() {
        return this.plugin;
    }

    public boolean hasBuildPermission(Player player, Location location) {
        return this.hasBuildPermission(player, location.getBlock());
    }

    public boolean hasBuildPermission(Player player, Block block) {
        if (this.regionManager == null) {
            return true;
        }
        try {
            Method canBuildMethod = this.regionManager.getClass().getMethod("canBuild", Player.class, Block.class);
            if (canBuildMethod != null) {
                return (Boolean)canBuildMethod.invoke(this.regionManager, player, block);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return true;
    }

    public void initialize(MagicPlugin plugin) {
        try {
            this.regionManager = plugin.getServer().getPluginManager().getPlugin("WorldGuard");
            Method canBuildMethod = this.regionManager.getClass().getMethod("canBuild", Player.class, Block.class);
            if (canBuildMethod != null) {
                this.log.info("WorldGuard found, will respect build permissions for construction spells");
            } else {
                this.regionManager = null;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.regionManager == null) {
            this.log.info("WorldGuard not found, not using a region manager.");
        }
        this.plugin = plugin;
        this.load();
        Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)plugin, new Runnable(){

            public void run() {
                for (PlayerSpells spells : Spells.this.playerSpells.values()) {
                    int hungerRegeneration;
                    int healthRegeneration;
                    Player player = spells.getPlayer();
                    if (!player.isOnline()) continue;
                    int xpRegeneration = spells.getXpRegeneration();
                    int xpMax = spells.getXPMax();
                    if (xpRegeneration > 0 && player.getTotalExperience() < xpMax) {
                        player.giveExp(xpRegeneration);
                    }
                    if ((healthRegeneration = spells.getHealthRegeneration()) > 0 && player.getHealth() < 20.0) {
                        player.setHealth(Math.min(20.0, player.getHealth() + (double)healthRegeneration));
                    }
                    if ((hungerRegeneration = spells.getHungerRegeneration()) <= 0 || player.getFoodLevel() >= 20) continue;
                    player.setExhaustion(0.0f);
                    player.setFoodLevel(Math.min(20, player.getFoodLevel() + hungerRegeneration));
                }
            }
        }, 0L, 20L);
    }

    public void load() {
        File dataFolder = this.plugin.getDataFolder();
        dataFolder.mkdirs();
        File propertiesFile = new File(dataFolder, "magic.yml");
        if (!propertiesFile.exists()) {
            File oldDefaults = new File(dataFolder, "magic.defaults.yml");
            oldDefaults.delete();
            this.plugin.saveResource("magic.defaults.yml", false);
            this.loadProperties(this.plugin.getResource("magic.defaults.yml"));
        } else {
            this.loadProperties(propertiesFile);
        }
        File spellsFile = new File(dataFolder, "spells.yml");
        if (!spellsFile.exists()) {
            File oldDefaults = new File(dataFolder, "spells.defaults.yml");
            oldDefaults.delete();
            this.plugin.saveResource("spells.defaults.yml", false);
            this.load(this.plugin.getResource("spells.defaults.yml"));
        } else {
            this.load(spellsFile);
        }
        Wand.load((Plugin)this.plugin);
        this.log.info("Magic: Loaded " + this.spells.size() + " spells and " + Wand.getWandTemplates().size() + " wands");
    }

    protected void save(File spellsFile) {
        Configuration config = new Configuration(spellsFile);
        ConfigurationNode spellsNode = config.createChild("spells");
        for (Spell spell : this.spells.values()) {
            ConfigurationNode spellNode = spellsNode.createChild(spell.getKey());
            spell.save(spellNode);
        }
        config.save();
    }

    protected void load(File spellsFile) {
        this.load(new Configuration(spellsFile));
    }

    protected void load(InputStream spellsConfig) {
        this.load(new Configuration(spellsConfig));
    }

    protected void load(Configuration config) {
        config.load();
        ConfigurationNode spellsNode = config.getNode("spells");
        if (spellsNode == null) {
            return;
        }
        List<String> spellKeys = spellsNode.getKeys();
        for (String key : spellKeys) {
            ConfigurationNode spellNode;
            Spell newSpell = Spell.loadSpell(key, spellNode = spellsNode.getNode(key), this);
            if (newSpell == null) {
                this.log.warning("Magic: Error loading spell " + key);
                continue;
            }
            this.addSpell(newSpell);
        }
    }

    protected void loadProperties(File propertiesFile) {
        this.loadProperties(new Configuration(propertiesFile));
    }

    protected void loadProperties(InputStream properties) {
        this.loadProperties(new Configuration(properties));
    }

    protected void loadProperties(Configuration properties) {
        properties.load();
        ConfigurationNode generalNode = properties.getNode("general");
        this.undoQueueDepth = generalNode.getInteger("undo_depth", this.undoQueueDepth);
        this.silent = generalNode.getBoolean("silent", this.silent);
        this.quiet = generalNode.getBoolean("quiet", this.quiet);
        this.soundsEnabled = generalNode.getBoolean("sounds", this.soundsEnabled);
        this.buildingMaterials = generalNode.getMaterials("building", DEFAULT_BUILDING_MATERIALS);
        this.targetThroughMaterials = generalNode.getMaterials("target_through", DEFAULT_TARGET_THROUGH_MATERIALS);
        CSVParser csv = new CSVParser();
        this.stickyMaterials = csv.parseMaterials(STICKY_MATERIALS);
        this.stickyMaterialsDoubleHeight = csv.parseMaterials(STICKY_MATERIALS_DOUBLE_HEIGHT);
        properties.save();
    }

    public void clear() {
        this.playerSpells.clear();
        this.spells.clear();
        this.spellsByMaterial.clear();
    }

    public void reset() {
        this.log.info("Magic: Resetting all spells to default");
        this.clear();
        File dataFolder = this.plugin.getDataFolder();
        dataFolder.mkdirs();
        File spellsFile = new File(dataFolder, "spells.yml");
        spellsFile.delete();
        File magicFile = new File(dataFolder, "magic.yml");
        magicFile.delete();
        Wand.reset((Plugin)this.plugin);
        this.load();
    }

    public List<Spell> getAllSpells() {
        ArrayList<Spell> allSpells = new ArrayList<Spell>();
        allSpells.addAll(this.spells.values());
        return allSpells;
    }

    public boolean allowPhysics(Block block) {
        if (this.physicsDisableTimeout == 0L) {
            return true;
        }
        if (System.currentTimeMillis() > this.physicsDisableTimeout) {
            this.physicsDisableTimeout = 0L;
        }
        return false;
    }

    public void disablePhysics(int interval) {
        this.physicsDisableTimeout = System.currentTimeMillis() + (long)interval;
    }

    public boolean hasWandPermission(Player player) {
        return this.hasPermission(player, "Magic.wand.use", true);
    }

    public boolean hasPermission(Player player, String pNode, boolean defaultValue) {
        boolean isSet = player.isPermissionSet(pNode);
        return isSet ? player.hasPermission(pNode) : defaultValue;
    }

    public boolean hasPermission(Player player, String pNode) {
        return this.hasPermission(player, pNode, false);
    }

    @EventHandler
    public void onContainerClick(InventoryDragEvent event) {
        ItemStack oldStack = event.getOldCursor();
        if (oldStack != null && oldStack.hasItemMeta()) {
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler
    public void onPlayerEquip(PlayerItemHeldEvent event) {
        boolean isWand;
        Player player = event.getPlayer();
        PlayerInventory inventory = player.getInventory();
        ItemStack previous = inventory.getItem(event.getPreviousSlot());
        ItemStack next = inventory.getItem(event.getNewSlot());
        boolean wasWand = previous != null && Wand.isWand(previous);
        boolean bl = isWand = next != null && Wand.isWand(next);
        if (wasWand == isWand) {
            return;
        }
        PlayerSpells playerSpells = this.getPlayerSpells(player);
        if (wasWand) {
            Wand wand = new Wand(previous);
            if (wand.isInventoryOpen(playerSpells)) {
                if (isWand) {
                    return;
                }
                if (next != null && next.getType() != Material.AIR) {
                    Spell spell;
                    Spell spell2 = spell = Wand.isSpell(next) ? playerSpells.getSpell(next.getType()) : null;
                    if (spell != null) {
                        playerSpells.cancel();
                        wand.setActiveSpell(playerSpells, spell.getKey());
                    } else {
                        Material material = next.getType();
                        if (this.buildingMaterials.contains(material) || material == Wand.EraseMaterial || material == Wand.CopyMaterial) {
                            wand.setActiveMaterial(playerSpells, material, next.getData().getData());
                        }
                    }
                }
                event.setCancelled(true);
            } else {
                wand.deactivate(playerSpells, event.getPreviousSlot());
            }
        }
        if (isWand) {
            Wand newWand = new Wand(next);
            newWand.activate(playerSpells);
        }
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent event) {
        PlayerSpells spells = this.getPlayerSpells(event.getPlayer());
        spells.onPlayerMove(event);
    }

    @EventHandler
    public void onEntityDeath(EntityDeathEvent event) {
        if (event.getEntityType() == EntityType.PLAYER && event.getEntity() instanceof Player) {
            this.onPlayerDeath((Player)event.getEntity(), event);
        }
    }

    public void onPlayerDeath(Player player, EntityDeathEvent event) {
        PlayerSpells spells = this.getPlayerSpells(player);
        String rule = player.getWorld().getGameRuleValue("keepInventory");
        Wand wand = Wand.getActiveWand(player);
        if (wand != null && !rule.equals("true")) {
            List drops = event.getDrops();
            drops.clear();
            drops.add(wand.getItem());
            ItemStack[] stored = spells.getStoredInventory().getContents();
            wand.deactivate(spells);
            player.getInventory().clear();
            ItemStack[] itemStackArray = stored;
            int n = stored.length;
            int n2 = 0;
            while (n2 < n) {
                ItemStack stack = itemStackArray[n2];
                if (stack != null) {
                    drops.add(stack);
                }
                ++n2;
            }
        }
        spells.onPlayerDeath(event);
    }

    public void onPlayerDamage(Player player, EntityDamageEvent event) {
        PlayerSpells spells = this.getPlayerSpells(player);
        spells.onPlayerDamage(event);
    }

    @EventHandler
    public void onEntityDamage(EntityDamageEvent event) {
        if (Player.class.isInstance(event.getEntity())) {
            Player player = (Player)event.getEntity();
            this.onPlayerDamage(player, event);
        }
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        boolean toggleInventory;
        Player player = event.getPlayer();
        PlayerSpells spells = this.getPlayerSpells(player);
        Wand wand = Wand.getActiveWand(player);
        if (wand == null || !this.hasWandPermission(player)) {
            return;
        }
        if (event.getAction() == Action.LEFT_CLICK_AIR || event.getAction() == Action.LEFT_CLICK_BLOCK) {
            wand.cast(spells);
        }
        boolean bl = toggleInventory = event.getAction() == Action.RIGHT_CLICK_AIR;
        if (!toggleInventory && event.getAction() == Action.RIGHT_CLICK_BLOCK) {
            Material material = event.getMaterial();
            boolean bl2 = toggleInventory = material != Material.CHEST && material != Material.WOODEN_DOOR && material != Material.IRON_DOOR_BLOCK && material != Material.ENDER_CHEST && material != Material.ANVIL && material != Material.BREWING_STAND && material != Material.ENCHANTMENT_TABLE && material != Material.STONE_BUTTON && material != Material.LEVER && material != Material.FURNACE;
        }
        if (toggleInventory) {
            if (!spells.cancel()) {
                if (wand.isInventoryOpen(spells)) {
                    spells.playSound(Sound.CHEST_CLOSE, 0.4f, 0.2f);
                    wand.closeInventory(spells);
                } else {
                    spells.playSound(Sound.CHEST_OPEN, 0.4f, 0.2f);
                    wand.openInventory(spells);
                }
            } else {
                spells.playSound(Sound.NOTE_BASS, 1.0f, 0.7f);
            }
        }
    }

    @EventHandler
    public void onBlockPhysics(BlockPhysicsEvent event) {
        if (!this.allowPhysics(event.getBlock())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        Wand wand = Wand.getActiveWand(player);
        if (wand != null) {
            wand.activate(this.getPlayerSpells(player));
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        PlayerSpells spells = this.getPlayerSpells(player);
        Wand wand = Wand.getActiveWand(player);
        if (wand != null) {
            wand.deactivate(spells);
        }
        spells.restoreInventory();
        spells.onPlayerQuit(event);
    }

    @EventHandler
    public void onPluginDisable(PluginDisableEvent event) {
        for (PlayerSpells spells : this.playerSpells.values()) {
            Player player = spells.getPlayer();
            Wand wand = Wand.getActiveWand(player);
            if (wand != null) {
                wand.deactivate(spells);
            }
            spells.restoreInventory();
            player.updateInventory();
        }
    }

    @EventHandler
    public void onPluginEnable(PluginEnableEvent event) {
        Player[] players;
        Player[] playerArray = players = this.plugin.getServer().getOnlinePlayers();
        int n = players.length;
        int n2 = 0;
        while (n2 < n) {
            Player player = playerArray[n2];
            Wand wand = Wand.getActiveWand(player);
            if (wand != null) {
                PlayerSpells spells = this.getPlayerSpells(player);
                wand.activate(spells);
                player.updateInventory();
            }
            ++n2;
        }
    }

    @EventHandler
    public void onPlayerCraftItem(CraftItemEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        PlayerSpells spells = this.getPlayerSpells(player);
        if (spells.hasStoredInventory()) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onInventoryOpen(InventoryOpenEvent event) {
        if (!(event.getPlayer() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getPlayer();
        PlayerSpells playerSpells = this.getPlayerSpells(player);
        Wand wand = Wand.getActiveWand(player);
        if (wand != null && wand.isInventoryOpen(playerSpells)) {
            wand.closeInventory(playerSpells);
        }
    }

    @EventHandler
    public void onPlayerPickupItem(PlayerPickupItemEvent event) {
        PlayerSpells spells = this.getPlayerSpells(event.getPlayer());
        if (spells.hasStoredInventory()) {
            event.setCancelled(true);
            if (spells.addToStoredInventory(event.getItem().getItemStack())) {
                event.getItem().remove();
            }
        } else {
            PlayerInventory inventory = event.getPlayer().getInventory();
            ItemStack inHand = inventory.getItemInHand();
            ItemStack pickup = event.getItem().getItemStack();
            if (Wand.isWand(pickup) && (inHand == null || inHand.getType() == Material.AIR)) {
                Wand wand = new Wand(pickup);
                event.setCancelled(true);
                event.getItem().remove();
                inventory.setItem(inventory.getHeldItemSlot(), pickup);
                wand.activate(spells);
            }
        }
    }

    @EventHandler
    public void onPlayerDropItem(PlayerDropItemEvent event) {
        Player player = event.getPlayer();
        PlayerSpells spells = this.getPlayerSpells(player);
        if (spells.hasStoredInventory()) {
            ItemStack inHand = event.getPlayer().getInventory().getItemInHand();
            if (Wand.isWand(event.getItemDrop().getItemStack()) && (inHand == null || inHand.getType() == Material.AIR)) {
                Wand wand = new Wand(event.getItemDrop().getItemStack());
                wand.deactivate(spells);
                player.setItemInHand(new ItemStack(Material.AIR, 1));
            } else {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        if (event.getView().getType() != InventoryType.CRAFTING) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        PlayerInventory inventory = player.getInventory();
        PlayerSpells spells = this.getPlayerSpells(player);
        if (spells.hasStoredInventory() && event.getSlot() == inventory.getHeldItemSlot()) {
            event.setCancelled(true);
        }
    }

    public Spell getSpell(Material material) {
        return this.spellsByMaterial.get(material);
    }

    public Spell getSpell(String name) {
        return this.spells.get(name);
    }
}

