/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spells;

import com.elmakers.mine.bukkit.dao.BlockList;
import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.plugins.magic.SpellResult;
import com.elmakers.mine.bukkit.plugins.magic.Target;
import com.elmakers.mine.bukkit.utilities.SimpleBlockAction;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public class FrostSpell
extends Spell {
    private int defaultRadius = 2;
    private int verticalSearchDistance = 8;
    private int timeToLive = 60000;

    public SpellResult onCast(ConfigurationNode parameters) {
        Entity targetEntity;
        Target target = this.getTarget();
        if (target == null) {
            this.castMessage("No target");
            return SpellResult.NO_TARGET;
        }
        if (target.isEntity() && (targetEntity = target.getEntity()) instanceof LivingEntity) {
            LivingEntity li = (LivingEntity)targetEntity;
            if (li instanceof Player) {
                li.damage(1.0);
            } else {
                li.damage(10.0);
            }
        }
        if (!target.hasTarget()) {
            this.castMessage("No target");
            return SpellResult.NO_TARGET;
        }
        if (!this.hasBuildPermission(target.getBlock())) {
            this.castMessage("You don't have permission to build here.");
            return SpellResult.INSUFFICIENT_PERMISSION;
        }
        int radius = parameters.getInt("radius", this.defaultRadius);
        FrostAction action = new FrostAction();
        if (radius <= 1) {
            action.perform(target.getBlock());
        } else {
            this.coverSurface(target.getLocation(), radius, action);
        }
        BlockList frozenBlocks = action.getBlocks();
        frozenBlocks.setTimeToLive(this.timeToLive);
        this.spells.scheduleCleanup(frozenBlocks);
        this.castMessage("Frosted " + action.getBlocks().size() + " blocks");
        return SpellResult.SUCCESS;
    }

    public int checkPosition(int x, int z, int R) {
        return x * x + z * z - R * R;
    }

    public void onLoad(ConfigurationNode properties) {
        this.noTargetThrough(Material.WATER);
        this.noTargetThrough(Material.STATIONARY_WATER);
        this.defaultRadius = properties.getInteger("radius", this.defaultRadius);
        this.verticalSearchDistance = properties.getInteger("vertical_search_distance", this.verticalSearchDistance);
        this.timeToLive = properties.getInt("duration", this.timeToLive);
    }

    public class FrostAction
    extends SimpleBlockAction {
        public SpellResult perform(Block block) {
            if (block.getType() == Material.AIR || block.getType() == Material.SNOW) {
                return SpellResult.NO_TARGET;
            }
            Material material = Material.SNOW;
            if (block.getType() == Material.WATER || block.getType() == Material.STATIONARY_WATER) {
                material = Material.ICE;
            } else if (block.getType() == Material.LAVA) {
                material = Material.COBBLESTONE;
            } else if (block.getType() == Material.STATIONARY_LAVA) {
                material = Material.OBSIDIAN;
            } else if (block.getType() == Material.FIRE) {
                material = Material.AIR;
            } else {
                block = block.getRelative(BlockFace.UP);
            }
            super.perform(block);
            block.setType(material);
            return SpellResult.SUCCESS;
        }
    }
}

