/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spells;

import com.elmakers.mine.bukkit.dao.BlockList;
import com.elmakers.mine.bukkit.plugins.magic.PlayerSpells;
import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.plugins.magic.SpellResult;
import com.elmakers.mine.bukkit.utilities.BlockRecurse;
import com.elmakers.mine.bukkit.utilities.ReplaceMaterialAction;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.inventory.ItemStack;

public class FillSpell
extends Spell {
    private int defaultMaxDimension = 128;
    private int defaultMaxVolume = 512;
    private Block targetBlock = null;
    private final BlockRecurse blockRecurse = new BlockRecurse();

    public SpellResult onCast(ConfigurationNode parameters) {
        this.noTargetThrough(Material.STATIONARY_WATER);
        this.noTargetThrough(Material.WATER);
        Block targetBlock = this.getTargetBlock();
        Material material = Material.AIR;
        byte data = 0;
        boolean singleBlock = false;
        boolean recurse = false;
        boolean overrideMaterial = false;
        ItemStack buildWith = this.getBuildingMaterial();
        if (buildWith != null) {
            material = buildWith.getType();
            data = FillSpell.getItemData(buildWith);
            overrideMaterial = true;
        }
        String typeString = parameters.getString("type", "");
        singleBlock = typeString.equals("single");
        recurse = typeString.equals("recurse");
        Material materialOverride = parameters.getMaterial("material");
        if (materialOverride != null) {
            material = materialOverride;
            data = 0;
            overrideMaterial = true;
        }
        if (targetBlock == null) {
            this.castMessage("No target");
            return SpellResult.NO_TARGET;
        }
        if (!this.hasBuildPermission(targetBlock)) {
            this.castMessage("You don't have permission to build here.");
            return SpellResult.INSUFFICIENT_PERMISSION;
        }
        if (recurse) {
            this.targetBlock = null;
            PlayerSpells playerSpells = this.spells.getPlayerSpells(this.player);
            Material targetMaterial = targetBlock.getType();
            ReplaceMaterialAction action = new ReplaceMaterialAction(playerSpells, targetBlock, material, data);
            if (targetMaterial == Material.STATIONARY_WATER) {
                action.addReplaceable(Material.WATER);
            } else if (targetMaterial == Material.WATER) {
                action.addReplaceable(Material.STATIONARY_WATER);
            } else if (targetMaterial == Material.STATIONARY_LAVA) {
                action.addReplaceable(Material.LAVA);
            } else if (targetMaterial == Material.LAVA) {
                action.addReplaceable(Material.STATIONARY_LAVA);
            }
            this.blockRecurse.recurse(targetBlock, action);
            this.spells.addToUndoQueue(this.player, action.getBlocks());
            this.castMessage("Filled " + action.getBlocks().size() + " blocks with " + material.name().toLowerCase());
            return SpellResult.SUCCESS;
        }
        if (singleBlock) {
            this.targetBlock = null;
            BlockList filledBlocks = new BlockList();
            filledBlocks.add(targetBlock);
            targetBlock.setType(material);
            targetBlock.setData(data);
            this.castMessage("Painting with " + material.name().toLowerCase());
            this.spells.addToUndoQueue(this.player, filledBlocks);
            return SpellResult.SUCCESS;
        }
        if (this.targetBlock != null) {
            int maxVolume;
            int deltax = targetBlock.getX() - this.targetBlock.getX();
            int deltay = targetBlock.getY() - this.targetBlock.getY();
            int deltaz = targetBlock.getZ() - this.targetBlock.getZ();
            int absx = Math.abs(deltax);
            int absy = Math.abs(deltay);
            int absz = Math.abs(deltaz);
            int maxDimension = this.player.isOp() ? this.defaultMaxDimension * 10 : this.defaultMaxDimension;
            int n = maxVolume = this.player.isOp() ? this.defaultMaxVolume * 10 : this.defaultMaxVolume;
            if (maxDimension > 0 && (absx > maxDimension || absy > maxDimension || absz > maxDimension)) {
                this.castMessage("Dimension is too big!");
                return SpellResult.FAILURE;
            }
            if (maxVolume > 0 && absx * absy * absz > maxVolume) {
                this.castMessage("Volume is too big!");
                return SpellResult.FAILURE;
            }
            int dx = (int)Math.signum(deltax);
            int dy = (int)Math.signum(deltay);
            int dz = (int)Math.signum(deltaz);
            ++absx;
            ++absy;
            ++absz;
            if (!overrideMaterial) {
                material = this.targetBlock.getType();
                data = this.targetBlock.getData();
            }
            BlockList filledBlocks = new BlockList();
            this.castMessage("Filling " + absx + "x" + absy + "x" + absz + " area with " + material.name().toLowerCase());
            int x = this.targetBlock.getX();
            int y = this.targetBlock.getY();
            int z = this.targetBlock.getZ();
            int ix = 0;
            while (ix < absx) {
                int iy = 0;
                while (iy < absy) {
                    int iz = 0;
                    while (iz < absz) {
                        Block block = this.getBlockAt(x + ix * dx, y + iy * dy, z + iz * dz);
                        if (this.hasBuildPermission(block)) {
                            filledBlocks.add(block);
                            block.setType(material);
                            block.setData(data);
                        }
                        ++iz;
                    }
                    ++iy;
                }
                ++ix;
            }
            this.spells.addToUndoQueue(this.player, filledBlocks);
            this.targetBlock = null;
            return SpellResult.SUCCESS;
        }
        this.targetBlock = targetBlock;
        if (!overrideMaterial) {
            material = targetBlock.getType();
        }
        this.castMessage("Cast again to fill with " + material.name().toLowerCase());
        return SpellResult.SUCCESS;
    }

    public void onCancel() {
        if (this.targetBlock != null) {
            this.castMessage("Cancelled fill");
            this.targetBlock = null;
        }
    }

    public void onLoad(ConfigurationNode properties) {
        this.defaultMaxDimension = properties.getInteger("max_dimension", this.defaultMaxDimension);
        this.defaultMaxVolume = properties.getInteger("max_volume", this.defaultMaxVolume);
    }

    public boolean usesMaterial() {
        return true;
    }
}

