/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spells;

import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.plugins.magic.SpellResult;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.bukkit.Location;
import org.bukkit.entity.Arrow;
import org.bukkit.util.Vector;

public class ArrowSpell
extends Spell {
    public SpellResult onCast(ConfigurationNode parameters) {
        int arrowCount = 1;
        arrowCount = parameters.getInt("count", arrowCount);
        boolean useFire = parameters.getBoolean("fire", false);
        Arrow firstArrow = null;
        float speed = 3.0f;
        float spread = 0.1f;
        int ai = 0;
        while (ai < arrowCount) {
            Arrow arrow = null;
            if (firstArrow == null) {
                firstArrow = arrow = (Arrow)this.player.launchProjectile(Arrow.class);
            } else {
                Location location = firstArrow.getLocation();
                Vector velocity = firstArrow.getVelocity();
                location.setX(location.getX() + velocity.getX() * (1.0 + Math.random() * (double)arrowCount));
                location.setY(location.getY() + velocity.getY() * (1.0 + Math.random() * (double)arrowCount));
                location.setZ(location.getZ() + velocity.getZ() * (1.0 + Math.random() * (double)arrowCount));
                arrow = this.player.getWorld().spawnArrow(location, velocity, speed, spread);
            }
            if (arrow == null) {
                this.sendMessage(this.player, "One of your arrows fizzled");
                return SpellResult.FAILURE;
            }
            if (useFire) {
                arrow.setFireTicks(300);
            }
            try {
                Method getHandleMethod = arrow.getClass().getMethod("getHandle", new Class[0]);
                Object handle = getHandleMethod.invoke((Object)arrow, new Object[0]);
                Field fromPlayerField = handle.getClass().getField("fromPlayer");
                fromPlayerField.setInt(handle, 2);
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
            arrow.setTicksLived(300);
            ++ai;
        }
        this.castMessage("You fire some magical arrows");
        return SpellResult.SUCCESS;
    }

    public void onLoad(ConfigurationNode node) {
        this.disableTargeting();
    }
}

