/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spells;

import com.elmakers.mine.bukkit.plugins.magic.PlayerSpells;
import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.plugins.magic.SpellResult;
import com.elmakers.mine.bukkit.plugins.magic.Wand;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public class AbsorbSpell
extends Spell {
    public SpellResult onCast(ConfigurationNode parameters) {
        Material material = Material.AIR;
        List<Material> buildingMaterials = this.spells.getBuildingMaterials();
        material = parameters.getMaterial("material", material);
        byte data = 0;
        boolean success = false;
        if (material == Material.AIR || !buildingMaterials.contains(material)) {
            Block target;
            if (!this.isUnderwater()) {
                this.noTargetThrough(Material.STATIONARY_WATER);
                this.noTargetThrough(Material.WATER);
            }
            if ((target = this.getTargetBlock()) == null) {
                this.castMessage("No target");
                return SpellResult.NO_TARGET;
            }
            material = target.getType();
            data = target.getData();
        }
        Wand wand = Wand.getActiveWand(this.player);
        PlayerSpells playerSpells = this.spells.getPlayerSpells(this.player);
        if (wand != null) {
            ItemStack currentItem;
            int targetSlot = 8;
            PlayerInventory inventory = this.player.getInventory();
            if (inventory.getHeldItemSlot() == 8) {
                targetSlot = 7;
            }
            if ((currentItem = inventory.getItem(targetSlot)) != null && currentItem.getType() != Material.AIR) {
                if (Wand.isSpell(currentItem) || currentItem.getType() == Wand.EraseMaterial) {
                    ItemStack[] contents = inventory.getContents();
                    boolean full = true;
                    ItemStack[] itemStackArray = contents;
                    int n = contents.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ItemStack stack = itemStackArray[n2];
                        if (stack == null || stack.getType() == Material.AIR) {
                            full = false;
                            break;
                        }
                        ++n2;
                    }
                    if (full) {
                        this.castMessage("Your wand is full!");
                        return SpellResult.FAILURE;
                    }
                }
                inventory.setItem(targetSlot, new ItemStack(Material.AIR, 1));
                wand.deactivate(playerSpells);
                this.addMaterialToWand(material, data);
                wand.activate(playerSpells);
                if (Wand.isSpell(currentItem) || currentItem.getType() == Wand.EraseMaterial) {
                    inventory.addItem(new ItemStack[]{currentItem});
                }
            }
        }
        if (!success) {
            success = this.addMaterialToWand(material, data);
        }
        if (success) {
            this.castMessage("Absorbing some " + material.name().toLowerCase());
        } else {
            this.castMessage("Failed to absorb");
        }
        return success ? SpellResult.SUCCESS : SpellResult.FAILURE;
    }
}

