/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utilities.borrowed;

import com.elmakers.mine.bukkit.utilities.CSVParser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.bukkit.Material;

public class ConfigurationNode {
    protected Map<String, Object> root;
    protected static CSVParser csv = new CSVParser();

    public ConfigurationNode createChild(String name) {
        HashMap newChild = new HashMap();
        this.setProperty(name, newChild);
        Object raw = this.getProperty(name);
        if (raw instanceof Map) {
            return new ConfigurationNode((Map)raw);
        }
        return null;
    }

    public ConfigurationNode() {
        this.root = new HashMap<String, Object>();
    }

    public ConfigurationNode(ConfigurationNode copy) {
        HashMap<String, Object> newRoot = new HashMap<String, Object>();
        if (copy != null) {
            newRoot.putAll(copy.root);
        }
        this.root = newRoot;
    }

    public ConfigurationNode(Map<String, Object> root) {
        this.root = root;
    }

    public Map<String, Object> getAll() {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        Set<String> keys = this.root.keySet();
        for (String k : keys) {
            Object tmp = this.root.get(k);
            if (tmp instanceof Map) {
                Map<String, Object> rec = this.recursiveBuilder((Map)tmp);
                Set<String> subkeys = rec.keySet();
                for (String sk : subkeys) {
                    map.put(String.valueOf(k) + "." + sk, rec.get(sk));
                }
                continue;
            }
            map.put(k, tmp);
        }
        return map;
    }

    protected Map<String, Object> recursiveBuilder(Map<String, Object> node) {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        Set<String> keys = node.keySet();
        for (String k : keys) {
            Object tmp = node.get(k);
            if (tmp instanceof Map) {
                Map<String, Object> rec = this.recursiveBuilder((Map)tmp);
                Set<String> subkeys = rec.keySet();
                for (String sk : subkeys) {
                    map.put(String.valueOf(k) + "." + sk, rec.get(sk));
                }
                continue;
            }
            map.put(k, tmp);
        }
        return map;
    }

    public Object getProperty(String path) {
        if (!path.contains(".")) {
            Object val = this.root.get(path);
            if (val == null) {
                return null;
            }
            return val;
        }
        String[] parts = path.split("\\.");
        Map node = this.root;
        int i = 0;
        while (i < parts.length) {
            Object o = node.get(parts[i]);
            if (o == null) {
                return null;
            }
            if (i == parts.length - 1) {
                return o;
            }
            try {
                node = (Map)o;
            }
            catch (ClassCastException e) {
                return null;
            }
            ++i;
        }
        return null;
    }

    public void setProperty(String path, Object value) {
        if (value instanceof Material) {
            Material matValue = (Material)value;
            value = matValue.name().toLowerCase();
        }
        if (!path.contains(".")) {
            this.root.put(path, value);
            return;
        }
        String[] parts = path.split("\\.");
        Map node = this.root;
        int i = 0;
        while (i < parts.length) {
            HashMap o = node.get(parts[i]);
            if (i == parts.length - 1) {
                node.put((String)parts[i], (Object)value);
                return;
            }
            if (o == null || !(o instanceof Map)) {
                o = new HashMap();
                node.put(parts[i], o);
            }
            node = o;
            ++i;
        }
    }

    public String getString(String path) {
        Object o = this.getProperty(path);
        if (o == null) {
            return null;
        }
        return o.toString();
    }

    public Material getMaterial(String path) {
        Object o = this.getProperty(path);
        if (o == null) {
            return null;
        }
        return ConfigurationNode.toMaterial(o);
    }

    public static Material toMaterial(Object o) {
        if (o instanceof Material) {
            return (Material)o;
        }
        if (o instanceof Integer) {
            return Material.values()[(Integer)o];
        }
        if (o instanceof String) {
            String matName = (String)o;
            try {
                Integer value = Integer.parseInt(matName);
                if (value != null) {
                    return Material.values()[value];
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return Material.valueOf((String)matName.toUpperCase());
        }
        return null;
    }

    public Material getMaterial(String path, Material def) {
        Material o = this.getMaterial(path);
        if (o == null) {
            this.setProperty(path, def);
            return def;
        }
        return o;
    }

    public String getString(String path, String def) {
        String o = this.getString(path);
        if (o == null) {
            this.setProperty(path, def);
            return def;
        }
        return o;
    }

    public int getInt(String path, int def) {
        Integer o = ConfigurationNode.castInt(this.getProperty(path));
        if (o == null) {
            this.setProperty(path, def);
            return def;
        }
        return o;
    }

    public int getInteger(String path, int def) {
        return this.getInt(path, def);
    }

    public List<Material> getMaterials(String key, String csvList) {
        List<String> defaultMatNames = csv.parseStrings(csvList);
        List<String> materialData = this.getStringList(key, defaultMatNames);
        ArrayList<String> matNames = new ArrayList<String>();
        ArrayList<Material> materials = new ArrayList<Material>();
        for (String matName : materialData) {
            Material material = ConfigurationNode.toMaterial(matName);
            materials.add(material);
            matNames.add(material.name().toLowerCase());
        }
        this.setProperty(key, matNames);
        return materials;
    }

    public List<Material> getMaterials(String key, Collection<Material> def) {
        ArrayList<String> defaultMatNames = new ArrayList<String>();
        for (Material mat : def) {
            defaultMatNames.add(mat.name().toLowerCase());
        }
        List<String> materialData = this.getStringList(key, defaultMatNames);
        ArrayList<String> matNames = new ArrayList<String>();
        ArrayList<Material> materials = new ArrayList<Material>();
        for (String matName : materialData) {
            Material material = ConfigurationNode.toMaterial(matName);
            materials.add(material);
            matNames.add(material.name().toLowerCase());
        }
        this.setProperty(key, matNames);
        return materials;
    }

    public double getDouble(String path, double def) {
        Double o = ConfigurationNode.castDouble(this.getProperty(path));
        if (o == null) {
            this.setProperty(path, def);
            return def;
        }
        return o;
    }

    public boolean getBoolean(String path, boolean def) {
        Boolean o = ConfigurationNode.castBoolean(this.getProperty(path));
        if (o == null) {
            this.setProperty(path, def);
            return def;
        }
        return o;
    }

    public List<String> getKeys(String path) {
        if (path == null) {
            return new ArrayList<String>(this.root.keySet());
        }
        Object o = this.getProperty(path);
        if (o == null) {
            return null;
        }
        if (o instanceof Map) {
            return new ArrayList<String>(((Map)o).keySet());
        }
        return null;
    }

    public List<String> getKeys() {
        return new ArrayList<String>(this.root.keySet());
    }

    public List<Object> getList(String path) {
        Object o = this.getProperty(path);
        if (o == null) {
            return null;
        }
        if (o instanceof List) {
            return (List)o;
        }
        if (o instanceof String) {
            List<String> strings = csv.parseStrings((String)o);
            ArrayList<Object> list = new ArrayList<Object>();
            list.addAll(strings);
            return list;
        }
        return null;
    }

    public List<String> getStringList(String path, List<String> def) {
        List<Object> raw = this.getList(path);
        if (raw == null) {
            if (def != null) {
                this.setProperty(path, def);
                return def;
            }
            return new ArrayList<String>();
        }
        ArrayList<String> list = new ArrayList<String>();
        for (Object o : raw) {
            if (o == null) continue;
            list.add(o.toString());
        }
        return list;
    }

    public List<Integer> getIntList(String path, List<Integer> def) {
        List<Object> raw = this.getList(path);
        if (raw == null) {
            return def != null ? def : new ArrayList();
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (Object o : raw) {
            Integer i = ConfigurationNode.castInt(o);
            if (i == null) continue;
            list.add(i);
        }
        return list;
    }

    public List<Double> getDoubleList(String path, List<Double> def) {
        List<Object> raw = this.getList(path);
        if (raw == null) {
            return def != null ? def : new ArrayList();
        }
        ArrayList<Double> list = new ArrayList<Double>();
        for (Object o : raw) {
            Double i = ConfigurationNode.castDouble(o);
            if (i == null) continue;
            list.add(i);
        }
        return list;
    }

    public List<Boolean> getBooleanList(String path, List<Boolean> def) {
        List<Object> raw = this.getList(path);
        if (raw == null) {
            return def != null ? def : new ArrayList();
        }
        ArrayList<Boolean> list = new ArrayList<Boolean>();
        for (Object o : raw) {
            Boolean tetsu = ConfigurationNode.castBoolean(o);
            if (tetsu == null) continue;
            list.add(tetsu);
        }
        return list;
    }

    public List<ConfigurationNode> getNodeList(String path, List<ConfigurationNode> def) {
        List<Object> raw = this.getList(path);
        if (raw == null) {
            return def != null ? def : new ArrayList();
        }
        ArrayList<ConfigurationNode> list = new ArrayList<ConfigurationNode>();
        for (Object o : raw) {
            if (!(o instanceof Map)) continue;
            list.add(new ConfigurationNode((Map)o));
        }
        return list;
    }

    public ConfigurationNode getNode(String path) {
        Object raw = this.getProperty(path);
        if (raw instanceof Map) {
            return new ConfigurationNode((Map)raw);
        }
        return null;
    }

    public boolean containsKey(String path) {
        Object test = this.getProperty(path);
        return test != null;
    }

    public ConfigurationNode getNode(String path, ConfigurationNode def) {
        Object raw = this.getProperty(path);
        if (raw instanceof Map) {
            return new ConfigurationNode((Map)raw);
        }
        this.setProperty(path, def.getAll());
        return def;
    }

    public Map<String, ConfigurationNode> getNodes(String path) {
        Object o = this.getProperty(path);
        if (o == null) {
            return null;
        }
        if (o instanceof Map) {
            HashMap<String, ConfigurationNode> nodes = new HashMap<String, ConfigurationNode>();
            for (Map.Entry entry : ((Map)o).entrySet()) {
                if (!(entry.getValue() instanceof Map)) continue;
                nodes.put((String)entry.getKey(), new ConfigurationNode((Map)entry.getValue()));
            }
            return nodes;
        }
        return null;
    }

    private static Integer castInt(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Byte) {
            return (int)((Byte)o);
        }
        if (o instanceof Integer) {
            return (Integer)o;
        }
        if (o instanceof Double) {
            return (int)((Double)o).doubleValue();
        }
        if (o instanceof Float) {
            return (int)((Float)o).floatValue();
        }
        if (o instanceof Long) {
            return (int)((Long)o).longValue();
        }
        if (o instanceof String) {
            try {
                return Integer.parseInt((String)o);
            }
            catch (NumberFormatException ex) {
                return null;
            }
        }
        return null;
    }

    private static Double castDouble(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Float) {
            return ((Float)o).floatValue();
        }
        if (o instanceof Double) {
            return (Double)o;
        }
        if (o instanceof Byte) {
            return (double)((Byte)o);
        }
        if (o instanceof Integer) {
            return (double)((Integer)o);
        }
        if (o instanceof Long) {
            return (double)((Long)o);
        }
        if (o instanceof String) {
            try {
                return Double.parseDouble((String)o);
            }
            catch (NumberFormatException ex) {
                return null;
            }
        }
        return null;
    }

    private static Boolean castBoolean(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        if (o instanceof String) {
            try {
                return Boolean.parseBoolean((String)o);
            }
            catch (NumberFormatException ex) {
                return null;
            }
        }
        return null;
    }

    public void removeProperty(String path) {
        if (!path.contains(".")) {
            this.root.remove(path);
            return;
        }
        String[] parts = path.split("\\.");
        Map node = this.root;
        int i = 0;
        while (i < parts.length) {
            Object o = node.get(parts[i]);
            if (i == parts.length - 1) {
                node.remove(parts[i]);
                return;
            }
            node = (Map)o;
            ++i;
        }
    }
}

