/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spells;

import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.plugins.magic.Target;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class GotoSpell
extends Spell {
    @Override
    public boolean onCast(ConfigurationNode parameters) {
        String playerName = parameters.getString("player");
        Player targetPlayer = null;
        if (playerName != null) {
            targetPlayer = this.spells.getPlugin().getServer().getPlayer(playerName);
        }
        this.targetEntity(Player.class);
        if (this.getYRotation() > 80.0) {
            Player destination = this.getFarthestPlayer(this.player);
            if (destination == null) {
                return false;
            }
            this.player.teleport((Entity)destination);
            this.castMessage(this.player, "Teleporting you to " + destination.getName());
            return true;
        }
        Target target = this.getTarget();
        Entity targetEntity = target.getEntity();
        if (targetEntity != null && targetEntity instanceof Player) {
            Player targetedPlayer = (Player)targetEntity;
            Player destination = this.getFarthestPlayer(targetedPlayer);
            if (destination == null) {
                return false;
            }
            targetedPlayer.teleport((Entity)destination);
            this.castMessage(this.player, "Teleporting " + targetedPlayer.getName() + " to " + destination.getName());
            return true;
        }
        Location destination = this.player.getLocation();
        if (target.isBlock()) {
            destination = target.getLocation();
            destination.setY(destination.getY() + 1.0);
        }
        if (targetPlayer == null) {
            targetPlayer = this.getFarthestPlayer(this.player);
        }
        if (targetPlayer == null) {
            return false;
        }
        targetPlayer.teleport(destination);
        this.castMessage(this.player, "Teleporting " + targetPlayer.getName() + " to your target");
        return true;
    }

    protected Player getFarthestPlayer(Player fromPlayer) {
        Player destinationPlayer = null;
        List players = fromPlayer.getLocation().getWorld().getPlayers();
        double targetToDestinationDistance = 0.0;
        for (Player d : players) {
            if (d == fromPlayer) continue;
            double dd = GotoSpell.getDistance(d.getLocation(), fromPlayer.getLocation());
            if (destinationPlayer != null && !(dd > targetToDestinationDistance)) continue;
            targetToDestinationDistance = dd;
            destinationPlayer = d;
        }
        return destinationPlayer;
    }
}

