/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic;

import com.elmakers.mine.bukkit.plugins.magic.CastingCost;
import com.elmakers.mine.bukkit.plugins.magic.PlayerSpells;
import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.utilities.InventoryUtils;
import com.elmakers.mine.bukkit.utilities.borrowed.Configuration;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import java.io.File;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class Wand {
    private ItemStack item;
    private String wandSettings;
    private String wandSpells;
    private String wandMaterials;
    private String activeSpell;
    private String activeMaterial;
    private String wandName;
    private float costReduction = 0.0f;
    private float damageReduction = 0.0f;
    private float damageReductionPhysical = 0.0f;
    private float damageReductionProjectiles = 0.0f;
    private float damageReductionFalling = 0.0f;
    private float damageReductionFire = 0.0f;
    private float damageReductionExplosions = 0.0f;
    private boolean hasInventory = true;
    private int uses = 0;
    private int xpRegeneration = 0;
    private int xpMax = 0;
    private int healthRegeneration = 0;
    private int hungerRegeneration = 0;
    private static DecimalFormat floatFormat = new DecimalFormat("#.###");
    private static Material WandMaterial = Material.STICK;
    public static Material EraseMaterial = Material.SULPHUR;
    protected static Map<String, ConfigurationNode> wandTemplates = new HashMap<String, ConfigurationNode>();
    private static final String propertiesFileName = "wands.yml";
    private static final String propertiesFileNameDefaults = "wands.defaults.yml";
    private static final String defaultWandName = "Wand";

    public Wand() {
        this.item = new ItemStack(WandMaterial);
        this.item = InventoryUtils.getCopy(this.item);
        ItemMeta itemMeta = this.item.getItemMeta();
        this.item.setItemMeta(itemMeta);
        InventoryUtils.addGlow(this.item);
        this.wandSettings = " ";
        this.wandSpells = "";
        this.wandMaterials = "";
        this.activeSpell = "";
        this.activeMaterial = "";
        this.wandName = defaultWandName;
        this.saveState();
    }

    public Wand(ItemStack item) {
        this.item = item;
        this.loadState();
    }

    public void setActiveSpell(PlayerSpells playerSpells, String activeSpell) {
        this.activeSpell = activeSpell;
        this.updateName(playerSpells);
        this.saveState();
    }

    public void setActiveMaterial(PlayerSpells playerSpells, Material material, byte data) {
        this.activeMaterial = String.valueOf(material.getId()) + ":" + data;
        this.updateName(playerSpells);
        if (Wand.hasActiveWand(playerSpells.getPlayer())) {
            this.updateActiveMaterial(playerSpells);
        }
        this.saveState();
    }

    public int getXpRegeneration() {
        return this.xpRegeneration;
    }

    public void setXPRegeneration(int xpRegeneration) {
        this.xpRegeneration = xpRegeneration;
        this.updateWandSettings();
    }

    public int getXPMax() {
        return this.xpMax;
    }

    public void setXPMax(int xpMax) {
        this.xpMax = xpMax;
        this.updateWandSettings();
    }

    public int getHealthRegeneration() {
        return this.healthRegeneration;
    }

    public void setHealthRegeneration(int healthRegeneration) {
        this.healthRegeneration = healthRegeneration;
        this.updateWandSettings();
    }

    public int getHungerRegeneration() {
        return this.hungerRegeneration;
    }

    public void setHungerRegeneration(int hungerRegeneration) {
        this.hungerRegeneration = hungerRegeneration;
        this.updateWandSettings();
    }

    public float getCostReduction() {
        return this.costReduction;
    }

    public boolean getHasInventory() {
        return this.hasInventory;
    }

    public void setHasInventory(boolean hasInventory) {
        this.hasInventory = hasInventory;
        this.updateWandSettings();
    }

    public void setCostReduction(float costReduction) {
        this.costReduction = costReduction;
        this.updateWandSettings();
    }

    public float getDamageReduction() {
        return this.damageReduction;
    }

    public void setDamageReduction(float damageReduction) {
        this.damageReduction = damageReduction;
        this.updateWandSettings();
    }

    public float getDamageReductionPhysical() {
        return this.damageReductionPhysical;
    }

    public void setDamageReductionPhysical(float damageReductionPhysical) {
        this.damageReductionPhysical = damageReductionPhysical;
        this.updateWandSettings();
    }

    public float getDamageReductionProjectiles() {
        return this.damageReductionProjectiles;
    }

    public void setDamageReductionProjectiles(float damageReductionProjectiles) {
        this.damageReductionProjectiles = damageReductionProjectiles;
        this.updateWandSettings();
    }

    public float getDamageReductionFalling() {
        return this.damageReductionFalling;
    }

    public void setDamageReductionFalling(float damageReductionFalling) {
        this.damageReductionFalling = damageReductionFalling;
        this.updateWandSettings();
    }

    public float getDamageReductionFire() {
        return this.damageReductionFire;
    }

    public void setDamageReductionFire(float damageReductionFire) {
        this.damageReductionFire = damageReductionFire;
        this.updateWandSettings();
    }

    public float getDamageReductionExplosions() {
        return this.damageReductionExplosions;
    }

    public void setDamageReductionExplosions(float damageReductionExplosions) {
        this.damageReductionExplosions = damageReductionExplosions;
        this.updateWandSettings();
    }

    public int getUses() {
        return this.uses;
    }

    public void setUses(int uses) {
        this.uses = uses;
        this.updateWandSettings();
    }

    public String getName() {
        return this.wandName;
    }

    protected void setName(String name) {
        this.wandName = name;
    }

    public ItemStack getItem() {
        return this.item;
    }

    protected void saveState() {
        this.updateWandSettings();
        InventoryUtils.setMeta(this.item, "magic_wand", this.wandSettings);
        InventoryUtils.setMeta(this.item, "magic_materials", this.wandMaterials);
        InventoryUtils.setMeta(this.item, "magic_spells", this.wandSpells);
        InventoryUtils.setMeta(this.item, "magic_active_spell", this.activeSpell);
        InventoryUtils.setMeta(this.item, "magic_active_material", this.activeMaterial);
        InventoryUtils.setMeta(this.item, "magic_wand_name", this.wandName);
    }

    protected void updateWandSettings() {
        this.wandSettings = "cr=" + floatFormat.format(this.costReduction) + "&dr=" + floatFormat.format(this.damageReduction) + "&drph=" + floatFormat.format(this.damageReductionPhysical) + "&drpr=" + floatFormat.format(this.damageReductionProjectiles) + "&drfa=" + floatFormat.format(this.damageReductionFalling) + "&drfi=" + floatFormat.format(this.damageReductionFire) + "&drex=" + floatFormat.format(this.damageReductionExplosions) + "&drex=" + floatFormat.format(this.damageReductionExplosions) + "&xpre=" + this.xpRegeneration + "&xpmax=" + this.xpMax + "&hereg=" + this.healthRegeneration + "&hureg=" + this.hungerRegeneration + "&uses=" + this.uses + "&hasi=" + (this.hasInventory ? 1 : 0);
    }

    protected void loadState() {
        String[] wandPairs;
        this.wandSettings = InventoryUtils.getMeta(this.item, "magic_wand");
        this.wandSettings = this.wandSettings == null ? "" : this.wandSettings;
        this.wandMaterials = InventoryUtils.getMeta(this.item, "magic_materials");
        this.wandMaterials = this.wandMaterials == null ? "" : this.wandMaterials;
        this.wandSpells = InventoryUtils.getMeta(this.item, "magic_spells");
        this.wandSpells = this.wandSpells == null ? "" : this.wandSpells;
        this.activeSpell = InventoryUtils.getMeta(this.item, "magic_active_spell");
        this.activeSpell = this.activeSpell == null ? "" : this.activeSpell;
        this.activeMaterial = InventoryUtils.getMeta(this.item, "magic_active_material");
        this.activeMaterial = this.activeMaterial == null ? "" : this.activeMaterial;
        this.wandName = InventoryUtils.getMeta(this.item, "magic_wand_name");
        this.wandName = this.wandName == null ? defaultWandName : this.wandName;
        String[] stringArray = wandPairs = StringUtils.split((String)this.wandSettings, (String)"&");
        int n = wandPairs.length;
        int n2 = 0;
        while (n2 < n) {
            String pair = stringArray[n2];
            String[] keyValue = StringUtils.split((String)pair, (String)"=");
            if (keyValue.length == 2) {
                String key = keyValue[0];
                float value = Float.parseFloat(keyValue[1]);
                if (key.equalsIgnoreCase("cr")) {
                    this.costReduction = value;
                } else if (key.equalsIgnoreCase("dr")) {
                    this.damageReduction = value;
                } else if (key.equalsIgnoreCase("drph")) {
                    this.damageReductionPhysical = value;
                } else if (key.equalsIgnoreCase("drpr")) {
                    this.damageReductionProjectiles = value;
                } else if (key.equalsIgnoreCase("drfa")) {
                    this.damageReductionFalling = value;
                } else if (key.equalsIgnoreCase("drfi")) {
                    this.damageReductionFire = value;
                } else if (key.equalsIgnoreCase("drex")) {
                    this.damageReductionExplosions = value;
                } else if (key.equalsIgnoreCase("uses")) {
                    this.uses = (int)value;
                } else if (key.equalsIgnoreCase("xpre")) {
                    this.xpRegeneration = (int)value;
                } else if (key.equalsIgnoreCase("xpmax")) {
                    this.xpMax = (int)value;
                } else if (key.equalsIgnoreCase("hereg")) {
                    this.healthRegeneration = (int)value;
                } else if (key.equalsIgnoreCase("hureg")) {
                    this.hungerRegeneration = (int)value;
                } else if (key.equalsIgnoreCase("hasi")) {
                    this.hasInventory = (int)value != 0;
                }
            }
            ++n2;
        }
    }

    public void removeMaterial(Material material, byte data) {
        Integer id = material.getId();
        String materialString = id.toString();
        materialString = String.valueOf(materialString) + ":" + data;
        String[] materials = this.getMaterials();
        LinkedList<String> materialMap = new LinkedList<String>();
        int i = 0;
        while (i < materials.length) {
            String[] pieces = StringUtils.split((String)materials[i], (String)"@");
            if (pieces.length > 0 && !pieces[0].equals(materialString)) {
                materialMap.add(materials[i]);
            }
            ++i;
        }
        this.setMaterials(materialMap);
        if (materialString.equalsIgnoreCase(this.activeMaterial)) {
            this.activeMaterial = "";
        }
    }

    public void addMaterial(Material material, int data) {
        this.addMaterial(material, (byte)data);
    }

    public void addMaterial(Material material) {
        this.addMaterial(material, 0);
    }

    public void addMaterial(Material material, byte data) {
        Integer id = material.getId();
        String materialString = id.toString();
        materialString = String.valueOf(materialString) + ":" + data;
        String[] materials = this.getMaterials();
        LinkedList<String> materialMap = new LinkedList<String>();
        int i = 0;
        while (i < materials.length) {
            String[] pieces = StringUtils.split((String)materials[i], (String)"@");
            if (pieces.length > 0 && !pieces[0].equals(materialString)) {
                materialMap.add(materials[i]);
            }
            ++i;
        }
        if (this.activeMaterial.length() == 0) {
            this.activeMaterial = materialString;
        }
        materialMap.add(materialString);
        this.setMaterials(materialMap);
    }

    protected void setMaterials(Collection<String> materialNames) {
        this.wandMaterials = StringUtils.join(materialNames, (String)"|");
        this.setMaterialCount(materialNames.size());
        String[] spellNames = this.getSpells();
        this.hasInventory = spellNames.length + materialNames.size() > 1;
        this.saveState();
    }

    public String[] getMaterials() {
        return StringUtils.split((String)this.wandMaterials, (String)"|");
    }

    public void addSpells(Collection<String> spellNames) {
        String[] spells = this.getSpells();
        LinkedList<String> spellMap = new LinkedList<String>();
        String[] stringArray = spells;
        int n = spells.length;
        int n2 = 0;
        while (n2 < n) {
            String spell = stringArray[n2];
            spellMap.add(spell);
            String[] pieces = StringUtils.split((String)spell, (String)"@");
            if (pieces.length > 0) {
                spellNames.remove(pieces[0]);
            }
            ++n2;
        }
        for (String spellName : spellNames) {
            if (this.activeSpell.length() == 0) {
                this.activeSpell = spellName;
            }
            spellMap.add(spellName);
        }
        this.setSpells(spellMap);
    }

    public String[] getSpells() {
        return StringUtils.split((String)this.wandSpells, (String)"|");
    }

    public void removeSpell(String spellName) {
        String[] spells = this.getSpells();
        LinkedList<String> spellMap = new LinkedList<String>();
        int i = 0;
        while (i < spells.length) {
            String[] pieces = StringUtils.split((String)spells[i], (String)"@");
            if (pieces.length > 0 && !pieces[0].equals(spellName)) {
                spellMap.add(spells[i]);
            }
            ++i;
        }
        this.setSpells(spellMap);
        if (spellName.equalsIgnoreCase(this.activeSpell)) {
            this.activeSpell = "";
        }
    }

    public void addSpell(String spellName) {
        ArrayList<String> names = new ArrayList<String>();
        names.add(spellName);
        this.addSpells(names);
    }

    public void setSpells(Collection<String> spellNames) {
        this.wandSpells = StringUtils.join(spellNames, (String)"|");
        this.setSpellCount(spellNames.size());
        String[] materials = this.getMaterials();
        this.hasInventory = spellNames.size() + materials.length > 1;
        this.saveState();
    }

    public void setSpellCount(int spellCount) {
        this.updateLore(spellCount, this.getMaterials().length);
    }

    public void setMaterialCount(int materialCount) {
        this.updateLore(this.getSpells().length, materialCount);
    }

    public void setName(String name, PlayerSpells playerSpells) {
        this.setName(name);
        this.updateName(playerSpells);
    }

    protected void updateName(PlayerSpells playerSpells) {
        int remaining;
        Spell spell;
        String name = this.wandName;
        if (this.hasInventory && (spell = playerSpells.getSpell(this.activeSpell)) != null) {
            String[] pieces = StringUtils.split((String)this.activeMaterial, (String)":");
            Material material = null;
            if (pieces.length > 0 && pieces[0].length() > 0) {
                material = Material.getMaterial((int)Integer.parseInt(pieces[0]));
            }
            if (material != null && spell.usesMaterial()) {
                String materialName = material == EraseMaterial ? "erase" : material.name().toLowerCase();
                name = ChatColor.GOLD + spell.getName() + ChatColor.GRAY + " " + materialName + ChatColor.WHITE + " (" + this.wandName + ")";
            } else {
                name = ChatColor.GOLD + spell.getName() + ChatColor.WHITE + " (" + this.wandName + ")";
            }
        }
        if ((remaining = this.getRemainingUses()) > 0) {
            name = String.valueOf(name) + " : " + ChatColor.RED + remaining + " Uses ";
        }
        ItemMeta meta = this.item.getItemMeta();
        meta.setDisplayName(name);
        this.item.setItemMeta(meta);
        InventoryUtils.addGlow(this.item);
        this.saveState();
    }

    protected String getLevelString(String prefix, float amount) {
        String suffix = "I";
        if (amount >= 1.0f) {
            suffix = "X";
        } else if ((double)amount > 0.8) {
            suffix = "V";
        } else if ((double)amount > 0.6) {
            suffix = "IV";
        } else if ((double)amount > 0.4) {
            suffix = "III";
        } else if ((double)amount > 0.2) {
            suffix = "II";
        }
        return String.valueOf(prefix) + " " + suffix;
    }

    protected void updateLore(int spellCount, int materialCount) {
        int remaining;
        ItemMeta meta = this.item.getItemMeta();
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("Knows " + spellCount + " Spells");
        if (materialCount > 0) {
            lore.add("Has " + materialCount + " Materials");
        }
        if ((remaining = this.getRemainingUses()) > 0) {
            lore.add(ChatColor.RED + remaining + " Uses Remaining");
        }
        if (this.costReduction > 0.0f) {
            lore.add(ChatColor.GOLD + this.getLevelString("Cost Reduction", this.costReduction));
        }
        if (this.damageReduction > 0.0f) {
            lore.add(ChatColor.GOLD + this.getLevelString("Protection", this.damageReduction));
        }
        if (this.damageReductionPhysical > 0.0f) {
            lore.add(ChatColor.GOLD + this.getLevelString("Physical Protection", this.damageReductionPhysical));
        }
        if (this.damageReductionProjectiles > 0.0f) {
            lore.add(ChatColor.GOLD + this.getLevelString("Projectile Protection", this.damageReductionProjectiles));
        }
        if (this.damageReductionFalling > 0.0f) {
            lore.add(ChatColor.GOLD + this.getLevelString("Fall Protection", this.damageReductionFalling));
        }
        if (this.damageReductionFire > 0.0f) {
            lore.add(ChatColor.GOLD + this.getLevelString("Fire Protection", this.damageReductionFire));
        }
        if (this.damageReductionExplosions > 0.0f) {
            lore.add(ChatColor.GOLD + this.getLevelString("Blast Protection", this.damageReductionExplosions));
        }
        if (this.xpRegeneration > 0) {
            lore.add(ChatColor.GOLD + this.getLevelString("XP Protection", this.xpRegeneration / 100));
        }
        if (this.healthRegeneration > 0) {
            lore.add(ChatColor.GOLD + "Health Regeneration");
        }
        if (this.hungerRegeneration > 0) {
            lore.add(ChatColor.GOLD + "No Hunger");
        }
        meta.setLore(lore);
        this.item.setItemMeta(meta);
        InventoryUtils.addGlow(this.item);
        this.saveState();
    }

    public int getRemainingUses() {
        int remaining = 0;
        if (this.uses > 0) {
            short durability = this.item.getDurability();
            remaining = Math.max(0, this.uses - durability);
        }
        return remaining;
    }

    public static Wand getActiveWand(Player player) {
        ItemStack activeItem = player.getInventory().getItemInHand();
        return Wand.isWand(activeItem) ? new Wand(activeItem) : null;
    }

    public static boolean hasActiveWand(Player player) {
        ItemStack activeItem = player.getInventory().getItemInHand();
        return Wand.isWand(activeItem);
    }

    public static boolean isWand(ItemStack item) {
        return item != null && item.getType() == Material.STICK && InventoryUtils.getMeta(item, "magic_wand", "").length() > 0;
    }

    public static boolean isSpell(ItemStack item) {
        return item != null && item.getType() != Material.STICK && InventoryUtils.getMeta(item, "magic_spell", "").length() > 0;
    }

    /*
     * WARNING - void declaration
     */
    protected void updateInventory(PlayerSpells playerSpells, int itemSlot) {
        void var11_15;
        Player player = playerSpells.getPlayer();
        PlayerInventory inventory = player.getInventory();
        inventory.clear();
        inventory.setItem(itemSlot, this.item);
        String[] spells = StringUtils.split((String)this.wandSpells, (String)"|");
        LinkedList<ItemStack> unpositionedSpells = new LinkedList<ItemStack>();
        int i = 0;
        while (i < spells.length) {
            String[] parts = StringUtils.split((String)spells[i], (String)"@");
            String spellName = parts[0];
            Spell spell = playerSpells.getSpell(spellName);
            if (spell != null) {
                int slot;
                ItemStack itemStack2 = new ItemStack(spell.getMaterial(), 1);
                itemStack2 = InventoryUtils.getCopy(itemStack2);
                ItemMeta meta = itemStack2.getItemMeta();
                meta.setDisplayName(spell.getName());
                ArrayList<String> lore = new ArrayList<String>();
                lore.add(spell.getCategory());
                lore.add(spell.getDescription());
                List<CastingCost> costs = spell.getCosts();
                if (costs != null) {
                    for (CastingCost cost : costs) {
                        if (!cost.hasCosts(playerSpells)) continue;
                        lore.add(ChatColor.YELLOW + "Costs " + cost.getFullDescription(playerSpells));
                    }
                }
                meta.setLore(lore);
                itemStack2.setItemMeta(meta);
                InventoryUtils.addGlow(itemStack2);
                InventoryUtils.setMeta(itemStack2, "magic_spell", spells[i]);
                int n = slot = parts.length > 1 ? Integer.parseInt(parts[1]) : itemSlot;
                if (parts.length > 1 && slot != itemSlot) {
                    inventory.setItem(slot, itemStack2);
                } else {
                    unpositionedSpells.add(itemStack2);
                }
            }
            ++i;
        }
        String[] materials = StringUtils.split((String)this.wandMaterials, (String)"|");
        LinkedList<ItemStack> unpositionedMaterials = new LinkedList<ItemStack>();
        HashMap<Integer, ItemStack> positioned = new HashMap<Integer, ItemStack>();
        ItemStack eraseStack = null;
        boolean bl = false;
        while (var11_15 < materials.length) {
            ArrayList<String> lore;
            String[] parts = StringUtils.split((String)materials[var11_15], (String)"@");
            String[] nameParts = StringUtils.split((String)parts[0], (String)":");
            int typeId = Integer.parseInt(nameParts[0]);
            if (typeId == 0) {
                typeId = EraseMaterial.getId();
            }
            int dataId = nameParts.length > 1 ? Integer.parseInt(nameParts[1]) : 0;
            ItemStack itemStack = new ItemStack(typeId, 1, 0, Byte.valueOf((byte)dataId));
            itemStack = InventoryUtils.getCopy(itemStack);
            ItemMeta meta = itemStack.getItemMeta();
            if (typeId == EraseMaterial.getId()) {
                meta.setDisplayName("Erase");
                lore = new ArrayList();
                lore.add("Fills with Air");
                meta.setLore(lore);
            } else {
                lore = new ArrayList<String>();
                lore.add("Magic building material");
                meta.setLore(lore);
            }
            itemStack.setItemMeta(meta);
            int slot = parts.length > 1 ? Integer.parseInt(parts[1]) : itemSlot;
            ItemStack existing = inventory.getItem(slot);
            if (parts.length > 1 && slot != itemSlot && (existing == null || existing.getType() == Material.AIR)) {
                positioned.put(slot, itemStack);
            } else if (itemStack.getType() == EraseMaterial) {
                eraseStack = itemStack;
            } else {
                unpositionedMaterials.add(itemStack);
            }
            ++var11_15;
        }
        if (unpositionedMaterials.size() > 0) {
            int n = Math.min(unpositionedMaterials.size(), 3);
            int remainingSpaces = 8 - n;
            while (unpositionedSpells.size() > 0 && remainingSpaces > 0) {
                inventory.addItem(new ItemStack[]{(ItemStack)unpositionedSpells.remove()});
                --remainingSpaces;
            }
        }
        if (eraseStack != null) {
            Wand.addMaterialToInventory((Inventory)inventory, eraseStack);
        }
        for (ItemStack itemStack : unpositionedMaterials) {
            Wand.addMaterialToInventory((Inventory)inventory, itemStack);
        }
        for (ItemStack itemStack : unpositionedSpells) {
            inventory.addItem(new ItemStack[]{itemStack});
        }
        for (Map.Entry entry : positioned.entrySet()) {
            int slot = (Integer)entry.getKey();
            ItemStack itemStack = (ItemStack)entry.getValue();
            ItemStack existing = inventory.getItem(slot);
            if (slot != itemSlot && (existing == null || existing.getType() == Material.AIR)) {
                inventory.setItem(slot, itemStack);
                continue;
            }
            Wand.addMaterialToInventory((Inventory)inventory, itemStack);
        }
        this.updateName(playerSpells);
        player.updateInventory();
    }

    protected static void addMaterialToInventory(Inventory inventory, ItemStack stack) {
        int i = 8;
        while (i >= 0) {
            ItemStack existing = inventory.getItem(i);
            if (existing == null || existing.getType() == Material.AIR) {
                inventory.setItem(i, stack);
                return;
            }
            --i;
        }
        inventory.addItem(new ItemStack[]{stack});
    }

    protected void saveInventory(PlayerSpells playerSpells) {
        Integer position;
        String[] pieces;
        PlayerInventory inventory = playerSpells.getPlayer().getInventory();
        String[] currentSpells = this.getSpells();
        String[] currentMaterials = this.getMaterials();
        HashMap<String, Integer> spellMap = new HashMap<String, Integer>();
        HashMap<String, Integer> materialMap = new HashMap<String, Integer>();
        String[] stringArray = currentSpells;
        int n = currentSpells.length;
        int n2 = 0;
        while (n2 < n) {
            String spell = stringArray[n2];
            pieces = StringUtils.split((String)spell, (String)"@");
            position = pieces.length > 1 ? Integer.valueOf(Integer.parseInt(pieces[1])) : null;
            spellMap.put(pieces[0], position);
            ++n2;
        }
        stringArray = currentMaterials;
        n = currentMaterials.length;
        n2 = 0;
        while (n2 < n) {
            String material = stringArray[n2];
            pieces = StringUtils.split((String)material, (String)"@");
            position = pieces.length > 1 ? Integer.valueOf(Integer.parseInt(pieces[1])) : null;
            materialMap.put(pieces[0], position);
            ++n2;
        }
        ItemStack[] items = inventory.getContents();
        int i = 0;
        while (i < items.length) {
            if (items[i] != null) {
                Material material = items[i].getType();
                if (Wand.isSpell(items[i])) {
                    Spell spell = playerSpells.getSpell(material);
                    if (spell != null && spellMap.containsKey(spell.getKey())) {
                        spellMap.put(spell.getKey(), i);
                    }
                } else {
                    List<Material> buildingMaterials = playerSpells.getMaster().getBuildingMaterials();
                    if (material != Material.AIR && (buildingMaterials.contains(material) || material == EraseMaterial)) {
                        String materialKey;
                        String string = materialKey = material == EraseMaterial ? "0:0" : String.valueOf(material.getId()) + ":" + items[i].getData().getData();
                        if (materialMap.containsKey(materialKey)) {
                            materialMap.put(materialKey, i);
                        }
                    }
                }
            }
            ++i;
        }
        ArrayList<String> spellNames = new ArrayList<String>();
        ArrayList<String> materialNames = new ArrayList<String>();
        for (Map.Entry spellEntry : spellMap.entrySet()) {
            position = (Integer)spellEntry.getValue();
            String spellName = (String)spellEntry.getKey();
            if (position != null) {
                spellName = String.valueOf(spellName) + "@" + position;
            }
            spellNames.add(spellName);
        }
        for (Map.Entry materialEntry : materialMap.entrySet()) {
            position = (Integer)materialEntry.getValue();
            String materialName = (String)materialEntry.getKey();
            if (position != null) {
                materialName = String.valueOf(materialName) + "@" + position;
            }
            materialNames.add(materialName);
        }
        this.setSpells(spellNames);
        this.setMaterials(materialNames);
        this.saveState();
    }

    public static boolean isActive(Player player) {
        ItemStack activeItem = player.getInventory().getItemInHand();
        return Wand.isWand(activeItem);
    }

    public static Wand createWand(PlayerSpells playerSpells, String templateName) {
        Wand wand = new Wand();
        ArrayList<String> defaultSpells = new ArrayList<String>();
        String wandName = defaultWandName;
        if (wandTemplates.containsKey(templateName)) {
            List<Object> materialList;
            ConfigurationNode wandConfig = wandTemplates.get(templateName);
            wandName = wandConfig.getString("name", wandName);
            List<Object> spellList = wandConfig.getList("spells");
            if (spellList != null) {
                for (Object spellName : spellList) {
                    defaultSpells.add((String)spellName);
                }
            }
            if ((materialList = wandConfig.getList("materials")) != null) {
                for (Object materialNameAndData : materialList) {
                    String[] materialParts = StringUtils.split((String)((String)materialNameAndData), (char)':');
                    String materialName = materialParts[0];
                    byte data = 0;
                    if (materialParts.length > 1) {
                        data = Byte.parseByte(materialParts[1]);
                    }
                    if (materialName.equals("erase")) {
                        wand.addMaterial(EraseMaterial, data);
                        continue;
                    }
                    wand.addMaterial(ConfigurationNode.toMaterial(materialName), data);
                }
            }
            wand.setCostReduction((float)wandConfig.getDouble("cost_reduction", 0.0));
            wand.setDamageReduction((float)wandConfig.getDouble("damage_reduction", 0.0));
            wand.setDamageReductionPhysical((float)wandConfig.getDouble("damage_reduction_physical", 0.0));
            wand.setDamageReductionProjectiles((float)wandConfig.getDouble("damage_reduction_projectiles", 0.0));
            wand.setDamageReductionFalling((float)wandConfig.getDouble("damage_reduction_falling", 0.0));
            wand.setDamageReductionFire((float)wandConfig.getDouble("damage_reduction_fire", 0.0));
            wand.setDamageReductionExplosions((float)wandConfig.getDouble("damage_reduction_explosions", 0.0));
            wand.setXPRegeneration(wandConfig.getInt("xp_regeneration", 0));
            wand.setXPMax(wandConfig.getInt("xp_max", 0));
            wand.setHealthRegeneration(wandConfig.getInt("health_regeneration", 0));
            wand.setHungerRegeneration(wandConfig.getInt("hunger_regeneration", 0));
            wand.setUses(wandConfig.getInt("uses", 0));
        }
        wand.addSpells(defaultSpells);
        wand.setName(wandName, playerSpells);
        return wand;
    }

    public static void reset(Plugin plugin) {
        File dataFolder = plugin.getDataFolder();
        File propertiesFile = new File(dataFolder, propertiesFileName);
        propertiesFile.delete();
    }

    public static void load(Plugin plugin) {
        File dataFolder = plugin.getDataFolder();
        File propertiesFile = new File(dataFolder, propertiesFileName);
        if (!propertiesFile.exists()) {
            File oldDefaults = new File(dataFolder, propertiesFileNameDefaults);
            oldDefaults.delete();
            plugin.saveResource(propertiesFileNameDefaults, false);
            Wand.loadProperties(plugin.getResource(propertiesFileNameDefaults));
        } else {
            Wand.loadProperties(propertiesFile);
        }
    }

    protected static void loadProperties(File propertiesFile) {
        Wand.loadProperties(new Configuration(propertiesFile));
    }

    protected static void loadProperties(InputStream properties) {
        Wand.loadProperties(new Configuration(properties));
    }

    protected static void loadProperties(Configuration properties) {
        properties.load();
        wandTemplates.clear();
        ConfigurationNode wandList = properties.getNode("wands");
        if (wandList == null) {
            return;
        }
        List<String> wandKeys = wandList.getKeys();
        for (String key : wandKeys) {
            ConfigurationNode wandNode = wandList.getNode(key);
            wandNode.setProperty("key", key);
            wandTemplates.put(key, wandNode);
        }
    }

    public static Collection<ConfigurationNode> getWandTemplates() {
        return wandTemplates.values();
    }

    protected void updateSpellSettings(PlayerSpells spells) {
        this.updateSpellSettings(spells, false);
    }

    protected void updateSpellSettings(PlayerSpells spells, boolean clearValue) {
        spells.setDamageReduction(clearValue ? 0.0f : this.damageReduction);
        spells.setDamageReductionPhysical(clearValue ? 0.0f : this.damageReductionPhysical);
        spells.setDamageReductionProjectiles(clearValue ? 0.0f : this.damageReductionProjectiles);
        spells.setDamageReductionFalling(clearValue ? 0.0f : this.damageReductionFalling);
        spells.setDamageReductionFire(clearValue ? 0.0f : this.damageReductionFire);
        spells.setDamageReductionExplosions(clearValue ? 0.0f : this.damageReductionExplosions);
        spells.setCostReduction(clearValue ? 0.0f : this.costReduction);
        spells.setXPRegeneration(clearValue ? 0 : this.xpRegeneration);
        spells.setXPMax(clearValue ? 0 : this.xpMax);
        spells.setHealthRegeneration(clearValue ? 0 : this.healthRegeneration);
        spells.setHungerRegeneration(clearValue ? 0 : this.hungerRegeneration);
    }

    protected void updateActiveMaterial(PlayerSpells playerSpells) {
        if (this.activeMaterial == null) {
            playerSpells.clearBuildingMaterial();
        } else {
            String[] pieces = StringUtils.split((String)this.activeMaterial, (String)":");
            if (pieces.length > 0) {
                byte data = 0;
                if (pieces.length > 1) {
                    data = Byte.parseByte(pieces[1]);
                }
                Material material = Material.getMaterial((int)Integer.parseInt(pieces[0]));
                playerSpells.setBuildingMaterial(material, data);
            }
        }
    }

    private void openInventory(PlayerSpells playerSpells, int itemSlot) {
        if (playerSpells.storeInventory(itemSlot, this.item)) {
            this.updateInventory(playerSpells, itemSlot);
            playerSpells.getPlayer().updateInventory();
        }
    }

    public void openInventory(PlayerSpells playerSpells) {
        this.openInventory(playerSpells, playerSpells.getPlayer().getInventory().getHeldItemSlot());
    }

    private void closeInventory(PlayerSpells playerSpells, int itemSlot) {
        this.saveInventory(playerSpells);
        playerSpells.restoreInventory(itemSlot, this.item);
        playerSpells.getPlayer().updateInventory();
    }

    public void closeInventory(PlayerSpells playerSpells) {
        this.closeInventory(playerSpells, playerSpells.getPlayer().getInventory().getHeldItemSlot());
    }

    public void activate(PlayerSpells playerSpells) {
        this.updateSpellSettings(playerSpells);
        this.updateActiveMaterial(playerSpells);
    }

    public boolean isInventoryOpen(PlayerSpells playerSpells) {
        return playerSpells.hasStoredInventory();
    }

    public void deactivate(PlayerSpells playerSpells) {
        this.deactivate(playerSpells, playerSpells.getPlayer().getInventory().getHeldItemSlot());
    }

    public void deactivate(PlayerSpells playerSpells, int itemSlot) {
        if (this.isInventoryOpen(playerSpells)) {
            this.closeInventory(playerSpells, itemSlot);
        }
        this.updateSpellSettings(playerSpells, true);
    }

    public boolean cast(PlayerSpells playerSpells) {
        Spell spell = playerSpells.getSpell(this.activeSpell);
        if (spell != null && spell.cast()) {
            this.use(playerSpells);
            return true;
        }
        return false;
    }

    protected void use(PlayerSpells playerSpells) {
        if (this.uses > 0) {
            short durability = this.item.getDurability();
            if (durability >= this.uses - 1) {
                this.deactivate(playerSpells);
                PlayerInventory playerInventory = playerSpells.getPlayer().getInventory();
                playerInventory.setItemInHand(new ItemStack(Material.AIR, 1));
                playerSpells.getPlayer().updateInventory();
            } else {
                this.item.setDurability((short)(durability + 1));
                this.updateName(playerSpells);
                this.updateLore(this.getSpells().length, this.getMaterials().length);
            }
        }
    }
}

