/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic;

import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.plugins.magic.SpellEventType;
import com.elmakers.mine.bukkit.plugins.magic.Spells;
import com.elmakers.mine.bukkit.plugins.magic.Wand;
import com.elmakers.mine.bukkit.utilities.InventoryUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public class PlayerSpells {
    protected Player player;
    protected Spells master;
    protected HashMap<String, Spell> spells = new HashMap();
    private Inventory storedInventory = null;
    private Wand activeWand = null;
    private final List<Spell> movementListeners = new ArrayList<Spell>();
    private final List<Spell> quitListeners = new ArrayList<Spell>();
    private final List<Spell> deathListeners = new ArrayList<Spell>();
    private final List<Spell> damageListeners = new ArrayList<Spell>();
    private float costReduction = 0.0f;
    private float damageReduction = 0.0f;
    private float damageReductionPhysical = 0.0f;
    private float damageReductionProjectiles = 0.0f;
    private float damageReductionFalling = 0.0f;
    private float damageReductionFire = 0.0f;
    private float damageReductionExplosions = 0.0f;
    private int xpRegeneration = 0;
    private int xpMax = 0;
    private int healthRegeneration = 0;
    private int hungerRegeneration = 0;
    private ItemStack buildingMaterial = null;

    public int getXpRegeneration() {
        return this.xpRegeneration;
    }

    public void setXPRegeneration(int xpRegeneration) {
        this.xpRegeneration = xpRegeneration;
    }

    public int getXPMax() {
        return this.xpMax;
    }

    public void setXPMax(int xpMax) {
        this.xpMax = xpMax;
    }

    public int getHealthRegeneration() {
        return this.healthRegeneration;
    }

    public void setHealthRegeneration(int healthRegeneration) {
        this.healthRegeneration = healthRegeneration;
    }

    public int getHungerRegeneration() {
        return this.hungerRegeneration;
    }

    public void setHungerRegeneration(int hungerRegeneration) {
        this.hungerRegeneration = hungerRegeneration;
    }

    public float getDamageReductionPhysical() {
        return this.damageReductionPhysical;
    }

    public void setDamageReductionPhysical(float damageReductionPhysical) {
        this.damageReductionPhysical = damageReductionPhysical;
    }

    public float getCostReduction() {
        return this.costReduction;
    }

    public void setCostReduction(float costReduction) {
        this.costReduction = costReduction;
    }

    public float getDamageReduction() {
        return this.damageReduction;
    }

    public void setDamageReduction(float damageReduction) {
        this.damageReduction = damageReduction;
    }

    public float getDamageReductionProjectiles() {
        return this.damageReductionProjectiles;
    }

    public void setDamageReductionProjectiles(float damageReductionProjectiles) {
        this.damageReductionProjectiles = damageReductionProjectiles;
    }

    public float getDamageReductionFalling() {
        return this.damageReductionFalling;
    }

    public void setDamageReductionFalling(float damageReductionFalling) {
        this.damageReductionFalling = damageReductionFalling;
    }

    public float getDamageReductionFire() {
        return this.damageReductionFire;
    }

    public void setDamageReductionFire(float damageReductionFire) {
        this.damageReductionFire = damageReductionFire;
    }

    public float getDamageReductionExplosions() {
        return this.damageReductionExplosions;
    }

    public void setDamageReductionExplosions(float damageReductionExplosions) {
        this.damageReductionExplosions = damageReductionExplosions;
    }

    public boolean hasStoredInventory() {
        return this.storedInventory != null;
    }

    public Inventory getStoredInventory() {
        return this.storedInventory;
    }

    public boolean addToStoredInventory(ItemStack item) {
        if (this.storedInventory == null) {
            return false;
        }
        HashMap remainder = this.storedInventory.addItem(new ItemStack[]{item});
        for (ItemStack remains : remainder.values()) {
            this.player.getWorld().dropItemNaturally(this.player.getLocation(), remains);
        }
        return true;
    }

    public boolean storeInventory(int keepSlot, ItemStack keepItem) {
        PlayerInventory inventory = this.player.getInventory();
        if (this.storedInventory != null) {
            return false;
        }
        if (keepItem != null) {
            inventory.clear(keepSlot);
        }
        this.storedInventory = InventoryUtils.createInventory(null, inventory.getSize(), "Magic.Wand.StoredInventory");
        ItemStack[] contents = inventory.getContents();
        int i = 0;
        while (i < contents.length) {
            if (Wand.isSpell(contents[i])) {
                contents[i] = null;
            }
            ++i;
        }
        this.storedInventory.setContents(contents);
        inventory.clear();
        if (keepItem != null) {
            inventory.setItem(keepSlot, keepItem);
        }
        return true;
    }

    public boolean storeInventory() {
        return this.storeInventory(this.player.getInventory().getHeldItemSlot(), this.player.getInventory().getItemInHand());
    }

    public boolean restoreInventory() {
        return this.restoreInventory(this.player.getInventory().getHeldItemSlot(), this.player.getInventory().getItemInHand());
    }

    public boolean restoreInventory(int keepSlot, ItemStack keepItem) {
        if (this.storedInventory == null) {
            return false;
        }
        PlayerInventory inventory = this.player.getInventory();
        inventory.setContents(this.storedInventory.getContents());
        this.storedInventory = null;
        if (keepItem != null) {
            ItemStack occupied = inventory.getItem(keepSlot);
            inventory.setItem(keepSlot, keepItem);
            if (occupied != null) {
                HashMap remainder = inventory.addItem(new ItemStack[]{occupied});
                for (ItemStack remains : remainder.values()) {
                    this.player.getWorld().dropItemNaturally(this.player.getLocation(), remains);
                }
            }
        }
        return true;
    }

    public void registerEvent(SpellEventType type, Spell spell) {
        switch (type) {
            case PLAYER_MOVE: {
                if (this.movementListeners.contains(spell)) break;
                this.movementListeners.add(spell);
                break;
            }
            case PLAYER_QUIT: {
                if (this.quitListeners.contains(spell)) break;
                this.quitListeners.add(spell);
                break;
            }
            case PLAYER_DAMAGE: {
                if (this.damageListeners.contains(spell)) break;
                this.damageListeners.add(spell);
                break;
            }
            case PLAYER_DEATH: {
                if (this.deathListeners.contains(spell)) break;
                this.deathListeners.add(spell);
            }
        }
    }

    public void setPlayer(Player player) {
        this.player = player;
    }

    public void unregisterEvent(SpellEventType type, Spell spell) {
        switch (type) {
            case PLAYER_MOVE: {
                this.movementListeners.remove(spell);
                break;
            }
            case PLAYER_DAMAGE: {
                this.damageListeners.remove(spell);
                break;
            }
            case PLAYER_QUIT: {
                this.quitListeners.remove(spell);
                break;
            }
            case PLAYER_DEATH: {
                this.deathListeners.remove(spell);
            }
        }
    }

    public PlayerSpells(Spells master, Player player) {
        this.master = master;
        this.player = player;
    }

    public Player getPlayer() {
        return this.player;
    }

    public void cancel() {
        for (Spell spell : this.spells.values()) {
            spell.cancel();
        }
    }

    public void onPlayerQuit(PlayerQuitEvent event) {
        ArrayList<Spell> active = new ArrayList<Spell>();
        active.addAll(this.quitListeners);
        for (Spell listener : active) {
            listener.onPlayerQuit(event);
        }
    }

    public void onPlayerMove(PlayerMoveEvent event) {
        ArrayList<Spell> active = new ArrayList<Spell>();
        active.addAll(this.movementListeners);
        for (Spell listener : active) {
            listener.onPlayerMove(event);
        }
    }

    public void onPlayerDeath(EntityDeathEvent event) {
        ArrayList<Spell> active = new ArrayList<Spell>();
        active.addAll(this.deathListeners);
        for (Spell listener : active) {
            if (this.player != listener.getPlayer()) continue;
            listener.onPlayerDeath(event);
        }
    }

    public void onPlayerDamage(EntityDamageEvent event) {
        float reduction = this.damageReduction;
        switch (event.getCause()) {
            case CONTACT: 
            case ENTITY_ATTACK: {
                reduction += this.damageReductionPhysical;
                break;
            }
            case PROJECTILE: {
                reduction += this.damageReductionProjectiles;
                break;
            }
            case FALL: {
                reduction += this.damageReductionFalling;
                break;
            }
            case FIRE: 
            case FIRE_TICK: 
            case LAVA: {
                reduction += this.damageReductionFire;
                break;
            }
            case BLOCK_EXPLOSION: 
            case ENTITY_EXPLOSION: {
                reduction += this.damageReductionExplosions;
            }
        }
        if (reduction >= 1.0f) {
            event.setCancelled(true);
            return;
        }
        if (reduction > 0.0f) {
            int newDamage = (int)Math.floor((double)(1.0f - reduction) * event.getDamage());
            if (newDamage == 0) {
                newDamage = 1;
            }
            event.setDamage((double)newDamage);
        }
        ArrayList<Spell> active = new ArrayList<Spell>();
        active.addAll(this.damageListeners);
        for (Spell listener : active) {
            listener.onPlayerDamage(event);
        }
    }

    public Spell getSpell(Material material) {
        Spell spell = this.master.getSpell(material);
        if (spell == null || !spell.hasSpellPermission(this.player)) {
            return null;
        }
        return this.getSpell(spell.getKey());
    }

    public Spell getSpell(String name) {
        Spell spell = this.master.getSpell(name);
        if (spell == null || !spell.hasSpellPermission(this.player)) {
            return null;
        }
        Spell playerSpell = this.spells.get(spell.getKey());
        if (playerSpell == null) {
            playerSpell = (Spell)spell.clone();
            this.spells.put(spell.getKey(), playerSpell);
        }
        playerSpell.setPlayer(this.player);
        return playerSpell;
    }

    public Spells getMaster() {
        return this.master;
    }

    public Inventory getInventory() {
        return this.hasStoredInventory() ? this.getStoredInventory() : this.player.getInventory();
    }

    public Wand getActiveWand() {
        return this.activeWand;
    }

    public void setActiveWand(Wand activeWand) {
        this.activeWand = activeWand;
    }

    public void setBuildingMaterial(Material material, byte data) {
        if (material == Wand.EraseMaterial) {
            material = Material.AIR;
        }
        this.buildingMaterial = new ItemStack(material, 1, 0, Byte.valueOf(data));
    }

    public void clearBuildingMaterial() {
        this.buildingMaterial = null;
    }

    public ItemStack getBuildingMaterial() {
        return this.buildingMaterial;
    }
}

