/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spells;

import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.plugins.magic.Target;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import java.text.DateFormat;
import java.util.Date;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Sign;
import org.bukkit.entity.Player;

public class SignSpell
extends Spell {
    @Override
    public boolean onCast(ConfigurationNode parameters) {
        String typeString = parameters.getString("type", "");
        if (typeString.equals("give")) {
            this.castMessage(this.player, "Have some signs!");
            return this.giveMaterial(Material.SIGN, 8, (short)0, (byte)0);
        }
        this.targetEntity(Player.class);
        Target target = this.getTarget();
        if (target.isBlock()) {
            Block targetBlock = this.getFaceBlock();
            if (targetBlock.getRelative(BlockFace.DOWN).getType() == Material.AIR) {
                targetBlock.setType(Material.WALL_SIGN);
                switch (target.getBlock().getFace(targetBlock)) {
                    case EAST: {
                        targetBlock.setData((byte)2);
                        break;
                    }
                    case WEST: {
                        targetBlock.setData((byte)3);
                        break;
                    }
                    case NORTH: {
                        targetBlock.setData((byte)4);
                        break;
                    }
                    case SOUTH: {
                        targetBlock.setData((byte)5);
                        break;
                    }
                    default: {
                        targetBlock.setData((byte)0);
                        break;
                    }
                }
            } else {
                targetBlock.setType(Material.SIGN_POST);
                float yaw = this.player.getLocation().getYaw();
                yaw = yaw < 180.0f ? yaw + 180.0f : yaw - 180.0f;
                targetBlock.setData((byte)(yaw * 15.0f / 360.0f));
            }
            if (targetBlock.getState() instanceof Sign) {
                Sign sign = (Sign)targetBlock.getState();
                sign.setLine(0, this.player.getName());
                sign.setLine(1, "was here");
                Date currentDate = new Date();
                sign.setLine(3, DateFormat.getInstance().format(currentDate));
                sign.update();
                this.castMessage(this.player, "You leave a tag");
                return true;
            }
            this.sendMessage(this.player, "Sign placement failed!");
            return false;
        }
        if (target.isEntity() && target.getEntity() instanceof Player) {
            Player targetPlayer = (Player)target.getEntity();
            targetPlayer.sendMessage(String.valueOf(this.player.getName()) + " says hi!");
            this.sendMessage(this.player, "You send " + targetPlayer.getName() + " a message");
            return true;
        }
        return false;
    }
}

