/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spells;

import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.plugins.magic.SpellEventType;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.event.entity.EntityDeathEvent;

public class RecallSpell
extends Spell {
    public Location location;
    public boolean isActive;
    private boolean autoDropOnDeath = true;
    private boolean autoDropIsInvisible = false;
    private boolean autoSpawn = true;
    private int disableDistance = 5;
    Material markerMaterial = Material.REDSTONE_TORCH_ON;

    @Override
    public boolean onCast(ConfigurationNode parameters) {
        String typeString;
        if (this.autoDropOnDeath) {
            this.spells.registerEvent(SpellEventType.PLAYER_DEATH, this);
        }
        if ((typeString = parameters.getString("type", "")).equals("spawn")) {
            this.castMessage(this.player, "Returning you home");
            this.player.teleport(this.player.getWorld().getSpawnLocation());
            return true;
        }
        if (this.getYRotation() > 80.0) {
            if (!this.isActive && this.autoSpawn) {
                this.castMessage(this.player, "Returning you home");
                this.player.teleport(this.player.getWorld().getSpawnLocation());
            } else {
                if (!this.isActive) {
                    return false;
                }
                double distance = RecallSpell.getDistance(this.player.getLocation(), this.location);
                if (distance < (double)this.disableDistance && this.autoSpawn) {
                    this.castMessage(this.player, "Returning you home");
                    this.player.teleport(this.player.getWorld().getSpawnLocation());
                } else {
                    this.castMessage(this.player, "Returning you to your marker");
                    this.player.teleport(this.location);
                }
            }
            return true;
        }
        if (!this.isActive) {
            return this.placeMarker(this.getTargetBlock());
        }
        return this.placeMarker(this.getTargetBlock());
    }

    protected boolean removeMarker() {
        if (!this.isActive || this.location == null) {
            return false;
        }
        this.isActive = false;
        int x = (int)Math.floor(this.location.getX());
        int y = (int)Math.floor(this.location.getY());
        int z = (int)Math.floor(this.location.getZ());
        Block targetBlock = this.player.getWorld().getBlockAt(x, y, z);
        if (targetBlock != null && targetBlock.getType() == this.markerMaterial) {
            targetBlock.setType(Material.AIR);
        }
        return true;
    }

    protected boolean placeMarker(Block target) {
        if (target == null) {
            this.castMessage(this.player, "No target");
            return false;
        }
        Block targetBlock = target.getRelative(BlockFace.UP);
        if (targetBlock.getType() != Material.AIR) {
            targetBlock = this.getFaceBlock();
        }
        if (targetBlock.getType() != Material.AIR) {
            this.castMessage(this.player, "Can't place a marker there");
            return false;
        }
        if (this.removeMarker()) {
            this.castMessage(this.player, "You move your recall marker");
        } else {
            this.castMessage(this.player, "You place a recall marker");
        }
        this.location = this.player.getLocation();
        this.location.setX((double)targetBlock.getX());
        this.location.setY((double)targetBlock.getY());
        this.location.setZ((double)targetBlock.getZ());
        this.player.setCompassTarget(this.location);
        targetBlock.setType(this.markerMaterial);
        this.isActive = true;
        return true;
    }

    @Override
    public void onLoad(ConfigurationNode properties) {
        this.autoDropOnDeath = properties.getBoolean("auto_resurrect", this.autoDropOnDeath);
        this.autoDropIsInvisible = properties.getBoolean("auto_resurrect_invisible", this.autoDropIsInvisible);
        this.autoSpawn = properties.getBoolean("allow_spawn", this.autoSpawn);
        this.markerMaterial = properties.getMaterial("recall_marker", this.markerMaterial);
    }

    @Override
    public void onPlayerDeath(EntityDeathEvent event) {
        if (this.autoDropOnDeath && !this.isActive) {
            this.sendMessage(this.player, "Use recall to return to where you died");
            this.placeMarker(this.getPlayerBlock());
        }
    }
}

