/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spells;

import com.elmakers.mine.bukkit.dao.BlockList;
import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.inventory.ItemStack;

public class MineSpell
extends Spell {
    static final String DEFAULT_MINEABLE = "14,15,16, 56, 73, 74, 21 ,129,153";
    static final String DEFAULT_MINED = "14,15,263,264,331,331,351,388,406";
    static final String DEFAULT_DATA = "0 ,0 ,0  ,0  ,0  ,0  ,4  ,0  ,1";
    private List<Material> mineableMaterials = new ArrayList<Material>();
    private List<Material> minedMaterials = new ArrayList<Material>();
    private List<Integer> minedData = new ArrayList<Integer>();
    private int maxRecursion = 16;

    @Override
    public boolean onCast(ConfigurationNode parameters) {
        Block target = this.getTargetBlock();
        if (target == null) {
            this.castMessage(this.player, "No target");
            return false;
        }
        if (!this.isMineable(target)) {
            this.sendMessage(this.player, "Can't mine " + target.getType().name().toLowerCase());
            return false;
        }
        BlockList minedBlocks = new BlockList();
        Material mineMaterial = target.getType();
        this.mine(target, mineMaterial, minedBlocks);
        World world = this.player.getWorld();
        int index = this.mineableMaterials.indexOf(mineMaterial);
        mineMaterial = this.minedMaterials.get(index);
        byte data = (byte)this.minedData.get(index).intValue();
        Location itemDrop = new Location(world, (double)target.getX(), (double)target.getY(), (double)target.getZ(), 0.0f, 0.0f);
        ItemStack items = new ItemStack(mineMaterial, minedBlocks.size(), 0, Byte.valueOf(data));
        this.player.getWorld().dropItemNaturally(itemDrop, items);
        this.castMessage(this.player, "Mined " + minedBlocks.size() + " blocks of " + mineMaterial.name().toLowerCase());
        return true;
    }

    protected void mine(Block block, Material fillMaterial, BlockList minedBlocks) {
        this.mine(block, fillMaterial, minedBlocks, 0);
    }

    protected void mine(Block block, Material fillMaterial, BlockList minedBlocks, int rDepth) {
        minedBlocks.add(block);
        block.setType(Material.AIR);
        if (rDepth < this.maxRecursion) {
            this.tryMine(block.getRelative(BlockFace.NORTH), fillMaterial, minedBlocks, rDepth + 1);
            this.tryMine(block.getRelative(BlockFace.WEST), fillMaterial, minedBlocks, rDepth + 1);
            this.tryMine(block.getRelative(BlockFace.SOUTH), fillMaterial, minedBlocks, rDepth + 1);
            this.tryMine(block.getRelative(BlockFace.EAST), fillMaterial, minedBlocks, rDepth + 1);
            this.tryMine(block.getRelative(BlockFace.UP), fillMaterial, minedBlocks, rDepth + 1);
            this.tryMine(block.getRelative(BlockFace.DOWN), fillMaterial, minedBlocks, rDepth + 1);
        }
    }

    protected void tryMine(Block target, Material fillMaterial, BlockList minedBlocks, int rDepth) {
        if (target.getType() != fillMaterial || minedBlocks.contains(target)) {
            return;
        }
        this.mine(target, fillMaterial, minedBlocks, rDepth);
    }

    public boolean isMineable(Block block) {
        if (block.getType() == Material.AIR) {
            return false;
        }
        return this.mineableMaterials.contains(block.getType());
    }

    @Override
    public void onLoad(ConfigurationNode properties) {
        this.mineableMaterials = csv.parseMaterials(DEFAULT_MINEABLE);
        this.minedMaterials = csv.parseMaterials(DEFAULT_MINED);
        this.minedData = csv.parseIntegers(DEFAULT_DATA);
        this.maxRecursion = properties.getInteger("recursion_depth", this.maxRecursion);
    }
}

