/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spells;

import com.elmakers.mine.bukkit.dao.BlockList;
import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.util.Vector;

public class LavaSpell
extends Spell {
    @Override
    public boolean onCast(ConfigurationNode parameters) {
        Block target = this.getTargetBlock();
        if (target == null) {
            this.castMessage(this.player, "No target");
            return false;
        }
        int lavaBlocks = (int)LavaSpell.getDistance(this.player, target);
        if (lavaBlocks <= 0) {
            return false;
        }
        Vector targetLoc = new Vector(target.getX(), target.getY(), target.getZ());
        Vector playerLoc = new Vector(this.player.getLocation().getX(), this.player.getLocation().getY() + 1.0, this.player.getLocation().getZ());
        Vector aim = targetLoc;
        aim.subtract(playerLoc);
        aim.normalize();
        targetLoc = playerLoc;
        targetLoc.add(aim);
        targetLoc.add(aim);
        BlockList burnedBlocks = new BlockList();
        int i = 0;
        while (i < lavaBlocks) {
            Block currentTarget = target.getWorld().getBlockAt(targetLoc.getBlockX(), targetLoc.getBlockY(), targetLoc.getBlockZ());
            if (currentTarget.getType() == Material.AIR) {
                burnedBlocks.add(currentTarget);
                Material mat = i > 15 ? Material.STATIONARY_LAVA : Material.LAVA;
                byte data = (byte)(i > 15 ? 15 : (byte)i);
                currentTarget.setType(mat);
                currentTarget.setData(data);
            }
            targetLoc.add(aim);
            ++i;
        }
        if (burnedBlocks.size() > 0) {
            burnedBlocks.setTimeToLive(2);
            this.spells.addToUndoQueue(this.player, burnedBlocks);
        }
        this.castMessage(this.player, "Blasted " + burnedBlocks.size() + " lava blocks");
        return true;
    }
}

