/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utilities;

import com.elmakers.mine.bukkit.dao.BlockData;
import com.elmakers.mine.bukkit.dao.BlockList;
import com.elmakers.mine.bukkit.utilities.BlockAction;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;

public class BlockRecurse {
    protected int maxRecursion = 8;

    public int recurse(Block startBlock, BlockAction recurseAction) {
        this.recurse(startBlock, recurseAction, null, 0);
        return recurseAction.getBlocks().size();
    }

    protected void recurse(Block block, BlockAction recurseAction, BlockFace nextFace, int rDepth) {
        BlockList affectedBlocks = recurseAction.getBlocks();
        if (nextFace != null) {
            block = block.getRelative(nextFace);
        }
        if (affectedBlocks.contains(block)) {
            return;
        }
        affectedBlocks.add(block);
        if (!recurseAction.perform(block)) {
            return;
        }
        if (rDepth < this.maxRecursion) {
            for (BlockFace face : BlockData.FACES) {
                if (nextFace != null && nextFace == BlockData.getReverseFace(face)) continue;
                this.recurse(block, recurseAction, face, rDepth + 1);
            }
        }
    }
}

