/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spells;

import com.elmakers.mine.bukkit.dao.BlockList;
import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;

public class TunnelSpell
extends Spell {
    static final String DEFAULT_DESTRUCTIBLES = "1,3,10,11,12,13,87,88";
    private List<Material> destructibleMaterials = new ArrayList<Material>();
    private int defaultDepth = 8;
    private int defaultWidth = 3;
    private int defaultHeight = 3;
    private int defaultSearchDistance = 32;
    private int torchFrequency = 4;

    public boolean onCast(ConfigurationNode parameters) {
        Block bottomBlock;
        Block playerBlock = this.getPlayerBlock();
        if (playerBlock == null) {
            this.player.sendMessage("You need to be standing on something");
            return false;
        }
        BlockFace direction = this.getPlayerFacing();
        Block searchBlock = playerBlock.getRelative(BlockFace.UP).getRelative(BlockFace.UP);
        for (int searchDistance = 0; searchBlock.getType() == Material.AIR && searchDistance < this.defaultSearchDistance; ++searchDistance) {
            searchBlock = searchBlock.getRelative(direction);
        }
        int depth = this.defaultDepth;
        int height = this.defaultHeight;
        int width = this.defaultWidth;
        BlockList tunneledBlocks = new BlockList();
        BlockFace toTheLeft = TunnelSpell.goLeft(direction);
        BlockFace toTheRight = TunnelSpell.goRight(direction);
        Block bottomLeftBlock = bottomBlock = searchBlock.getRelative(BlockFace.DOWN);
        for (int i = 0; i < width / 2; ++i) {
            bottomLeftBlock = bottomLeftBlock.getRelative(toTheLeft);
        }
        Block targetBlock = bottomLeftBlock;
        for (int d = 0; d < depth; ++d) {
            bottomBlock = bottomLeftBlock;
            for (int w = 0; w < width; ++w) {
                targetBlock = bottomBlock;
                for (int h = 0; h < height; ++h) {
                    if (this.isDestructible(targetBlock)) {
                        boolean useTorch = false;
                        tunneledBlocks.add(targetBlock);
                        if (useTorch) {
                            Block checkBlock = null;
                            checkBlock = w == 0 ? targetBlock.getRelative(toTheLeft) : targetBlock.getRelative(toTheRight);
                            if (checkBlock.getType() == Material.AIR) {
                                targetBlock.setType(Material.AIR);
                            } else {
                                targetBlock.setType(Material.TORCH);
                            }
                        } else {
                            targetBlock.setType(Material.AIR);
                        }
                    }
                    targetBlock = targetBlock.getRelative(BlockFace.UP);
                }
                bottomBlock = bottomBlock.getRelative(toTheRight);
            }
            bottomLeftBlock = bottomLeftBlock.getRelative(direction);
        }
        this.spells.addToUndoQueue(this.player, tunneledBlocks);
        this.castMessage(this.player, "Tunneled through " + tunneledBlocks.size() + "blocks");
        return true;
    }

    public boolean isDestructible(Block block) {
        if (block.getType() == Material.AIR) {
            return false;
        }
        return this.destructibleMaterials.contains(block.getType());
    }

    public void onLoad(ConfigurationNode properties) {
        this.destructibleMaterials = properties.getMaterials("destructible", DEFAULT_DESTRUCTIBLES);
        this.defaultDepth = properties.getInteger("depth", this.defaultDepth);
        this.defaultWidth = properties.getInteger("width", this.defaultWidth);
        this.defaultHeight = properties.getInteger("height", this.defaultHeight);
        this.defaultSearchDistance = properties.getInteger("search_distance", this.defaultSearchDistance);
        this.torchFrequency = properties.getInteger("torch_frequency", this.torchFrequency);
    }
}

