/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spells;

import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.TreeType;
import org.bukkit.block.Block;

public class TreeSpell
extends Spell {
    private TreeType defaultTreeType = null;
    private boolean requireSapling = false;

    public boolean onCast(ConfigurationNode parameters) {
        boolean result;
        Block target = this.getTargetBlock();
        if (target == null) {
            this.castMessage(this.player, "No target");
            return false;
        }
        if (this.requireSapling && target.getType() != Material.SAPLING) {
            this.castMessage(this.player, "Plant a sapling first");
            return false;
        }
        Location treeLoc = new Location(this.player.getWorld(), (double)target.getX(), (double)(target.getY() + 1), (double)target.getZ(), 0.0f, 0.0f);
        TreeType treeType = this.defaultTreeType;
        String typeString = parameters.getString("type", "");
        treeType = TreeSpell.parseTreeString(typeString, this.defaultTreeType);
        if (treeType == null) {
            treeType = TreeType.values()[(int)(Math.random() * (double)TreeType.values().length)];
        }
        if (result = this.player.getWorld().generateTree(treeLoc, treeType)) {
            this.castMessage(this.player, "You grow a " + this.getTreeName(treeType) + " tree");
        } else {
            this.castMessage(this.player, "Your tree didn't grow");
        }
        return result;
    }

    public String getTreeName(TreeType treeType) {
        return treeType.name().toLowerCase();
    }

    public static TreeType parseTreeString(String s, TreeType defaultTreeType) {
        if (s.equalsIgnoreCase("big")) {
            return TreeType.BIG_TREE;
        }
        if (s.equalsIgnoreCase("tall")) {
            return TreeType.TALL_REDWOOD;
        }
        TreeType tree = defaultTreeType;
        for (TreeType t : TreeType.values()) {
            if (!t.name().equalsIgnoreCase(s)) continue;
            tree = t;
        }
        return tree;
    }

    public void onLoad(ConfigurationNode properties) {
        this.requireSapling = properties.getBoolean("require_sapling", this.requireSapling);
    }
}

