/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spells;

import com.elmakers.mine.bukkit.dao.BlockList;
import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import org.bukkit.Material;
import org.bukkit.block.Block;

public class TorchSpell
extends Spell {
    private boolean allowDay = false;
    private boolean allowNight = false;
    private boolean allowLightstone = false;

    public boolean onCast(ConfigurationNode parameters) {
        if (parameters.containsKey("time")) {
            long targetTime = 0L;
            String typeString = parameters.getString("time", "day");
            String timeDescription = "day";
            if (typeString.equalsIgnoreCase("night")) {
                targetTime = 13000L;
                timeDescription = "night";
            } else {
                try {
                    targetTime = Long.parseLong(typeString);
                    timeDescription = "raw: " + targetTime;
                }
                catch (NumberFormatException ex) {
                    targetTime = 0L;
                }
            }
            this.setRelativeTime(targetTime);
            this.castMessage(this.player, "Changed time to " + timeDescription);
            return true;
        }
        if (this.getYRotation() > 80.0 && this.allowDay) {
            this.castMessage(this.player, "FLAME ON!");
            this.setRelativeTime(0L);
            return true;
        }
        if (this.getYRotation() < -80.0 && this.allowNight) {
            this.castMessage(this.player, "FLAME OFF!");
            this.setRelativeTime(13000L);
            return true;
        }
        Block target = this.getTargetBlock();
        Block face = this.getLastBlock();
        if (target == null || face == null) {
            this.castMessage(this.player, "No target");
            return false;
        }
        boolean isAir = face.getType() == Material.AIR;
        boolean isAttachmentSlippery = target.getType() == Material.GLASS || target.getType() == Material.ICE;
        boolean replaceAttachment = target.getType() == Material.SNOW || target.getType() == Material.NETHERRACK || target.getType() == Material.SOUL_SAND;
        boolean isWater = face.getType() == Material.STATIONARY_WATER || face.getType() == Material.WATER;
        boolean isNether = target.getType() == Material.NETHERRACK || target.getType() == Material.SOUL_SAND;
        Material targetMaterial = Material.TORCH;
        if (isWater || isAttachmentSlippery || isNether) {
            targetMaterial = Material.GLOWSTONE;
            replaceAttachment = true;
        }
        if (face == null || !isAir && !isWater || targetMaterial == Material.GLOWSTONE && !this.allowLightstone) {
            this.player.sendMessage("Can't put a torch there");
            return false;
        }
        if (!replaceAttachment) {
            target = face;
        }
        this.castMessage(this.player, "Flame on!");
        BlockList torchBlock = new BlockList();
        target.setType(targetMaterial);
        torchBlock.add(target);
        this.spells.addToUndoQueue(this.player, torchBlock);
        return true;
    }

    public void onLoad(ConfigurationNode properties) {
        this.allowNight = properties.getBoolean("allow_night", this.allowNight);
        this.allowDay = properties.getBoolean("allow_day", this.allowDay);
        this.allowLightstone = properties.getBoolean("allow_glowstone", this.allowLightstone);
    }
}

