/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spells;

import com.elmakers.mine.bukkit.dao.BlockList;
import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;

public class StairsSpell
extends Spell {
    static final String DEFAULT_DESTRUCTIBLES = "1,3,10,11,12,13";
    private List<Material> destructibleMaterials = new ArrayList<Material>();
    private int defaultDepth = 4;
    private int defaultWidth = 3;
    private int defaultHeight = 3;
    private int torchFrequency = 4;

    public boolean onCast(ConfigurationNode parameters) {
        Block targetBlock = this.getTargetBlock();
        if (targetBlock == null) {
            this.castMessage(this.player, "No target");
            return false;
        }
        this.createStairs(targetBlock);
        return true;
    }

    protected void createStairs(Block targetBlock) {
        Block bottomBlock;
        BlockFace vertDirection = BlockFace.UP;
        BlockFace horzDirection = this.getPlayerFacing();
        int depth = this.defaultDepth;
        int height = this.defaultHeight;
        int width = this.defaultWidth;
        BlockList tunneledBlocks = new BlockList();
        BlockList stairBlocks = new BlockList();
        Material fillMaterial = targetBlock.getType();
        BlockFace toTheLeft = StairsSpell.goLeft(horzDirection);
        BlockFace toTheRight = StairsSpell.goRight(horzDirection);
        Block bottomLeftBlock = bottomBlock = targetBlock;
        for (int i = 0; i < width / 2; ++i) {
            bottomLeftBlock = bottomLeftBlock.getRelative(toTheLeft);
        }
        targetBlock = bottomLeftBlock;
        Material stairsMaterial = Material.COBBLESTONE_STAIRS;
        for (int d = 0; d < depth; ++d) {
            bottomBlock = bottomLeftBlock;
            for (int w = 0; w < width; ++w) {
                targetBlock = bottomBlock;
                for (int h = 0; h < height; ++h) {
                    if (this.isDestructible(targetBlock)) {
                        boolean useStairs;
                        Block checkBlock = null;
                        checkBlock = w == 0 ? targetBlock.getRelative(toTheLeft) : targetBlock.getRelative(toTheRight);
                        boolean useTorch = this.torchFrequency > 0 && (w == 0 || w == width - 1) && h == 1 && d % this.torchFrequency == 0 && checkBlock.getType() != Material.AIR;
                        boolean bl = useStairs = h == 0;
                        if (useStairs) {
                            stairBlocks.add(targetBlock);
                            targetBlock.setType(stairsMaterial);
                        } else if (useTorch) {
                            tunneledBlocks.add(targetBlock);
                            targetBlock.setType(Material.TORCH);
                        } else {
                            tunneledBlocks.add(targetBlock);
                            targetBlock.setType(Material.AIR);
                        }
                        Block standingBlock = targetBlock.getRelative(BlockFace.DOWN);
                        if (standingBlock.getType() == Material.AIR) {
                            stairBlocks.add(standingBlock);
                            standingBlock.setType(fillMaterial);
                        }
                    }
                    targetBlock = targetBlock.getRelative(BlockFace.UP);
                }
                bottomBlock = bottomBlock.getRelative(toTheRight);
            }
            bottomLeftBlock = bottomLeftBlock.getRelative(horzDirection);
            bottomLeftBlock = bottomLeftBlock.getRelative(vertDirection);
        }
        this.spells.addToUndoQueue(this.player, tunneledBlocks);
        this.spells.addToUndoQueue(this.player, stairBlocks);
        this.castMessage(this.player, "Tunneled through " + tunneledBlocks.size() + "blocks and created " + stairBlocks.size() + " stairs");
    }

    protected void createSpiralStairs(Block targetBlock) {
    }

    public boolean isDestructible(Block block) {
        if (block.getType() == Material.AIR) {
            return false;
        }
        return this.destructibleMaterials.contains(block.getType());
    }

    public void onLoad(ConfigurationNode properties) {
        this.destructibleMaterials = properties.getMaterials("destructible", DEFAULT_DESTRUCTIBLES);
        this.defaultDepth = properties.getInteger("depth", this.defaultDepth);
        this.defaultWidth = properties.getInteger("width", this.defaultWidth);
        this.defaultHeight = properties.getInteger("height", this.defaultHeight);
        this.torchFrequency = properties.getInteger("torch_frequency", this.torchFrequency);
    }
}

