/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spells;

import com.elmakers.mine.bukkit.dao.BlockList;
import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.inventory.ItemStack;

public class PillarSpell
extends Spell {
    int MAX_SEARCH_DISTANCE = 255;

    public boolean onCast(ConfigurationNode parameters) {
        Block attachBlock = this.getTargetBlock();
        if (attachBlock == null) {
            this.castMessage(this.player, "No target");
            return false;
        }
        BlockFace direction = BlockFace.UP;
        String typeString = parameters.getString("type", "");
        if (typeString.equals("down")) {
            direction = BlockFace.DOWN;
        }
        Block targetBlock = attachBlock.getRelative(direction);
        for (int distance = 0; this.isTargetable(targetBlock.getType()) && distance <= this.MAX_SEARCH_DISTANCE; ++distance) {
            attachBlock = targetBlock;
            targetBlock = attachBlock.getRelative(direction);
        }
        if (this.isTargetable(targetBlock.getType())) {
            this.player.sendMessage("Can't pillar any further");
            return false;
        }
        Material material = attachBlock.getType();
        byte data = attachBlock.getData();
        ItemStack buildWith = this.getBuildingMaterial();
        if (buildWith != null) {
            material = buildWith.getType();
            data = PillarSpell.getItemData(buildWith);
        }
        BlockList pillarBlocks = new BlockList();
        Block pillar = this.getBlockAt(targetBlock.getX(), targetBlock.getY(), targetBlock.getZ());
        pillarBlocks.add(pillar);
        pillar.setType(material);
        pillar.setData(data);
        this.castMessage(this.player, "Creating a pillar of " + attachBlock.getType().name().toLowerCase());
        this.spells.addToUndoQueue(this.player, pillarBlocks);
        return true;
    }
}

