/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spells;

import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.plugins.magic.SpellEventType;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.util.Vector;

public class FlingSpell
extends Spell {
    private final long safetyLength = 20000L;
    private long lastFling = 0L;
    protected int maxSpeedAtElevation = 32;
    protected double minMagnitude = 1.5;
    protected double maxMagnitude = 8.0;

    public boolean onCast(ConfigurationNode parameters) {
        int height;
        Block playerBlock = this.player.getLocation().getBlock();
        for (height = 0; height < this.maxSpeedAtElevation && playerBlock.getType() == Material.AIR; ++height) {
            playerBlock = playerBlock.getRelative(BlockFace.DOWN);
        }
        double magnitude = this.minMagnitude + (this.maxMagnitude - this.minMagnitude) * ((double)height / (double)this.maxSpeedAtElevation);
        Vector velocity = this.getAimVector();
        if (this.player.getLocation().getBlockY() >= 256) {
            velocity.setY(0);
        }
        velocity.multiply(magnitude);
        this.player.setVelocity(velocity);
        this.castMessage(this.player, "Whee!");
        this.spells.registerEvent(SpellEventType.PLAYER_DAMAGE, this);
        this.lastFling = System.currentTimeMillis();
        return true;
    }

    public void onPlayerDamage(EntityDamageEvent event) {
        if (event.getCause() != EntityDamageEvent.DamageCause.FALL) {
            return;
        }
        this.spells.unregisterEvent(SpellEventType.PLAYER_DAMAGE, this);
        if (this.lastFling == 0L) {
            return;
        }
        if (this.lastFling + 20000L > System.currentTimeMillis()) {
            event.setCancelled(true);
            this.lastFling = 0L;
        }
    }

    public void onLoad(ConfigurationNode node) {
        this.disableTargeting();
    }
}

