/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spells;

import com.elmakers.mine.bukkit.dao.BlockList;
import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.utilities.SimpleBlockAction;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;

public class FireSpell
extends Spell {
    private int defaultRadius = 4;
    private int verticalSearchDistance = 8;

    public boolean onCast(ConfigurationNode parameters) {
        Block target = this.getTargetBlock();
        if (target == null) {
            this.castMessage(this.player, "No target");
            return false;
        }
        int radius = parameters.getInt("radius", this.defaultRadius);
        FireAction action = new FireAction();
        if (radius <= 1) {
            action.perform(target);
        } else {
            this.coverSurface(target.getLocation(), radius, action);
        }
        this.spells.addToUndoQueue(this.player, action.getBlocks());
        this.castMessage(this.player, "Burned " + action.getBlocks().size() + " blocks");
        return true;
    }

    public void burnBlock(int dx, int dy, int dz, Block centerPoint, int radius, BlockList burnedBlocks) {
        int x = centerPoint.getX() + dx - radius;
        int y = centerPoint.getY() + dy - radius;
        int z = centerPoint.getZ() + dz - radius;
        Block block = this.player.getWorld().getBlockAt(x, y, z);
        int depth = 0;
        if (block.getType() == Material.AIR) {
            while (depth < this.verticalSearchDistance && block.getType() == Material.AIR) {
                ++depth;
                block = block.getRelative(BlockFace.DOWN);
            }
        } else {
            while (depth < this.verticalSearchDistance && block.getType() != Material.AIR) {
                ++depth;
                block = block.getRelative(BlockFace.UP);
            }
            block = block.getRelative(BlockFace.DOWN);
        }
        if (block.getType() == Material.AIR || block.getType() == Material.FIRE) {
            return;
        }
        Material material = Material.FIRE;
        if (block.getType() == Material.WATER || block.getType() == Material.STATIONARY_WATER || block.getType() == Material.ICE || block.getType() == Material.SNOW) {
            material = Material.AIR;
        } else {
            block = block.getRelative(BlockFace.UP);
        }
        burnedBlocks.add(block);
        block.setType(material);
    }

    public int checkPosition(int x, int z, int R) {
        return x * x + z * z - R * R;
    }

    public void onLoad(ConfigurationNode properties) {
        this.defaultRadius = properties.getInteger("radius", this.defaultRadius);
        this.verticalSearchDistance = properties.getInteger("vertical_search_distance", this.verticalSearchDistance);
    }

    public class FireAction
    extends SimpleBlockAction {
        public boolean perform(Block block) {
            if (block.getType() == Material.AIR || block.getType() == Material.FIRE) {
                return false;
            }
            Material material = Material.FIRE;
            if (block.getType() == Material.WATER || block.getType() == Material.STATIONARY_WATER || block.getType() == Material.ICE || block.getType() == Material.SNOW) {
                material = Material.AIR;
            } else {
                block = block.getRelative(BlockFace.UP);
            }
            super.perform(block);
            block.setType(material);
            return true;
        }
    }
}

