/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic;

import com.elmakers.mine.bukkit.plugins.magic.CastingCost;
import com.elmakers.mine.bukkit.plugins.magic.PlayerSpells;
import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.utilities.InventoryUtils;
import com.elmakers.mine.bukkit.utilities.borrowed.Configuration;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import java.io.File;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Wand {
    private ItemStack item;
    private String wandSettings;
    private String wandSpells;
    private String wandMaterials;
    private float costReduction = 0.0f;
    private float damageReduction = 0.0f;
    private float damageReductionPhysical = 0.0f;
    private float damageReductionProjectiles = 0.0f;
    private float damageReductionFalling = 0.0f;
    private float damageReductionFire = 0.0f;
    private float damageReductionExplosions = 0.0f;
    private int uses = 0;
    private int xpRegeneration = 0;
    private int xpMax = 0;
    private int healthRegeneration = 0;
    private int hungerRegeneration = 0;
    private static DecimalFormat floatFormat = new DecimalFormat("#.###");
    private static Material WandMaterial = Material.STICK;
    public static Material EraseMaterial = Material.SULPHUR;
    protected static Map<String, ConfigurationNode> wandTemplates = new HashMap<String, ConfigurationNode>();
    private static final String propertiesFileName = "wands";
    private static final String propertiesFileNameDefaults = "wands.defaults.yml";

    public Wand() {
        this.item = new ItemStack(WandMaterial);
        this.item = InventoryUtils.getCopy(this.item);
        ItemMeta itemMeta = this.item.getItemMeta();
        this.item.setItemMeta(itemMeta);
        InventoryUtils.addGlow(this.item);
        this.wandSettings = " ";
        this.wandSpells = "";
        this.wandMaterials = "";
        this.saveState();
    }

    public Wand(ItemStack item) {
        this.item = item;
        this.loadState();
    }

    public int getXpRegeneration() {
        return this.xpRegeneration;
    }

    public void setXPRegeneration(int xpRegeneration) {
        this.xpRegeneration = xpRegeneration;
        this.updateWandSettings();
    }

    public int getXPMax() {
        return this.xpMax;
    }

    public void setXPMax(int xpMax) {
        this.xpMax = xpMax;
        this.updateWandSettings();
    }

    public int getHealthRegeneration() {
        return this.healthRegeneration;
    }

    public void setHealthRegeneration(int healthRegeneration) {
        this.healthRegeneration = healthRegeneration;
        this.updateWandSettings();
    }

    public int getHungerRegeneration() {
        return this.hungerRegeneration;
    }

    public void setHungerRegeneration(int hungerRegeneration) {
        this.hungerRegeneration = hungerRegeneration;
        this.updateWandSettings();
    }

    public float getCostReduction() {
        return this.costReduction;
    }

    public void setCostReduction(float costReduction) {
        this.costReduction = costReduction;
        this.updateWandSettings();
    }

    public float getDamageReduction() {
        return this.damageReduction;
    }

    public void setDamageReduction(float damageReduction) {
        this.damageReduction = damageReduction;
        this.updateWandSettings();
    }

    public float getDamageReductionPhysical() {
        return this.damageReductionPhysical;
    }

    public void setDamageReductionPhysical(float damageReductionPhysical) {
        this.damageReductionPhysical = damageReductionPhysical;
        this.updateWandSettings();
    }

    public float getDamageReductionProjectiles() {
        return this.damageReductionProjectiles;
    }

    public void setDamageReductionProjectiles(float damageReductionProjectiles) {
        this.damageReductionProjectiles = damageReductionProjectiles;
        this.updateWandSettings();
    }

    public float getDamageReductionFalling() {
        return this.damageReductionFalling;
    }

    public void setDamageReductionFalling(float damageReductionFalling) {
        this.damageReductionFalling = damageReductionFalling;
        this.updateWandSettings();
    }

    public float getDamageReductionFire() {
        return this.damageReductionFire;
    }

    public void setDamageReductionFire(float damageReductionFire) {
        this.damageReductionFire = damageReductionFire;
        this.updateWandSettings();
    }

    public float getDamageReductionExplosions() {
        return this.damageReductionExplosions;
    }

    public void setDamageReductionExplosions(float damageReductionExplosions) {
        this.damageReductionExplosions = damageReductionExplosions;
        this.updateWandSettings();
    }

    public int getUses() {
        return this.uses;
    }

    public void setUses(int uses) {
        this.uses = uses;
        this.updateWandSettings();
    }

    protected void saveState() {
        this.updateWandSettings();
        InventoryUtils.setMeta(this.item, "magic_wand", this.wandSettings);
        InventoryUtils.setMeta(this.item, "magic_materials", this.wandMaterials);
        InventoryUtils.setMeta(this.item, "magic_spells", this.wandSpells);
    }

    protected void updateWandSettings() {
        this.wandSettings = "cr=" + floatFormat.format(this.costReduction) + "&dr=" + floatFormat.format(this.damageReduction) + "&drph=" + floatFormat.format(this.damageReductionPhysical) + "&drpr=" + floatFormat.format(this.damageReductionProjectiles) + "&drfa=" + floatFormat.format(this.damageReductionFalling) + "&drfi=" + floatFormat.format(this.damageReductionFire) + "&drex=" + floatFormat.format(this.damageReductionExplosions) + "&drex=" + floatFormat.format(this.damageReductionExplosions) + "&xpre=" + this.xpRegeneration + "&xpmax=" + this.xpMax + "&hereg=" + this.healthRegeneration + "&hureg=" + this.hungerRegeneration + "&uses=" + this.uses;
    }

    protected void loadState() {
        String[] wandPairs;
        this.wandSettings = InventoryUtils.getMeta(this.item, "magic_wand");
        this.wandSettings = this.wandSettings == null ? "" : this.wandSettings;
        this.wandMaterials = InventoryUtils.getMeta(this.item, "magic_materials");
        this.wandMaterials = this.wandMaterials == null ? "" : this.wandMaterials;
        this.wandSpells = InventoryUtils.getMeta(this.item, "magic_spells");
        this.wandSpells = this.wandSpells == null ? "" : this.wandSpells;
        for (String pair : wandPairs = StringUtils.split((String)this.wandSettings, (String)"&")) {
            String[] keyValue = StringUtils.split((String)pair, (String)"=");
            if (keyValue.length != 2) continue;
            String key = keyValue[0];
            float value = Float.parseFloat(keyValue[1]);
            if (key.equalsIgnoreCase("cr")) {
                this.costReduction = value;
                continue;
            }
            if (key.equalsIgnoreCase("dr")) {
                this.damageReduction = value;
                continue;
            }
            if (key.equalsIgnoreCase("drph")) {
                this.damageReductionPhysical = value;
                continue;
            }
            if (key.equalsIgnoreCase("drpr")) {
                this.damageReductionProjectiles = value;
                continue;
            }
            if (key.equalsIgnoreCase("drfa")) {
                this.damageReductionFalling = value;
                continue;
            }
            if (key.equalsIgnoreCase("drfi")) {
                this.damageReductionFire = value;
                continue;
            }
            if (key.equalsIgnoreCase("drex")) {
                this.damageReductionExplosions = value;
                continue;
            }
            if (key.equalsIgnoreCase("uses")) {
                this.uses = (int)value;
                continue;
            }
            if (key.equalsIgnoreCase("xpre")) {
                this.xpRegeneration = (int)value;
                continue;
            }
            if (key.equalsIgnoreCase("xpmax")) {
                this.xpMax = (int)value;
                continue;
            }
            if (key.equalsIgnoreCase("hereg")) {
                this.healthRegeneration = (int)value;
                continue;
            }
            if (!key.equalsIgnoreCase("hureg")) continue;
            this.hungerRegeneration = (int)value;
        }
    }

    public ItemStack getItem() {
        return this.item;
    }

    public void removeMaterial(Material material, byte data) {
        Integer id = material.getId();
        String materialString = id.toString();
        materialString = materialString + ":" + data;
        String[] materials = this.getMaterials();
        LinkedList<String> materialMap = new LinkedList<String>();
        for (int i = 0; i < materials.length; ++i) {
            String[] pieces = StringUtils.split((String)materials[i], (String)"@");
            if (pieces[0].equals(materialString)) continue;
            materialMap.add(materials[i]);
        }
        this.setMaterials(materialMap);
    }

    public void addMaterial(Material material, int data) {
        this.addMaterial(material, (byte)data);
    }

    public void addMaterial(Material material) {
        this.addMaterial(material, 0);
    }

    public void addMaterial(Material material, byte data) {
        Integer id = material.getId();
        String materialString = id.toString();
        materialString = materialString + ":" + data;
        String[] materials = this.getMaterials();
        LinkedList<String> materialMap = new LinkedList<String>();
        for (int i = 0; i < materials.length; ++i) {
            String[] pieces = StringUtils.split((String)materials[i], (String)"@");
            if (pieces[0].equals(materialString)) continue;
            materialMap.add(materials[i]);
        }
        materialMap.add(materialString);
        this.setMaterials(materialMap);
    }

    protected void setMaterials(Collection<String> materialNames) {
        this.wandMaterials = StringUtils.join(materialNames, (String)"|");
        this.setMaterialCount(materialNames.size());
        this.saveState();
    }

    public String[] getMaterials() {
        return StringUtils.split((String)this.wandMaterials, (String)"|");
    }

    public void addSpells(Collection<String> spellNames) {
        String[] spells = this.getSpells();
        LinkedList<String> spellMap = new LinkedList<String>();
        for (String spell : spells) {
            spellMap.add(spell);
            String[] pieces = StringUtils.split((String)spell, (String)"@");
            spellNames.remove(pieces[0]);
        }
        for (String spellName : spellNames) {
            spellMap.add(spellName);
        }
        this.setSpells(spellMap);
    }

    public String[] getSpells() {
        return StringUtils.split((String)this.wandSpells, (String)"|");
    }

    public void removeSpell(String spellName) {
        String[] spells = this.getSpells();
        LinkedList<String> spellMap = new LinkedList<String>();
        for (int i = 0; i < spells.length; ++i) {
            String[] pieces = StringUtils.split((String)spells[i], (String)"@");
            if (pieces[0].equals(spellName)) continue;
            spellMap.add(spells[i]);
        }
        this.setSpells(spellMap);
    }

    public void addSpell(String spellName) {
        ArrayList<String> names = new ArrayList<String>();
        names.add(spellName);
        this.addSpells(names);
    }

    public void setSpells(Collection<String> spellNames) {
        this.wandSpells = StringUtils.join(spellNames, (String)"|");
        this.setSpellCount(spellNames.size());
        this.saveState();
    }

    public void setSpellCount(int spellCount) {
        this.updateLore(spellCount, this.getMaterials().length);
    }

    public void setMaterialCount(int materialCount) {
        this.updateLore(this.getSpells().length, materialCount);
    }

    public String getName() {
        return this.item.getItemMeta().getDisplayName();
    }

    public String getBaseName() {
        String name = this.getName();
        int beginningOfWand = name.indexOf("(");
        if (beginningOfWand > 0) {
            name = name.substring(beginningOfWand + 1, name.length() - 1);
        }
        return name;
    }

    protected void updateActiveName(PlayerSpells playerSpells) {
        Player player = playerSpells.getPlayer();
        Spell spell = playerSpells.getMaster().getActiveSpell(player);
        ItemStack activeMaterial = player.getInventory().getItem(8);
        String baseName = this.getBaseName();
        String materialName = "";
        if (spell != null && activeMaterial != null && activeMaterial.getType() != Material.AIR && !Wand.isSpell(activeMaterial) && !Wand.isWand(activeMaterial)) {
            materialName = activeMaterial.getType() == EraseMaterial ? "erase" : activeMaterial.getType().name().toLowerCase();
            materialName = " : " + materialName;
        }
        int remaining = this.getRemainingUses();
        if (spell != null) {
            if (remaining > 0) {
                this.setName(ChatColor.RED + "" + remaining + " Uses " + ChatColor.GOLD + spell.getName() + ChatColor.GRAY + materialName + ChatColor.WHITE + " (" + baseName + ")");
            } else {
                this.setName(ChatColor.GOLD + spell.getName() + ChatColor.GRAY + materialName + ChatColor.WHITE + " (" + baseName + ")");
            }
        } else if (remaining > 0) {
            this.setName(ChatColor.RED + "" + remaining + " Uses " + ChatColor.WHITE + "(" + baseName + ")");
        } else {
            this.setName(baseName);
        }
    }

    public void setName(String name) {
        ItemMeta meta = this.item.getItemMeta();
        meta.setDisplayName(name);
        this.item.setItemMeta(meta);
        InventoryUtils.addGlow(this.item);
        this.saveState();
    }

    protected String getLevelString(String prefix, float amount) {
        String suffix = "I";
        if (amount >= 1.0f) {
            suffix = "X";
        } else if ((double)amount > 0.8) {
            suffix = "V";
        } else if ((double)amount > 0.6) {
            suffix = "IV";
        } else if ((double)amount > 0.4) {
            suffix = "III";
        } else if ((double)amount > 0.2) {
            suffix = "II";
        }
        return prefix + " " + suffix;
    }

    protected void updateLore(int spellCount, int materialCount) {
        int remaining;
        ItemMeta meta = this.item.getItemMeta();
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("Knows " + spellCount + " Spells");
        if (materialCount > 0) {
            lore.add("Has " + materialCount + " Materials");
        }
        if ((remaining = this.getRemainingUses()) > 0) {
            lore.add(ChatColor.RED + "" + remaining + " Uses Remaining");
        }
        if (this.costReduction > 0.0f) {
            lore.add(ChatColor.GOLD + this.getLevelString("Cost Reduction", this.costReduction));
        }
        if (this.damageReduction > 0.0f) {
            lore.add(ChatColor.GOLD + this.getLevelString("Protection", this.damageReduction));
        }
        if (this.damageReductionPhysical > 0.0f) {
            lore.add(ChatColor.GOLD + this.getLevelString("Physical Protection", this.damageReductionPhysical));
        }
        if (this.damageReductionProjectiles > 0.0f) {
            lore.add(ChatColor.GOLD + this.getLevelString("Projectile Protection", this.damageReductionProjectiles));
        }
        if (this.damageReductionFalling > 0.0f) {
            lore.add(ChatColor.GOLD + this.getLevelString("Fall Protection", this.damageReductionFalling));
        }
        if (this.damageReductionFire > 0.0f) {
            lore.add(ChatColor.GOLD + this.getLevelString("Fire Protection", this.damageReductionFire));
        }
        if (this.damageReductionExplosions > 0.0f) {
            lore.add(ChatColor.GOLD + this.getLevelString("Blast Protection", this.damageReductionExplosions));
        }
        if (this.xpRegeneration > 0) {
            lore.add(ChatColor.GOLD + this.getLevelString("XP Protection", this.xpRegeneration / 100));
        }
        if (this.healthRegeneration > 0) {
            lore.add(ChatColor.GOLD + "Health Regeneration");
        }
        if (this.hungerRegeneration > 0) {
            lore.add(ChatColor.GOLD + "No Hunger");
        }
        meta.setLore(lore);
        this.item.setItemMeta(meta);
        InventoryUtils.addGlow(this.item);
        this.saveState();
    }

    public int getRemainingUses() {
        int remaining = 0;
        if (this.uses > 0) {
            short durability = this.item.getDurability();
            remaining = Math.max(0, this.uses - durability);
        }
        return remaining;
    }

    public static Wand getActiveWand(Player player) {
        ItemStack activeItem = player.getInventory().getItemInHand();
        return Wand.isWand(activeItem) ? new Wand(activeItem) : null;
    }

    public static boolean hasActiveWand(Player player) {
        ItemStack activeItem = player.getInventory().getItemInHand();
        return Wand.isWand(activeItem);
    }

    public static boolean isWand(ItemStack item) {
        return item != null && item.getType() == Material.STICK && InventoryUtils.getMeta(item, "magic_wand", "").length() > 0;
    }

    public static boolean isSpell(ItemStack item) {
        return item != null && item.getType() != Material.STICK && InventoryUtils.getMeta(item, "magic_spell", "").length() > 0;
    }

    /*
     * WARNING - void declaration
     */
    protected void updateInventory(PlayerSpells playerSpells, int itemSlot) {
        Player player = playerSpells.getPlayer();
        PlayerInventory inventory = player.getInventory();
        inventory.clear();
        inventory.setItem(itemSlot, this.item);
        String[] spells = StringUtils.split((String)this.wandSpells, (String)"|");
        LinkedList<ItemStack> unpositionedSpells = new LinkedList<ItemStack>();
        for (int i = 0; i < spells.length; ++i) {
            int slot;
            String[] parts = StringUtils.split((String)spells[i], (String)"@");
            String spellName = parts[0];
            Spell spell = playerSpells.getSpell(spellName);
            if (spell == null) continue;
            ItemStack itemStack = new ItemStack(spell.getMaterial(), 1);
            itemStack = InventoryUtils.getCopy(itemStack);
            ItemMeta itemMeta = itemStack.getItemMeta();
            itemMeta.setDisplayName(spell.getName());
            ArrayList<String> lore = new ArrayList<String>();
            lore.add(spell.getCategory());
            lore.add(spell.getDescription());
            List<CastingCost> costs = spell.getCosts();
            if (costs != null) {
                for (CastingCost cost : costs) {
                    if (!cost.hasCosts(playerSpells)) continue;
                    lore.add(ChatColor.YELLOW + "Costs " + cost.getFullDescription(playerSpells));
                }
            }
            itemMeta.setLore(lore);
            itemStack.setItemMeta(itemMeta);
            InventoryUtils.addGlow(itemStack);
            InventoryUtils.setMeta(itemStack, "magic_spell", spells[i]);
            int n = slot = parts.length > 1 ? Integer.parseInt(parts[1]) : itemSlot;
            if (parts.length > 1 && slot != itemSlot) {
                inventory.setItem(slot, itemStack);
                continue;
            }
            unpositionedSpells.add(itemStack);
        }
        String[] materials = StringUtils.split((String)this.wandMaterials, (String)"|");
        LinkedList<ItemStack> unpositionedMaterials = new LinkedList<ItemStack>();
        HashMap<Integer, ItemStack> positioned = new HashMap<Integer, ItemStack>();
        ItemStack eraseStack = null;
        for (int i = 0; i < materials.length; ++i) {
            ArrayList<String> lore;
            String[] stringArray = StringUtils.split((String)materials[i], (String)"@");
            String[] nameParts = StringUtils.split((String)stringArray[0], (String)":");
            int typeId = Integer.parseInt(nameParts[0]);
            if (typeId == 0) {
                typeId = EraseMaterial.getId();
            }
            int dataId = nameParts.length > 1 ? Integer.parseInt(nameParts[1]) : 0;
            ItemStack itemStack = new ItemStack(typeId, 1, 0, Byte.valueOf((byte)dataId));
            itemStack = InventoryUtils.getCopy(itemStack);
            ItemMeta meta = itemStack.getItemMeta();
            if (typeId == EraseMaterial.getId()) {
                meta.setDisplayName("Erase");
                lore = new ArrayList();
                lore.add("Fills with Air");
                meta.setLore(lore);
            } else {
                lore = new ArrayList<String>();
                lore.add("Magic building material");
                meta.setLore(lore);
            }
            itemStack.setItemMeta(meta);
            int slot = stringArray.length > 1 ? Integer.parseInt(stringArray[1]) : itemSlot;
            ItemStack existing = inventory.getItem(slot);
            if (stringArray.length > 1 && slot != itemSlot && (existing == null || existing.getType() == Material.AIR)) {
                positioned.put(slot, itemStack);
                continue;
            }
            if (itemStack.getType() == EraseMaterial) {
                eraseStack = itemStack;
                continue;
            }
            unpositionedMaterials.add(itemStack);
        }
        if (unpositionedMaterials.size() > 0) {
            void var12_19;
            int materialSpaces = Math.min(unpositionedMaterials.size(), 3);
            int n = 8 - materialSpaces;
            while (unpositionedSpells.size() > 0 && var12_19 > 0) {
                inventory.addItem(new ItemStack[]{(ItemStack)unpositionedSpells.remove()});
                --var12_19;
            }
        }
        if (eraseStack != null) {
            Wand.addMaterialToInventory((Inventory)inventory, eraseStack);
        }
        for (ItemStack itemStack : unpositionedMaterials) {
            Wand.addMaterialToInventory((Inventory)inventory, itemStack);
        }
        for (ItemStack itemStack : unpositionedSpells) {
            inventory.addItem(new ItemStack[]{itemStack});
        }
        for (Map.Entry entry : positioned.entrySet()) {
            int slot = (Integer)entry.getKey();
            ItemStack itemStack = (ItemStack)entry.getValue();
            ItemStack existing = inventory.getItem(slot);
            if (slot != itemSlot && (existing == null || existing.getType() == Material.AIR)) {
                inventory.setItem(slot, itemStack);
                continue;
            }
            Wand.addMaterialToInventory((Inventory)inventory, itemStack);
        }
        this.updateActiveName(playerSpells);
        player.updateInventory();
    }

    protected static void addMaterialToInventory(Inventory inventory, ItemStack stack) {
        for (int i = 8; i >= 0; --i) {
            ItemStack existing = inventory.getItem(i);
            if (existing != null && existing.getType() != Material.AIR) continue;
            inventory.setItem(i, stack);
            return;
        }
        inventory.addItem(new ItemStack[]{stack});
    }

    protected void saveInventory(PlayerSpells playerSpells) {
        PlayerInventory inventory = playerSpells.getPlayer().getInventory();
        ItemStack[] items = inventory.getContents();
        ArrayList<String> spellNames = new ArrayList<String>();
        ArrayList<String> materialNames = new ArrayList<String>();
        for (int i = 0; i < items.length; ++i) {
            if (items[i] == null) continue;
            Material material = items[i].getType();
            if (Wand.isSpell(items[i])) {
                Spell spell = playerSpells.getSpell(material);
                if (spell == null) continue;
                spellNames.add(spell.getKey() + "@" + i);
                continue;
            }
            List<Material> buildingMaterials = playerSpells.getMaster().getBuildingMaterials();
            if (material == Material.AIR || !buildingMaterials.contains(material) && material != EraseMaterial) continue;
            String materialkey = material == EraseMaterial ? "0:0" : material.getId() + ":" + items[i].getData().getData();
            materialNames.add(materialkey + "@" + i);
        }
        this.setSpells(spellNames);
        this.setMaterials(materialNames);
        this.saveState();
        this.setName(this.getBaseName());
    }

    public static boolean isActive(Player player) {
        ItemStack activeItem = player.getInventory().getItemInHand();
        return Wand.isWand(activeItem);
    }

    public static Wand createWand(String templateName) {
        Wand wand = new Wand();
        ArrayList<String> defaultSpells = new ArrayList<String>();
        String defaultName = "Wand";
        if (wandTemplates.containsKey(templateName)) {
            List<Object> materialList;
            ConfigurationNode wandConfig = wandTemplates.get(templateName);
            defaultName = wandConfig.getString("name", defaultName);
            List<Object> spellList = wandConfig.getList("spells");
            if (spellList != null) {
                for (Object spellName : spellList) {
                    defaultSpells.add((String)spellName);
                }
            }
            if ((materialList = wandConfig.getList("materials")) != null) {
                for (Object materialNameAndData : materialList) {
                    String[] materialParts = StringUtils.split((String)((String)materialNameAndData), (char)':');
                    String materialName = materialParts[0];
                    byte data = 0;
                    if (materialParts.length > 1) {
                        data = Byte.parseByte(materialParts[1]);
                    }
                    if (materialName.equals("erase")) {
                        wand.addMaterial(EraseMaterial, data);
                        continue;
                    }
                    wand.addMaterial(ConfigurationNode.toMaterial(materialName), data);
                }
            }
            wand.setCostReduction((float)wandConfig.getDouble("cost_reduction", 0.0));
            wand.setDamageReduction((float)wandConfig.getDouble("damage_reduction", 0.0));
            wand.setDamageReductionPhysical((float)wandConfig.getDouble("damage_reduction_physical", 0.0));
            wand.setDamageReductionProjectiles((float)wandConfig.getDouble("damage_reduction_projectiles", 0.0));
            wand.setDamageReductionFalling((float)wandConfig.getDouble("damage_reduction_falling", 0.0));
            wand.setDamageReductionFire((float)wandConfig.getDouble("damage_reduction_fire", 0.0));
            wand.setDamageReductionExplosions((float)wandConfig.getDouble("damage_reduction_explosions", 0.0));
            wand.setXPRegeneration(wandConfig.getInt("xp_regeneration", 0));
            wand.setXPMax(wandConfig.getInt("xp_max", 0));
            wand.setHealthRegeneration(wandConfig.getInt("health_regeneration", 0));
            wand.setHungerRegeneration(wandConfig.getInt("hunger_regeneration", 0));
            wand.setUses(wandConfig.getInt("uses", 0));
        }
        wand.setName(defaultName);
        wand.addSpells(defaultSpells);
        return wand;
    }

    public static void reset(Plugin plugin) {
        File dataFolder = plugin.getDataFolder();
        File propertiesFile = new File(dataFolder, propertiesFileName);
        propertiesFile.delete();
    }

    public static void load(Plugin plugin) {
        File dataFolder = plugin.getDataFolder();
        File propertiesFile = new File(dataFolder, propertiesFileName);
        if (!propertiesFile.exists()) {
            File oldDefaults = new File(dataFolder, propertiesFileNameDefaults);
            oldDefaults.delete();
            plugin.saveResource(propertiesFileNameDefaults, false);
            Wand.loadProperties(plugin.getResource(propertiesFileNameDefaults));
        } else {
            Wand.loadProperties(propertiesFile);
        }
    }

    protected static void loadProperties(File propertiesFile) {
        Wand.loadProperties(new Configuration(propertiesFile));
    }

    protected static void loadProperties(InputStream properties) {
        Wand.loadProperties(new Configuration(properties));
    }

    protected static void loadProperties(Configuration properties) {
        properties.load();
        wandTemplates.clear();
        ConfigurationNode wandList = properties.getNode(propertiesFileName);
        if (wandList == null) {
            return;
        }
        List<String> wandKeys = wandList.getKeys();
        for (String key : wandKeys) {
            ConfigurationNode wandNode = wandList.getNode(key);
            wandNode.setProperty("key", key);
            wandTemplates.put(key, wandNode);
        }
    }

    public static Collection<ConfigurationNode> getWandTemplates() {
        return wandTemplates.values();
    }

    protected void updateSpellSettings(PlayerSpells spells) {
        spells.setDamageReduction(this.damageReduction);
        spells.setDamageReductionPhysical(this.damageReductionPhysical);
        spells.setDamageReductionProjectiles(this.damageReductionProjectiles);
        spells.setDamageReductionFalling(this.damageReductionFalling);
        spells.setDamageReductionFire(this.damageReductionFire);
        spells.setDamageReductionExplosions(this.damageReductionExplosions);
        spells.setCostReduction(this.costReduction);
        spells.setXPRegeneration(this.xpRegeneration);
        spells.setXPMax(this.xpMax);
        spells.setHealthRegeneration(this.healthRegeneration);
        spells.setHungerRegeneration(this.hungerRegeneration);
    }

    public void activate(PlayerSpells playerSpells, int itemSlot) {
        this.updateSpellSettings(playerSpells);
        this.updateInventory(playerSpells, itemSlot);
    }

    public void activate(PlayerSpells playerSpells) {
        this.activate(playerSpells, playerSpells.getPlayer().getInventory().getHeldItemSlot());
    }

    public void deactivate(PlayerSpells spells) {
        this.saveInventory(spells);
        spells.setDamageReduction(0.0f);
        spells.setDamageReductionPhysical(0.0f);
        spells.setDamageReductionProjectiles(0.0f);
        spells.setDamageReductionFalling(0.0f);
        spells.setDamageReductionFire(0.0f);
        spells.setDamageReductionExplosions(0.0f);
        spells.setCostReduction(0.0f);
        spells.setXPRegeneration(0);
        spells.setXPMax(0);
        spells.setHealthRegeneration(0);
        spells.setHungerRegeneration(0);
    }

    public void use(PlayerSpells playerSpells) {
        if (this.uses > 0) {
            short durability = this.item.getDurability();
            if (durability >= this.uses - 1) {
                this.deactivate(playerSpells);
                playerSpells.restoreInventory();
                PlayerInventory playerInventory = playerSpells.getPlayer().getInventory();
                playerInventory.setItemInHand(new ItemStack(Material.AIR, 1));
                playerSpells.getPlayer().updateInventory();
            } else {
                this.item.setDurability((short)(durability + 1));
                this.updateActiveName(playerSpells);
                this.updateLore(this.getSpells().length, this.getMaterials().length);
            }
        }
    }
}

