/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic;

import com.elmakers.mine.bukkit.plugins.magic.PlayerSpells;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CastingCost {
    protected Material item;
    protected byte data;
    protected double amount;
    protected int xp;

    public CastingCost(ConfigurationNode config) {
        this.item = config.getMaterial("material");
        this.amount = config.getDouble("amount", 1.0);
        this.xp = config.getInt("xp", 0);
        this.data = 0;
    }

    public CastingCost(Material item, double amount) {
        this.item = item;
        this.data = 0;
        this.amount = amount;
    }

    public CastingCost(Material item, byte data, double amount) {
        this.item = item;
        this.data = data;
        this.amount = amount;
    }

    public Material getMaterial() {
        return this.item;
    }

    public Map<String, Object> export() {
        HashMap<String, Object> cost = new HashMap<String, Object>();
        cost.put("material", this.item.name().toLowerCase());
        cost.put("amount", this.amount);
        cost.put("xp", this.xp);
        return cost;
    }

    public boolean has(PlayerSpells playerSpells) {
        Player player = playerSpells.getPlayer();
        Inventory inventory = playerSpells.getInventory();
        boolean hasItem = this.item == null || inventory.contains(this.item, this.getAmount(playerSpells));
        boolean hasXp = this.xp <= 0 || player.getTotalExperience() >= this.getXP(playerSpells);
        return hasItem && hasXp;
    }

    public void use(PlayerSpells playerSpells) {
        Player player = playerSpells.getPlayer();
        Inventory inventory = playerSpells.getInventory();
        if (this.item != null) {
            ItemStack itemStack = this.getItemStack();
            inventory.removeItem(new ItemStack[]{itemStack});
        }
        int xp = this.getXP(playerSpells);
        if (this.getXP(playerSpells) > 0) {
            CastingCost.removeExperience(player, xp);
        }
    }

    public static void removeExperience(Player player, int amount) {
        int currentExperience = player.getTotalExperience();
        player.setTotalExperience(0);
        player.setLevel(0);
        player.setExp(0.0f);
        player.giveExp(Math.max(0, currentExperience - amount));
    }

    protected ItemStack getItemStack() {
        return new ItemStack(this.item, this.getAmount(), 0, Byte.valueOf(this.data));
    }

    protected int getAmount() {
        return (int)Math.ceil(this.amount);
    }

    protected int getXP() {
        return this.xp;
    }

    protected int getAmount(PlayerSpells spells) {
        double reducedAmount = this.amount;
        float reduction = spells.getCostReduction();
        if (reduction > 0.0f) {
            reducedAmount = (double)(1.0f - reduction) * reducedAmount;
        }
        return (int)Math.ceil(reducedAmount);
    }

    protected int getXP(PlayerSpells spells) {
        float reducedAmount = this.xp;
        float reduction = spells.getCostReduction();
        if (reduction > 0.0f) {
            reducedAmount = (1.0f - reduction) * reducedAmount;
        }
        return (int)Math.ceil(reducedAmount);
    }

    public boolean hasCosts(PlayerSpells spells) {
        return this.item != null && this.getAmount(spells) > 0 || this.getXP(spells) > 0;
    }

    public String getDescription() {
        if (this.item != null && this.getAmount() != 0) {
            return this.item.name().toLowerCase().replace("_", " ").replace(" block", "");
        }
        return "XP";
    }

    public String getFullDescription(PlayerSpells spells) {
        if (this.item != null) {
            return this.getAmount(spells) + " " + this.item.name().toLowerCase().replace("_", " ").replace(" block", "");
        }
        return this.getXP(spells) + " XP";
    }
}

