/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic;

import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CastingCost {
    protected Material item;
    protected byte data;
    protected double amount;

    public CastingCost(ConfigurationNode config) {
        this.item = config.getMaterial("material");
        this.amount = config.getDouble("amount", 1.0);
        this.data = 0;
    }

    public CastingCost(Material item, double amount) {
        this.item = item;
        this.data = 0;
        this.amount = amount;
    }

    public CastingCost(Material item, byte data, double amount) {
        this.item = item;
        this.data = data;
        this.amount = amount;
    }

    public Map<String, Object> export() {
        HashMap<String, Object> cost = new HashMap<String, Object>();
        cost.put("material", this.item.name().toLowerCase());
        cost.put("amount", this.amount);
        return cost;
    }

    public boolean has(Player player, Inventory inventory) {
        return inventory.contains(this.item, this.getAmount());
    }

    public void use(Player player, Inventory inventory) {
        ItemStack itemStack = this.getItemStack();
        inventory.removeItem(new ItemStack[]{itemStack});
    }

    protected ItemStack getItemStack() {
        return new ItemStack(this.item, this.getAmount(), 0, Byte.valueOf(this.data));
    }

    protected int getAmount() {
        return (int)Math.ceil(this.amount);
    }

    public String getDescription() {
        return this.item.name().toLowerCase().replace("_", " ").replace(" block", "");
    }
}

