/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spells;

import com.elmakers.mine.bukkit.dao.BlockList;
import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;

public class CushionSpell
extends Spell {
    private int cushionWidth = 3;
    private int cushionHeight = 4;

    public boolean onCast(ConfigurationNode parameters) {
        World world = this.player.getWorld();
        Block targetFace = this.getTargetBlock();
        if (targetFace == null) {
            this.castMessage(this.player, "No target");
            return false;
        }
        this.castMessage(this.player, "Happy landings");
        BlockList cushionBlocks = new BlockList();
        cushionBlocks.setTimeToLive(7000);
        this.spells.disablePhysics(8000);
        int bubbleStart = -this.cushionWidth / 2;
        int bubbleEnd = this.cushionWidth / 2;
        int dx = bubbleStart;
        while (dx < bubbleEnd) {
            int dz = bubbleStart;
            while (dz < bubbleEnd) {
                int dy = 0;
                while (dy < this.cushionHeight) {
                    int z;
                    int y;
                    int x = targetFace.getX() + dx;
                    Block block = world.getBlockAt(x, y = targetFace.getY() + dy, z = targetFace.getZ() + dz);
                    if (block.getType() == Material.AIR) {
                        cushionBlocks.add(block);
                        block.setType(Material.STATIONARY_WATER);
                    }
                    ++dy;
                }
                ++dz;
            }
            ++dx;
        }
        this.spells.scheduleCleanup(cushionBlocks);
        return true;
    }

    public void onLoad(ConfigurationNode properties) {
        this.cushionWidth = properties.getInteger("width", this.cushionWidth);
        this.cushionHeight = properties.getInteger("height", this.cushionHeight);
    }
}

