/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic;

import com.elmakers.mine.bukkit.plugins.magic.PlayerSpells;
import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.utilities.InventoryUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Wand {
    private ItemStack item;
    private String wandSettings;
    private String wandSpells;
    private String wandMaterials;
    private static Material WandMaterial = Material.STICK;
    public static Material EraseMaterial = Material.SULPHUR;

    public Wand() {
        this.item = new ItemStack(WandMaterial);
        this.item = InventoryUtils.getCopy(this.item);
        ItemMeta itemMeta = this.item.getItemMeta();
        this.item.setItemMeta(itemMeta);
        InventoryUtils.addGlow(this.item);
        this.wandSettings = " ";
        this.wandSpells = "";
        this.wandMaterials = "";
        this.saveState();
    }

    public Wand(ItemStack item) {
        this.item = item;
        this.loadState();
    }

    protected void saveState() {
        InventoryUtils.setMeta(this.item, "magic_wand", this.wandSettings);
        InventoryUtils.setMeta(this.item, "magic_materials", this.wandMaterials);
        InventoryUtils.setMeta(this.item, "magic_spells", this.wandSpells);
    }

    protected void loadState() {
        this.wandSettings = InventoryUtils.getMeta(this.item, "magic_wand");
        this.wandSettings = this.wandSettings == null ? "" : this.wandSettings;
        this.wandMaterials = InventoryUtils.getMeta(this.item, "magic_materials");
        this.wandMaterials = this.wandMaterials == null ? "" : this.wandMaterials;
        this.wandSpells = InventoryUtils.getMeta(this.item, "magic_spells");
        this.wandSpells = this.wandSpells == null ? "" : this.wandSpells;
    }

    public ItemStack getItem() {
        return this.item;
    }

    public void removeMaterial(Material material, byte data) {
        Integer id = material.getId();
        String materialString = id.toString();
        materialString = String.valueOf(materialString) + ":" + data;
        String[] materials = this.getMaterials();
        LinkedList<String> materialMap = new LinkedList<String>();
        int i = 0;
        while (i < materials.length) {
            String[] pieces = StringUtils.split((String)materials[i], (String)"@");
            if (!pieces[0].equals(materialString)) {
                materialMap.add(materials[i]);
            }
            ++i;
        }
        this.setMaterials(materialMap);
    }

    public void addMaterial(Material material, int data) {
        this.addMaterial(material, (byte)data);
    }

    public void addMaterial(Material material) {
        this.addMaterial(material, 0);
    }

    public void addMaterial(Material material, byte data) {
        Integer id = material.getId();
        String materialString = id.toString();
        materialString = String.valueOf(materialString) + ":" + data;
        String[] materials = this.getMaterials();
        LinkedList<String> materialMap = new LinkedList<String>();
        int i = 0;
        while (i < materials.length) {
            String[] pieces = StringUtils.split((String)materials[i], (String)"@");
            if (!pieces[0].equals(materialString)) {
                materialMap.add(materials[i]);
            }
            ++i;
        }
        materialMap.add(materialString);
        this.setMaterials(materialMap);
    }

    protected void setMaterials(Collection<String> materialNames) {
        this.wandMaterials = StringUtils.join(materialNames, (String)"|");
        this.setMaterialCount(materialNames.size());
        this.saveState();
    }

    public String[] getMaterials() {
        return StringUtils.split((String)this.wandMaterials, (String)"|");
    }

    public void addSpells(Collection<String> spellNames) {
        String[] spells = this.getSpells();
        LinkedList<String> spellMap = new LinkedList<String>();
        String[] stringArray = spells;
        int n = spells.length;
        int n2 = 0;
        while (n2 < n) {
            String spell = stringArray[n2];
            spellMap.add(spell);
            String[] pieces = StringUtils.split((String)spell, (String)"@");
            spellNames.remove(pieces[0]);
            ++n2;
        }
        for (String spellName : spellNames) {
            spellMap.add(spellName);
        }
        this.setSpells(spellMap);
    }

    public String[] getSpells() {
        return StringUtils.split((String)this.wandSpells, (String)"|");
    }

    public void removeSpell(String spellName) {
        String[] spells = this.getSpells();
        LinkedList<String> spellMap = new LinkedList<String>();
        int i = 0;
        while (i < spells.length) {
            String[] pieces = StringUtils.split((String)spells[i], (String)"@");
            if (!pieces[0].equals(spellName)) {
                spellMap.add(spells[i]);
            }
            ++i;
        }
        this.setSpells(spellMap);
    }

    public void addSpell(String spellName) {
        ArrayList<String> names = new ArrayList<String>();
        names.add(spellName);
        this.addSpells(names);
    }

    public void setSpells(Collection<String> spellNames) {
        this.wandSpells = StringUtils.join(spellNames, (String)"|");
        this.setSpellCount(spellNames.size());
        this.saveState();
    }

    public void setSpellCount(int spellCount) {
        this.updateLore(spellCount, this.getMaterials().length);
    }

    public void setMaterialCount(int materialCount) {
        this.updateLore(this.getSpells().length, materialCount);
    }

    public void setName(String name) {
        ItemMeta meta = this.item.getItemMeta();
        meta.setDisplayName(name);
        this.item.setItemMeta(meta);
        InventoryUtils.addGlow(this.item);
        this.saveState();
    }

    protected void updateLore(int spellCount, int materialCount) {
        ItemMeta meta = this.item.getItemMeta();
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("Knows " + spellCount + " Spells");
        if (materialCount > 0) {
            lore.add("Has " + materialCount + " Materials");
        }
        meta.setLore(lore);
        this.item.setItemMeta(meta);
        InventoryUtils.addGlow(this.item);
        this.saveState();
    }

    public static Wand getActiveWand(Player player) {
        ItemStack activeItem = player.getInventory().getItemInHand();
        return Wand.isWand(activeItem) ? new Wand(activeItem) : null;
    }

    public static boolean hasActiveWand(Player player) {
        ItemStack activeItem = player.getInventory().getItemInHand();
        return Wand.isWand(activeItem);
    }

    public static boolean isWand(ItemStack item) {
        return item != null && item.getType() == Material.STICK && InventoryUtils.getMeta(item, "magic_wand").length() > 0;
    }

    public static boolean isSpell(ItemStack item) {
        return item != null && item.getType() != Material.STICK && InventoryUtils.getMeta(item, "magic_spell").length() > 0;
    }

    public void updateInventory(PlayerSpells playerSpells) {
        this.updateInventory(playerSpells, playerSpells.getPlayer().getInventory().getHeldItemSlot());
    }

    /*
     * WARNING - void declaration
     */
    protected void updateInventory(PlayerSpells playerSpells, int itemSlot) {
        void var10_14;
        Player player = playerSpells.getPlayer();
        PlayerInventory inventory = player.getInventory();
        inventory.clear();
        inventory.setItem(itemSlot, this.item);
        String[] spells = StringUtils.split((String)this.wandSpells, (String)"|");
        ArrayList<ItemStack> unpositioned = new ArrayList<ItemStack>();
        int i = 0;
        while (i < spells.length) {
            String[] parts = StringUtils.split((String)spells[i], (String)"@");
            String spellName = parts[0];
            Spell spell = playerSpells.getSpell(spellName);
            if (spell != null) {
                int slot;
                ItemStack itemStack = new ItemStack(spell.getMaterial(), 1);
                itemStack = InventoryUtils.getCopy(itemStack);
                ItemMeta meta = itemStack.getItemMeta();
                meta.setDisplayName(spell.getName());
                ArrayList<String> lore = new ArrayList<String>();
                lore.add(spell.getCategory());
                lore.add(spell.getDescription());
                meta.setLore(lore);
                itemStack.setItemMeta(meta);
                InventoryUtils.addGlow(itemStack);
                InventoryUtils.setMeta(itemStack, "magic_spell", spells[i]);
                int n = slot = parts.length > 1 ? Integer.parseInt(parts[1]) : itemSlot;
                if (parts.length > 1 && slot != itemSlot) {
                    inventory.setItem(slot, itemStack);
                } else {
                    unpositioned.add(itemStack);
                }
            }
            ++i;
        }
        for (ItemStack stack : unpositioned) {
            inventory.addItem(new ItemStack[]{stack});
        }
        String[] materials = StringUtils.split((String)this.wandMaterials, (String)"|");
        unpositioned.clear();
        HashMap<Integer, ItemStack> positioned = new HashMap<Integer, ItemStack>();
        ItemStack eraseStack = null;
        boolean bl = false;
        while (var10_14 < materials.length) {
            ArrayList<String> lore;
            String[] parts = StringUtils.split((String)materials[var10_14], (String)"@");
            String[] nameParts = StringUtils.split((String)parts[0], (String)":");
            int typeId = Integer.parseInt(nameParts[0]);
            if (typeId == 0) {
                typeId = EraseMaterial.getId();
            }
            int dataId = nameParts.length > 1 ? Integer.parseInt(nameParts[1]) : 0;
            ItemStack itemStack = new ItemStack(typeId, 1, 0, Byte.valueOf((byte)dataId));
            itemStack = InventoryUtils.getCopy(itemStack);
            ItemMeta meta = itemStack.getItemMeta();
            if (typeId == EraseMaterial.getId()) {
                meta.setDisplayName("Erase");
                lore = new ArrayList();
                lore.add("Fills with Air");
                meta.setLore(lore);
            } else {
                lore = new ArrayList<String>();
                lore.add("Magic building material");
                meta.setLore(lore);
            }
            itemStack.setItemMeta(meta);
            int slot = parts.length > 1 ? Integer.parseInt(parts[1]) : itemSlot;
            ItemStack existing = inventory.getItem(slot);
            if (parts.length > 1 && slot != itemSlot && (existing == null || existing.getType() == Material.AIR)) {
                positioned.put(slot, itemStack);
            } else if (itemStack.getType() == EraseMaterial) {
                eraseStack = itemStack;
            } else {
                unpositioned.add(itemStack);
            }
            ++var10_14;
        }
        if (eraseStack != null) {
            Wand.addMaterialToInventory((Inventory)inventory, eraseStack);
        }
        for (ItemStack itemStack : unpositioned) {
            Wand.addMaterialToInventory((Inventory)inventory, itemStack);
        }
        for (Map.Entry entry : positioned.entrySet()) {
            int slot = (Integer)entry.getKey();
            ItemStack itemStack = (ItemStack)entry.getValue();
            ItemStack existing = inventory.getItem(slot);
            if (slot != itemSlot && (existing == null || existing.getType() == Material.AIR)) {
                inventory.setItem(slot, itemStack);
                continue;
            }
            Wand.addMaterialToInventory((Inventory)inventory, itemStack);
        }
        player.updateInventory();
    }

    protected static void addMaterialToInventory(Inventory inventory, ItemStack stack) {
        int i = 8;
        while (i >= 0) {
            ItemStack existing = inventory.getItem(i);
            if (existing == null || existing.getType() == Material.AIR) {
                inventory.setItem(i, stack);
                return;
            }
            --i;
        }
        inventory.addItem(new ItemStack[]{stack});
    }

    public void saveInventory(PlayerSpells playerSpells) {
        PlayerInventory inventory = playerSpells.getPlayer().getInventory();
        ItemStack[] items = inventory.getContents();
        ArrayList<String> spellNames = new ArrayList<String>();
        ArrayList<String> materialNames = new ArrayList<String>();
        int i = 0;
        while (i < items.length) {
            if (items[i] != null) {
                Material material = items[i].getType();
                if (Wand.isSpell(items[i])) {
                    Spell spell = playerSpells.getSpell(material);
                    if (spell != null) {
                        spellNames.add(String.valueOf(spell.getKey()) + "@" + i);
                    }
                } else {
                    List<Material> buildingMaterials = playerSpells.getMaster().getBuildingMaterials();
                    if (material != Material.AIR && (buildingMaterials.contains(material) || material == EraseMaterial)) {
                        String materialkey = material == EraseMaterial ? "0:0" : String.valueOf(material.getId()) + ":" + items[i].getData().getData();
                        materialNames.add(String.valueOf(materialkey) + "@" + i);
                    }
                }
            }
            ++i;
        }
        this.setSpells(spellNames);
        this.setMaterials(materialNames);
        this.saveState();
    }

    public static boolean isActive(Player player) {
        ItemStack activeItem = player.getInventory().getItemInHand();
        return Wand.isWand(activeItem);
    }

    public static Wand createWand(String templateName) {
        Wand wand = new Wand();
        ArrayList<String> defaultSpells = new ArrayList<String>();
        String defaultName = "Wand";
        if (templateName.equals("demo")) {
            defaultSpells.add("torch");
            defaultSpells.add("fling");
            defaultSpells.add("blink");
            defaultName = "Demo Wand";
        } else if (templateName.equals("engineer")) {
            defaultSpells.add("fill");
            defaultSpells.add("pillar");
            defaultSpells.add("bridge");
            defaultSpells.add("absorb");
            wand.addMaterial(Material.STONE);
            wand.addMaterial(Material.DIRT);
            wand.addMaterial(Material.WOOD);
            wand.addMaterial(Material.GLASS);
            wand.addMaterial(Material.WOOD, 1);
            wand.addMaterial(Material.WOOD, 2);
            wand.addMaterial(Material.WOOD, 3);
            defaultName = "Engineering Wand";
        }
        wand.setName(defaultName);
        wand.addSpells(defaultSpells);
        return wand;
    }
}

