/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic;

import com.elmakers.mine.bukkit.plugins.magic.PlayerSpells;
import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.utilities.InventoryUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Wand {
    private ItemStack item;
    private static Material WandMaterial = Material.STICK;

    public Wand() {
        this.item = new ItemStack(WandMaterial);
        this.item = InventoryUtils.getCopy(this.item);
        ItemMeta itemMeta = this.item.getItemMeta();
        this.item.setItemMeta(itemMeta);
        InventoryUtils.addGlow(this.item);
        InventoryUtils.setMeta(this.item, "magic_wand", "");
    }

    public Wand(ItemStack item) {
        this.item = item;
    }

    public ItemStack getItem() {
        return this.item;
    }

    public void removeMaterial(Material material, byte data) {
        Integer id = material.getId();
        String materialString = id.toString();
        if (data > 0) {
            materialString = String.valueOf(materialString) + ":" + data;
        }
        String[] materials = this.getMaterials();
        TreeSet<String> materialMap = new TreeSet<String>();
        int i = 0;
        while (i < materials.length) {
            materialMap.add(materials[i]);
            ++i;
        }
        materialMap.remove(materialString);
        this.setMaterials(materialMap);
    }

    public void addMaterial(Material material, byte data) {
        Integer id = material.getId();
        String materialString = id.toString();
        if (data > 0) {
            materialString = String.valueOf(materialString) + ":" + data;
        }
        String[] materials = this.getMaterials();
        TreeSet<String> materialMap = new TreeSet<String>();
        int i = 0;
        while (i < materials.length) {
            materialMap.add(materials[i]);
            ++i;
        }
        materialMap.add(materialString);
        this.setMaterials(materialMap);
    }

    protected void setMaterials(Collection<String> materialNames) {
        String spellString = StringUtils.join(materialNames, (String)"|");
        this.setMaterialCount(materialNames.size());
        InventoryUtils.setMeta(this.item, "magic_materials", spellString);
    }

    public String[] getMaterials() {
        String materialsString = InventoryUtils.getMeta(this.item, "magic_materials");
        if (materialsString == null) {
            materialsString = "";
        }
        return StringUtils.split((String)materialsString, (String)"|");
    }

    public void addSpells(Collection<String> spellNames) {
        String[] spells = this.getSpells();
        TreeSet<String> spellMap = new TreeSet<String>();
        String[] stringArray = spells;
        int n = spells.length;
        int n2 = 0;
        while (n2 < n) {
            String spell = stringArray[n2];
            spellMap.add(spell);
            ++n2;
        }
        for (String spellName : spellNames) {
            spellMap.add(spellName);
        }
        this.setSpells(spellMap);
    }

    public String[] getSpells() {
        String spellString = InventoryUtils.getMeta(this.item, "magic_spells");
        if (spellString == null) {
            spellString = "";
        }
        return StringUtils.split((String)spellString, (String)"|");
    }

    public void removeSpell(String spellName) {
        String[] spells = this.getSpells();
        TreeSet<String> spellMap = new TreeSet<String>();
        int i = 0;
        while (i < spells.length) {
            spellMap.add(spells[i]);
            ++i;
        }
        spellMap.remove(spellName);
        this.setSpells(spellMap);
    }

    public void addSpell(String spellName) {
        ArrayList<String> names = new ArrayList<String>();
        names.add(spellName);
        this.addSpells(names);
    }

    public void setSpells(Collection<String> spellNames) {
        String spellString = StringUtils.join(spellNames, (String)"|");
        this.setSpellCount(spellNames.size());
        InventoryUtils.setMeta(this.item, "magic_spells", spellString);
    }

    public void setSpellCount(int spellCount) {
        this.updateLore(spellCount, this.getMaterials().length);
    }

    public void setMaterialCount(int materialCount) {
        this.updateLore(this.getSpells().length, materialCount);
    }

    public void setName(String name) {
        String spellString = InventoryUtils.getMeta(this.item, "magic_spells");
        String wandString = InventoryUtils.getMeta(this.item, "magic_wand");
        ItemMeta meta = this.item.getItemMeta();
        meta.setDisplayName(name);
        this.item.setItemMeta(meta);
        InventoryUtils.addGlow(this.item);
        InventoryUtils.setMeta(this.item, "magic_spells", spellString);
        InventoryUtils.setMeta(this.item, "magic_wand", wandString);
    }

    protected void updateLore(int spellCount, int materialCount) {
        String spellString = InventoryUtils.getMeta(this.item, "magic_spells");
        String wandString = InventoryUtils.getMeta(this.item, "magic_wand");
        ItemMeta meta = this.item.getItemMeta();
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("Knows " + spellCount + " Spells");
        if (materialCount > 0) {
            lore.add("Has " + materialCount + " Materials");
        }
        lore.add("Left-click to cast active spell");
        lore.add("Right-click to cycle spells");
        meta.setLore(lore);
        this.item.setItemMeta(meta);
        InventoryUtils.addGlow(this.item);
        InventoryUtils.setMeta(this.item, "magic_spells", spellString);
        InventoryUtils.setMeta(this.item, "magic_wand", wandString);
    }

    public static Wand getActiveWand(Player player) {
        ItemStack activeItem = player.getInventory().getItemInHand();
        return Wand.isWand(activeItem) ? new Wand(activeItem) : null;
    }

    public static boolean hasActiveWand(Player player) {
        ItemStack activeItem = player.getInventory().getItemInHand();
        return Wand.isWand(activeItem);
    }

    public static boolean isWand(ItemStack item) {
        return item != null && item.getType() == Material.STICK && InventoryUtils.getMeta(item, "magic_wand") != null;
    }

    public static boolean isSpell(ItemStack item) {
        return item != null && item.getType() != Material.STICK && InventoryUtils.getMeta(item, "magic_spell") != null;
    }

    public void updateInventory(PlayerSpells playerSpells) {
        this.updateInventory(playerSpells, playerSpells.getPlayer().getInventory().getHeldItemSlot());
    }

    protected void updateInventory(PlayerSpells playerSpells, int itemSlot) {
        Player player = playerSpells.getPlayer();
        PlayerInventory inventory = player.getInventory();
        inventory.clear();
        inventory.setItem(itemSlot, this.item);
        String spellString = InventoryUtils.getMeta(this.item, "magic_spells");
        String[] spells = StringUtils.split((String)spellString, (String)"|");
        ArrayList<ItemStack> unpositioned = new ArrayList<ItemStack>();
        int i = 0;
        while (i < spells.length) {
            String[] parts = StringUtils.split((String)spells[i], (String)"@");
            String spellName = parts[0];
            Spell spell = playerSpells.getSpell(spellName);
            if (spell != null) {
                int slot;
                ItemStack itemStack = new ItemStack(spell.getMaterial(), 1);
                itemStack = InventoryUtils.getCopy(itemStack);
                ItemMeta meta = itemStack.getItemMeta();
                meta.setDisplayName(spell.getName());
                ArrayList<String> lore = new ArrayList<String>();
                lore.add(spell.getCategory());
                lore.add(spell.getDescription());
                meta.setLore(lore);
                itemStack.setItemMeta(meta);
                InventoryUtils.addGlow(itemStack);
                InventoryUtils.setMeta(itemStack, "magic_spell", spells[i]);
                int n = slot = parts.length > 1 ? Integer.parseInt(parts[1]) : itemSlot;
                if (parts.length > 1 && slot != itemSlot) {
                    inventory.setItem(slot, itemStack);
                } else {
                    unpositioned.add(itemStack);
                }
            }
            ++i;
        }
        for (ItemStack stack : unpositioned) {
            inventory.addItem(new ItemStack[]{stack});
        }
        String materialString = InventoryUtils.getMeta(this.item, "magic_materials");
        String[] materials = StringUtils.split((String)materialString, (String)"|");
        unpositioned.clear();
        int i2 = 0;
        while (i2 < materials.length) {
            int slot;
            String[] parts = StringUtils.split((String)materials[i2], (String)"@");
            String[] nameParts = StringUtils.split((String)parts[0], (String)":");
            int typeId = Integer.parseInt(nameParts[0]);
            int dataId = nameParts.length > 1 ? Integer.parseInt(nameParts[1]) : 0;
            ItemStack itemStack = new ItemStack(typeId, 1, 0, Byte.valueOf((byte)dataId));
            itemStack = InventoryUtils.getCopy(itemStack);
            ItemMeta meta = itemStack.getItemMeta();
            ArrayList<String> lore = new ArrayList<String>();
            lore.add("Magic building material");
            meta.setLore(lore);
            itemStack.setItemMeta(meta);
            int n = slot = parts.length > 1 ? Integer.parseInt(parts[1]) : itemSlot;
            if (parts.length > 1 && slot != itemSlot) {
                inventory.setItem(slot, itemStack);
            } else {
                unpositioned.add(itemStack);
            }
            ++i2;
        }
        for (ItemStack stack : unpositioned) {
            Wand.addMaterialToInventory((Inventory)inventory, stack);
        }
        player.updateInventory();
    }

    protected static void addMaterialToInventory(Inventory inventory, ItemStack stack) {
        int i = 8;
        while (i >= 0) {
            ItemStack existing = inventory.getItem(i);
            if (existing == null || existing.getType() == Material.AIR) {
                inventory.setItem(i, stack);
                return;
            }
            --i;
        }
        inventory.addItem(new ItemStack[]{stack});
    }

    public void saveInventory(PlayerSpells playerSpells) {
        PlayerInventory inventory = playerSpells.getPlayer().getInventory();
        ItemStack[] items = inventory.getContents();
        ArrayList<String> spellNames = new ArrayList<String>();
        ArrayList<String> materialNames = new ArrayList<String>();
        int i = 0;
        while (i < items.length) {
            if (items[i] != null && Wand.isSpell(items[i])) {
                Material material = items[i].getType();
                Spell spell = playerSpells.getSpell(material);
                if (spell == null) {
                    List<Material> buildingMaterials = playerSpells.getMaster().getBuildingMaterials();
                    if (material != Material.AIR && buildingMaterials.contains(material)) {
                        materialNames.add(String.valueOf(material.getId()) + "@" + i);
                    }
                } else {
                    spellNames.add(String.valueOf(spell.getKey()) + "@" + i);
                }
            }
            ++i;
        }
        this.setSpells(spellNames);
        this.setMaterials(materialNames);
    }

    public static boolean isActive(Player player) {
        ItemStack activeItem = player.getInventory().getItemInHand();
        return Wand.isWand(activeItem);
    }

    public static Wand createWand(String templateName) {
        Wand wand = new Wand();
        ArrayList<String> defaultSpells = new ArrayList<String>();
        String defaultName = "Wand";
        if (templateName.equals("demo")) {
            defaultSpells.add("torch");
            defaultSpells.add("fling");
            defaultSpells.add("blink");
            defaultName = "Demo Wand";
        } else if (templateName.equals("engineer")) {
            defaultSpells.add("fill");
            defaultSpells.add("pillar");
            defaultSpells.add("bridge");
            defaultSpells.add("absorb");
            defaultName = "Engineering Wand";
        }
        wand.setName(defaultName);
        wand.addSpells(defaultSpells);
        return wand;
    }
}

