/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic;

import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.plugins.magic.SpellEventType;
import com.elmakers.mine.bukkit.utilities.InventoryUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public class PlayerSpells {
    protected Player player;
    protected HashMap<String, Spell> spells = new HashMap();
    private Inventory storedInventory = null;
    private final List<Spell> movementListeners = new ArrayList<Spell>();
    private final List<Spell> quitListeners = new ArrayList<Spell>();
    private final List<Spell> deathListeners = new ArrayList<Spell>();
    private final List<Spell> damageListeners = new ArrayList<Spell>();

    public boolean hasStoredInventory() {
        return this.storedInventory != null;
    }

    public Inventory getStoredInventory() {
        return this.storedInventory;
    }

    public void clearStoredInventory() {
        this.storedInventory = null;
    }

    public boolean addToStoredInventory(ItemStack item) {
        if (this.storedInventory == null) {
            return false;
        }
        HashMap remainder = this.storedInventory.addItem(new ItemStack[]{item});
        for (ItemStack remains : remainder.values()) {
            this.player.getWorld().dropItemNaturally(this.player.getLocation(), remains);
        }
        return true;
    }

    public boolean storeInventory(int keepSlot, ItemStack keepItem) {
        PlayerInventory inventory = this.player.getInventory();
        if (this.storedInventory != null) {
            return false;
        }
        if (keepItem != null) {
            inventory.clear(keepSlot);
        }
        this.storedInventory = InventoryUtils.createInventory(null, inventory.getSize(), "Magic.Wand.StoredInventory");
        this.storedInventory.setContents(inventory.getContents());
        inventory.clear();
        if (keepItem != null) {
            inventory.setItem(keepSlot, keepItem);
        }
        this.player.updateInventory();
        return true;
    }

    public boolean storeInventory() {
        return this.storeInventory(this.player.getInventory().getHeldItemSlot(), this.player.getInventory().getItemInHand());
    }

    public boolean restoreInventory() {
        return this.restoreInventory(this.player.getInventory().getHeldItemSlot(), this.player.getInventory().getItemInHand());
    }

    public boolean restoreInventory(int keepSlot, ItemStack keepItem) {
        if (this.storedInventory == null) {
            return false;
        }
        PlayerInventory inventory = this.player.getInventory();
        inventory.setContents(this.storedInventory.getContents());
        this.storedInventory = null;
        if (keepItem != null) {
            ItemStack occupied = inventory.getItem(keepSlot);
            inventory.setItem(keepSlot, keepItem);
            if (occupied != null) {
                HashMap remainder = inventory.addItem(new ItemStack[]{occupied});
                for (ItemStack remains : remainder.values()) {
                    this.player.getWorld().dropItemNaturally(this.player.getLocation(), remains);
                }
            }
        }
        this.player.updateInventory();
        return true;
    }

    public void registerEvent(SpellEventType type, Spell spell) {
        switch (type) {
            case PLAYER_MOVE: {
                if (this.movementListeners.contains(spell)) break;
                this.movementListeners.add(spell);
                break;
            }
            case PLAYER_QUIT: {
                if (this.quitListeners.contains(spell)) break;
                this.quitListeners.add(spell);
                break;
            }
            case PLAYER_DAMAGE: {
                if (this.damageListeners.contains(spell)) break;
                this.damageListeners.add(spell);
                break;
            }
            case PLAYER_DEATH: {
                if (this.deathListeners.contains(spell)) break;
                this.deathListeners.add(spell);
            }
        }
    }

    public void setPlayer(Player player) {
        this.player = player;
    }

    public void unregisterEvent(SpellEventType type, Spell spell) {
        switch (type) {
            case PLAYER_MOVE: {
                this.movementListeners.remove(spell);
                break;
            }
            case PLAYER_DAMAGE: {
                this.damageListeners.remove(spell);
                break;
            }
            case PLAYER_QUIT: {
                this.quitListeners.remove(spell);
                break;
            }
            case PLAYER_DEATH: {
                this.deathListeners.remove(spell);
            }
        }
    }

    public PlayerSpells(Player player) {
        this.player = player;
    }

    public Spell getSpell(String name) {
        return this.spells.get(name);
    }

    protected void addSpell(Spell spell) {
        this.spells.put(spell.getName(), spell);
    }

    public void cancel() {
        for (Spell spell : this.spells.values()) {
            spell.cancel();
        }
    }

    public void onPlayerQuit(PlayerQuitEvent event) {
        ArrayList<Spell> active = new ArrayList<Spell>();
        active.addAll(this.quitListeners);
        for (Spell listener : active) {
            listener.onPlayerQuit(event);
        }
    }

    public void onPlayerMove(PlayerMoveEvent event) {
        ArrayList<Spell> active = new ArrayList<Spell>();
        active.addAll(this.movementListeners);
        for (Spell listener : active) {
            listener.onPlayerMove(event);
        }
    }

    public void onPlayerDeath(EntityDeathEvent event) {
        ArrayList<Spell> active = new ArrayList<Spell>();
        active.addAll(this.deathListeners);
        for (Spell listener : active) {
            if (this.player != listener.getPlayer()) continue;
            listener.onPlayerDeath(event);
        }
    }

    public void onPlayerDamage(EntityDamageEvent event) {
        ArrayList<Spell> active = new ArrayList<Spell>();
        active.addAll(this.damageListeners);
        for (Spell listener : active) {
            listener.onPlayerDamage(event);
        }
    }
}

