/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic;

import com.elmakers.mine.bukkit.plugins.magic.PlayerSpells;
import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.plugins.magic.SpellGroup;
import com.elmakers.mine.bukkit.plugins.magic.Spells;
import com.elmakers.mine.bukkit.utilities.InventoryUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class MagicPlugin
extends JavaPlugin {
    private final Spells spells = new Spells();
    private final Logger log = Logger.getLogger("Minecraft");

    public Spells getSpells() {
        return this.spells;
    }

    public void onEnable() {
        this.initialize();
        PluginManager pm = this.getServer().getPluginManager();
        pm.registerEvents((Listener)this.spells, (Plugin)this);
        PluginDescriptionFile pdfFile = this.getDescription();
        this.log.info(String.valueOf(pdfFile.getName()) + " version " + pdfFile.getVersion() + " is enabled");
    }

    protected void initialize() {
        this.spells.initialize(this);
    }

    public boolean onCommand(CommandSender sender, Command cmd, String commandLabel, String[] args) {
        String commandName = cmd.getName();
        if (commandName.equalsIgnoreCase("magic") && args.length > 0) {
            String subCommand = args[0];
            if (sender instanceof Player && !this.spells.hasPermission((Player)sender, "Magic.commands.magic." + subCommand)) {
                return true;
            }
            if (subCommand.equalsIgnoreCase("reload")) {
                this.spells.clear();
                this.spells.load();
                return true;
            }
            if (subCommand.equalsIgnoreCase("reset")) {
                this.spells.reset();
                return true;
            }
        }
        if (!(sender instanceof Player)) {
            return false;
        }
        Player player = (Player)sender;
        if (commandName.equalsIgnoreCase("wand")) {
            String subCommand = "";
            String[] args2 = args;
            if (args.length > 0) {
                subCommand = args[0];
                args2 = new String[args.length - 1];
                int i = 1;
                while (i < args.length) {
                    args2[i - 1] = args[i];
                    ++i;
                }
            }
            if (subCommand.equalsIgnoreCase("add")) {
                if (!this.spells.hasPermission(player, "Magic.commands.wand." + subCommand)) {
                    return true;
                }
                this.onWandAdd(player, args2);
                return true;
            }
            if (subCommand.equalsIgnoreCase("remove")) {
                if (!this.spells.hasPermission(player, "Magic.commands.wand." + subCommand)) {
                    return true;
                }
                this.onWandRemove(player, args2);
                return true;
            }
            if (subCommand.equalsIgnoreCase("name")) {
                if (!this.spells.hasPermission(player, "Magic.commands.wand." + subCommand)) {
                    return true;
                }
                this.onWandName(player, args2);
                return true;
            }
            if (!this.spells.hasPermission(player, "Magic.commands.wand")) {
                return true;
            }
            return this.onWand(player, args);
        }
        if (commandName.equalsIgnoreCase("cast")) {
            if (!this.spells.hasPermission(player, "Magic.commands.cast")) {
                return true;
            }
            return this.onCast(player, args);
        }
        if (commandName.equalsIgnoreCase("spells")) {
            if (!this.spells.hasPermission(player, "Magic.commands.spells")) {
                return true;
            }
            return this.onSpells(player, args);
        }
        return false;
    }

    public boolean onWandAdd(Player player, String[] parameters) {
        boolean holdingWand = Spells.isWandActive(player);
        if (!holdingWand) {
            player.sendMessage("Equip a wand first (use /wand if needed)");
            return true;
        }
        if (parameters.length < 1) {
            player.sendMessage("Use: /wand add <spell>");
            return true;
        }
        String spellName = parameters[0];
        Spell spell = this.spells.getSpell(spellName, player);
        if (spell == null) {
            player.sendMessage("Spell '" + spellName + "' unknown, Use /spells for spell list");
            return true;
        }
        PlayerInventory inventory = player.getInventory();
        int wandSlot = inventory.getHeldItemSlot();
        ItemStack newWand = this.addSpellToWand(player, spell, inventory.getItemInHand());
        inventory.setItem(wandSlot, newWand);
        this.spells.updateWandInventory(player);
        return true;
    }

    public boolean onWandRemove(Player player, String[] parameters) {
        boolean holdingWand = Spells.isWandActive(player);
        if (!holdingWand) {
            player.sendMessage("Equip a wand first (use /wand if needed)");
            return true;
        }
        if (parameters.length < 1) {
            player.sendMessage("Use: /wand remove <spell>");
            return true;
        }
        String spellName = parameters[0];
        PlayerInventory inventory = player.getInventory();
        int wandSlot = inventory.getHeldItemSlot();
        ItemStack newWand = this.removeSpellFromWand(player, spellName, inventory.getItemInHand());
        inventory.setItem(wandSlot, newWand);
        this.spells.updateWandInventory(player);
        return true;
    }

    public boolean onWandName(Player player, String[] parameters) {
        boolean holdingWand = Spells.isWandActive(player);
        if (!holdingWand) {
            player.sendMessage("Equip a wand first (use /wand if needed)");
            return true;
        }
        if (parameters.length < 1) {
            player.sendMessage("Use: /wand name <name>");
            return true;
        }
        PlayerInventory inventory = player.getInventory();
        ItemStack wand = inventory.getItemInHand();
        String spellString = InventoryUtils.getMeta(wand, "magic_spells");
        ItemMeta meta = wand.getItemMeta();
        meta.setDisplayName(parameters[0]);
        wand.setItemMeta(meta);
        InventoryUtils.setMeta(wand, "magic_spells", spellString);
        return true;
    }

    public boolean onWand(Player player, String[] parameters) {
        boolean holdingWand = Spells.isWandActive(player);
        String wandName = "default";
        if (parameters.length > 0) {
            wandName = parameters[0];
        }
        if (!holdingWand) {
            ItemStack itemStack = new ItemStack(Material.STICK);
            itemStack.addUnsafeEnchantment(Spells.MagicEnchantment, 1);
            ArrayList<String> defaultSpells = new ArrayList<String>();
            String defaultName = "Wand";
            if (wandName.equals("demo")) {
                defaultSpells.add("torch");
                defaultSpells.add("fling");
                defaultSpells.add("blink");
                defaultName = "Demo Wand";
            } else if (wandName.equals("engineer")) {
                defaultSpells.add("fill");
                defaultSpells.add("pillar");
                defaultSpells.add("bridge");
                defaultSpells.add("absorb");
                defaultName = "Engineering Wand";
            }
            Spells.updateWand(itemStack, defaultSpells.size(), defaultName);
            for (String spellName : defaultSpells) {
                Spell spell = this.spells.getSpell(spellName, player);
                if (spell == null) continue;
                itemStack = this.addSpellToWand(player, spell, itemStack);
            }
            PlayerInventory inventory = player.getInventory();
            ItemStack inHand = inventory.getItemInHand();
            if (inHand == null || inHand.getType() == Material.AIR) {
                PlayerSpells playerSpells = this.spells.getPlayerSpells(player);
                inventory.setItem(inventory.getHeldItemSlot(), itemStack);
                if (playerSpells.storeInventory()) {
                    this.spells.updateWandInventory(player);
                }
            } else {
                player.getInventory().addItem(new ItemStack[]{itemStack});
            }
            player.sendMessage("Use /wand again for help, /spells for spell list");
        } else {
            this.showWandHelp(player);
        }
        return true;
    }

    private ItemStack addSpellToWand(Player player, Spell spell, ItemStack wand) {
        if (!Spells.isWand(wand)) {
            return wand;
        }
        String spellString = InventoryUtils.getMeta(wand, "magic_spells");
        if (spellString == null) {
            spellString = "";
        }
        String[] spells = StringUtils.split((String)spellString, (String)"|");
        TreeSet<String> spellMap = new TreeSet<String>();
        int i = 0;
        while (i < spells.length) {
            spellMap.add(spells[i]);
            ++i;
        }
        spellMap.add(spell.getName());
        return Spells.setWandSpells(wand, spellMap);
    }

    private ItemStack removeSpellFromWand(Player player, String spellName, ItemStack wand) {
        if (!Spells.isWand(wand)) {
            return wand;
        }
        String spellString = InventoryUtils.getMeta(wand, "magic_spells");
        if (spellString == null) {
            spellString = "";
        }
        String[] spells = StringUtils.split((String)spellString, (String)"|");
        TreeSet<String> spellMap = new TreeSet<String>();
        int i = 0;
        while (i < spells.length) {
            spellMap.add(spells[i]);
            ++i;
        }
        spellMap.remove(spellName);
        return Spells.setWandSpells(wand, spellMap);
    }

    private void showWandHelp(Player player) {
        player.sendMessage("How to use your wand:");
        player.sendMessage(" The active spell is farthest to left");
        player.sendMessage(" Left-click your wand to cast");
        player.sendMessage(" Right-click to cycle spells");
    }

    public boolean onCast(Player player, String[] castParameters) {
        if (castParameters.length < 1) {
            return false;
        }
        String spellName = castParameters[0];
        String[] parameters = new String[castParameters.length - 1];
        int i = 1;
        while (i < castParameters.length) {
            parameters[i - 1] = castParameters[i];
            ++i;
        }
        Spell spell = this.spells.getSpell(spellName, player);
        if (spell == null) {
            return false;
        }
        spell.cast(parameters);
        return true;
    }

    public boolean onReload(CommandSender sender, String[] parameters) {
        this.spells.load();
        sender.sendMessage("Configuration reloaded.");
        return true;
    }

    public boolean onSpells(Player player, String[] parameters) {
        int pageNumber = 1;
        String category = null;
        if (parameters.length > 0) {
            try {
                pageNumber = Integer.parseInt(parameters[0]);
            }
            catch (NumberFormatException ex) {
                pageNumber = 1;
                category = parameters[0];
            }
        }
        this.listSpells(player, pageNumber, category);
        return true;
    }

    public void listSpellsByCategory(Player player, String category) {
        ArrayList<Spell> categorySpells = new ArrayList<Spell>();
        List<Spell> spellVariants = this.spells.getAllSpells();
        for (Spell spell : spellVariants) {
            if (!spell.getCategory().equalsIgnoreCase(category) || !spell.hasSpellPermission(player)) continue;
            categorySpells.add(spell);
        }
        if (categorySpells.size() == 0) {
            player.sendMessage("You don't know any spells");
            return;
        }
        Collections.sort(categorySpells);
        for (Spell spell : categorySpells) {
            player.sendMessage(String.valueOf(spell.getName()) + " [" + spell.getMaterial().name().toLowerCase() + "] : " + spell.getDescription());
        }
    }

    public void listCategories(Player player) {
        HashMap<String, Integer> spellCounts = new HashMap<String, Integer>();
        ArrayList<String> spellGroups = new ArrayList<String>();
        List<Spell> spellVariants = this.spells.getAllSpells();
        for (Spell spell : spellVariants) {
            if (!spell.hasSpellPermission(player)) continue;
            Integer spellCount = (Integer)spellCounts.get(spell.getCategory());
            if (spellCount == null || spellCount == 0) {
                spellCounts.put(spell.getCategory(), 1);
                spellGroups.add(spell.getCategory());
                continue;
            }
            spellCounts.put(spell.getCategory(), spellCount + 1);
        }
        if (spellGroups.size() == 0) {
            player.sendMessage("You don't know any spells");
            return;
        }
        Collections.sort(spellGroups);
        for (String group : spellGroups) {
            player.sendMessage(String.valueOf(group) + " [" + spellCounts.get(group) + "]");
        }
    }

    public void listSpells(Player player, int pageNumber, String category) {
        if (category != null) {
            this.listSpellsByCategory(player, category);
            return;
        }
        HashMap<String, SpellGroup> spellGroups = new HashMap<String, SpellGroup>();
        List<Spell> spellVariants = this.spells.getAllSpells();
        int spellCount = 0;
        for (Spell spell : spellVariants) {
            if (!spell.hasSpellPermission(player)) continue;
            ++spellCount;
            SpellGroup group = (SpellGroup)spellGroups.get(spell.getCategory());
            if (group == null) {
                group = new SpellGroup();
                group.groupName = spell.getCategory();
                spellGroups.put(group.groupName, group);
            }
            group.spells.add(spell);
        }
        ArrayList sortedGroups = new ArrayList();
        sortedGroups.addAll(spellGroups.values());
        Collections.sort(sortedGroups);
        int maxLines = 5;
        int maxPages = spellCount / maxLines + 1;
        if (pageNumber > maxPages) {
            pageNumber = maxPages;
        }
        player.sendMessage("You know " + spellCount + " spells. [" + pageNumber + "/" + maxPages + "]");
        int currentPage = 1;
        int lineCount = 0;
        int printedCount = 0;
        block1: for (SpellGroup group : sortedGroups) {
            if (printedCount > maxLines) break;
            boolean isFirst = true;
            Collections.sort(group.spells);
            for (Spell spell : group.spells) {
                if (printedCount > maxLines) continue block1;
                if (currentPage == pageNumber) {
                    if (isFirst) {
                        player.sendMessage(String.valueOf(group.groupName) + ":");
                        isFirst = false;
                    }
                    player.sendMessage(" " + spell.getName() + " [" + spell.getMaterial().name().toLowerCase() + "] : " + spell.getDescription());
                    ++printedCount;
                }
                if (++lineCount != maxLines) continue;
                lineCount = 0;
                ++currentPage;
            }
        }
    }

    public void onDisable() {
        this.spells.clear();
    }
}

