/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spells;

import com.elmakers.mine.bukkit.dao.BlockList;
import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.inventory.ItemStack;

public class ConstructSpell
extends Spell {
    static final String DEFAULT_DESTRUCTIBLES = "0,1,2,3,4,8,9,10,11,12,13,87,88";
    private List<Material> destructibleMaterials = null;
    private ConstructionType defaultConstructionType = ConstructionType.SPHERE;
    private int defaultRadius = 2;
    private int timeToLive = 0;

    public boolean onCast(ConfigurationNode parameters) {
        this.targetThrough(Material.GLASS);
        Block target = this.getTarget().getBlock();
        if (target == null) {
            this.initializeTargeting(this.player);
            this.noTargetThrough(Material.GLASS);
            target = this.getTarget().getBlock();
        }
        if (target == null) {
            this.castMessage(this.player, "No target");
            return false;
        }
        Material material = target.getType();
        byte data = target.getData();
        ItemStack buildWith = this.getBuildingMaterial();
        if (buildWith != null) {
            material = buildWith.getType();
            data = ConstructSpell.getItemData(buildWith);
        }
        ConstructionType conType = this.defaultConstructionType;
        boolean hollow = false;
        String fillType = parameters.getString("fill", "");
        hollow = fillType.equals("hollow");
        Material materialOverride = parameters.getMaterial("material");
        if (materialOverride != null) {
            material = materialOverride;
            data = 0;
        }
        int radius = parameters.getInt("radius", this.defaultRadius);
        String typeString = parameters.getString("type", "");
        ConstructionType testType = ConstructionType.parseString(typeString, ConstructionType.UNKNOWN);
        if (testType != ConstructionType.UNKNOWN) {
            conType = testType;
        }
        switch (conType) {
            case SPHERE: {
                this.constructSphere(target, radius, material, data, !hollow);
                break;
            }
            case CUBOID: {
                this.constructCuboid(target, radius, material, data, !hollow);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public void constructCuboid(Block target, int radius, Material material, byte data, boolean fill) {
        this.fillArea(target, radius, material, data, fill, false);
    }

    public void constructSphere(Block target, int radius, Material material, byte data, boolean fill) {
        this.fillArea(target, radius, material, data, fill, true);
    }

    public void fillArea(Block target, int radius, Material material, byte data, boolean fill, boolean sphere) {
        BlockList constructedBlocks = new BlockList();
        int diameter = radius * 2;
        int midX = (diameter - 1) / 2;
        int midY = (diameter - 1) / 2;
        int midZ = (diameter - 1) / 2;
        int diameterOffset = diameter - 1;
        int radiusSquared = (radius - 1) * (radius - 1);
        for (int x = 0; x < radius; ++x) {
            for (int y = 0; y < radius; ++y) {
                for (int z = 0; z < radius; ++z) {
                    boolean fillBlock = false;
                    if (sphere) {
                        int distanceSquared = this.getDistanceSquared(x - midX, y - midY, z - midZ);
                        boolean bl = fillBlock = distanceSquared <= radiusSquared;
                        if (!fill) {
                            fillBlock = fillBlock && distanceSquared >= radiusSquared - 16;
                        }
                    } else {
                        boolean bl = fill ? true : (fillBlock = x == 0 || y == 0 || z == 0);
                    }
                    if (!fillBlock) continue;
                    this.constructBlock(x, y, z, target, radius, material, data, constructedBlocks);
                    this.constructBlock(diameterOffset - x, y, z, target, radius, material, data, constructedBlocks);
                    this.constructBlock(x, diameterOffset - y, z, target, radius, material, data, constructedBlocks);
                    this.constructBlock(x, y, diameterOffset - z, target, radius, material, data, constructedBlocks);
                    this.constructBlock(diameterOffset - x, diameterOffset - y, z, target, radius, material, data, constructedBlocks);
                    this.constructBlock(x, diameterOffset - y, diameterOffset - z, target, radius, material, data, constructedBlocks);
                    this.constructBlock(diameterOffset - x, y, diameterOffset - z, target, radius, material, data, constructedBlocks);
                    this.constructBlock(diameterOffset - x, diameterOffset - y, diameterOffset - z, target, radius, material, data, constructedBlocks);
                }
            }
        }
        if (this.timeToLive == 0) {
            this.spells.addToUndoQueue(this.player, constructedBlocks);
        } else {
            constructedBlocks.setTimeToLive(this.timeToLive);
            this.spells.scheduleCleanup(constructedBlocks);
        }
        this.castMessage(this.player, "Constructed " + constructedBlocks.size() + "blocks");
    }

    public int getDistanceSquared(int x, int y, int z) {
        return x * x + y * y + z * z;
    }

    public void constructBlock(int dx, int dy, int dz, Block centerPoint, int radius, Material material, byte data, BlockList constructedBlocks) {
        int x = centerPoint.getX() + dx - radius;
        int y = centerPoint.getY() + dy - radius;
        int z = centerPoint.getZ() + dz - radius;
        Block block = this.player.getWorld().getBlockAt(x, y, z);
        if (!this.isDestructible(block)) {
            return;
        }
        constructedBlocks.add(block);
        block.setType(material);
        block.setData(data);
    }

    public boolean isDestructible(Block block) {
        return this.destructibleMaterials.contains(block.getType());
    }

    public void onLoad(ConfigurationNode properties) {
        this.destructibleMaterials = this.destructibleMaterials != null ? this.destructibleMaterials : csv.parseMaterials(DEFAULT_DESTRUCTIBLES);
        this.destructibleMaterials = properties.getMaterials("destructible", this.destructibleMaterials);
        this.timeToLive = properties.getInt("undo", this.timeToLive);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ConstructionType {
        SPHERE,
        CUBOID,
        UNKNOWN;


        public static ConstructionType parseString(String s, ConstructionType defaultType) {
            ConstructionType construct = defaultType;
            for (ConstructionType t : ConstructionType.values()) {
                if (!t.name().equalsIgnoreCase(s)) continue;
                construct = t;
            }
            return construct;
        }
    }
}

