/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spells;

import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.plugins.magic.Target;
import com.elmakers.mine.bukkit.utilities.MathHelper;
import com.elmakers.mine.bukkit.utilities.Vec3D;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class BoomSpell
extends Spell {
    protected int defaultSize = 1;

    public boolean createExplosionAt(Location target, float size, boolean incendiary) {
        if (target == null) {
            this.castMessage(this.player, "No target");
            return false;
        }
        this.player.getWorld().createExplosion(target.getBlock().getLocation(), size, incendiary);
        return true;
    }

    public boolean onCast(ConfigurationNode parameters) {
        int size = parameters.getInt("size", this.defaultSize);
        boolean useFire = parameters.getBoolean("fire", false);
        String targetType = parameters.getString("target", "");
        if (targetType.equals("here")) {
            this.player.damage(100.0);
            return this.createExplosionAt(this.player.getLocation(), size, useFire);
        }
        Target target = this.getTarget();
        if (!target.hasTarget()) {
            this.sendMessage(this.player, "No target");
            return false;
        }
        return this.createExplosionAt(target.getLocation(), size, useFire);
    }

    public Vec3D getLocation(Player player, float f) {
        Location playerLoc = player.getLocation();
        float rotationYaw = playerLoc.getYaw();
        float rotationPitch = playerLoc.getPitch();
        float prevRotationYaw = playerLoc.getYaw();
        float prevRotationPitch = playerLoc.getPitch();
        if (f == 1.0f) {
            float f1 = MathHelper.cos(-rotationYaw * 0.01745329f - 3.141593f);
            float f3 = MathHelper.sin(-rotationYaw * 0.01745329f - 3.141593f);
            float f5 = -MathHelper.cos(-rotationPitch * 0.01745329f);
            float f7 = MathHelper.sin(-rotationPitch * 0.01745329f);
            return Vec3D.createVector(f3 * f5, f7, f1 * f5);
        }
        float f2 = prevRotationPitch + (rotationPitch - prevRotationPitch) * f;
        float f4 = prevRotationYaw + (rotationYaw - prevRotationYaw) * f;
        float f6 = MathHelper.cos(-f4 * 0.01745329f - 3.141593f);
        float f8 = MathHelper.sin(-f4 * 0.01745329f - 3.141593f);
        float f9 = -MathHelper.cos(-f2 * 0.01745329f);
        float f10 = MathHelper.sin(-f2 * 0.01745329f);
        return Vec3D.createVector(f8 * f9, f10, f6 * f9);
    }
}

