/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic;

import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.plugins.magic.SpellGroup;
import com.elmakers.mine.bukkit.plugins.magic.Spells;
import com.elmakers.mine.bukkit.plugins.magic.SpellsBlockListener;
import com.elmakers.mine.bukkit.plugins.magic.SpellsEntityListener;
import com.elmakers.mine.bukkit.plugins.magic.SpellsPlayerListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class MagicPlugin
extends JavaPlugin {
    protected static Enchantment MagicEnchantment = Enchantment.ARROW_INFINITE;
    private final Spells spells = new Spells();
    private final Logger log = Logger.getLogger("Minecraft");
    private final SpellsPlayerListener playerListener = new SpellsPlayerListener();
    private final SpellsEntityListener entityListener = new SpellsEntityListener();
    private final SpellsBlockListener blockListener = new SpellsBlockListener();

    public Spells getSpells() {
        return this.spells;
    }

    public void onEnable() {
        this.initialize();
        PluginManager pm = this.getServer().getPluginManager();
        pm.registerEvents((Listener)this.playerListener, (Plugin)this);
        pm.registerEvents((Listener)this.entityListener, (Plugin)this);
        pm.registerEvents((Listener)this.blockListener, (Plugin)this);
        PluginDescriptionFile pdfFile = this.getDescription();
        this.log.info(pdfFile.getName() + " version " + pdfFile.getVersion() + " is enabled");
    }

    protected void initialize() {
        this.spells.initialize(this);
        this.playerListener.setSpells(this.spells);
        this.entityListener.setSpells(this.spells);
        this.blockListener.setSpells(this.spells);
    }

    public boolean onCommand(CommandSender sender, Command cmd, String commandLabel, String[] args) {
        String commandName = cmd.getName();
        if (commandName.equalsIgnoreCase("magic") && args.length > 0) {
            String subCommand = args[0];
            if (sender instanceof Player && !this.spells.hasPermission((Player)sender, "Magic.commands.magic." + subCommand)) {
                return true;
            }
            if (subCommand.equalsIgnoreCase("reload")) {
                this.spells.clear();
                this.spells.load();
                return true;
            }
            if (subCommand.equalsIgnoreCase("reset")) {
                this.spells.reset();
                return true;
            }
        }
        if (!(sender instanceof Player)) {
            return false;
        }
        Player player = (Player)sender;
        if (commandName.equalsIgnoreCase("wand")) {
            if (!this.spells.hasPermission(player, "Magic.commands.wand")) {
                return true;
            }
            return this.onWand(player, args);
        }
        if (commandName.equalsIgnoreCase("cast")) {
            if (!this.spells.hasPermission(player, "Magic.commands.cast")) {
                return true;
            }
            return this.onCast(player, args);
        }
        if (commandName.equalsIgnoreCase("spells")) {
            if (!this.spells.hasPermission(player, "Magic.commands.spells")) {
                return true;
            }
            return this.onSpells(player, args);
        }
        return false;
    }

    public static boolean isWand(ItemStack item) {
        return item != null && item.getType() == Material.STICK && item.hasItemMeta() && item.getItemMeta().hasEnchant(MagicEnchantment);
    }

    public boolean onWand(Player player, String[] parameters) {
        if (parameters.length < 1) {
            ItemStack[] items;
            boolean gaveWand = false;
            boolean hasWand = false;
            PlayerInventory inventory = player.getInventory();
            for (ItemStack item : items = inventory.getContents()) {
                if (!MagicPlugin.isWand(item)) continue;
                hasWand = true;
                break;
            }
            if (!hasWand) {
                ItemStack itemStack = new ItemStack(Material.STICK);
                itemStack.addUnsafeEnchantment(MagicEnchantment, 1);
                ItemMeta meta = itemStack.getItemMeta();
                meta.setDisplayName("Wand");
                ArrayList<String> lore = new ArrayList<String>();
                lore.add("Left-click to cast active spell");
                lore.add("Right-click to cycle spells");
                meta.setLore(lore);
                itemStack.setItemMeta(meta);
                player.getInventory().addItem(new ItemStack[]{itemStack});
                gaveWand = true;
            }
            if (!gaveWand) {
                this.showWandHelp(player);
            } else {
                player.sendMessage("Use /wand again for help, /spells for spell list");
            }
            return true;
        }
        String spellName = parameters[0];
        Spell spell = this.spells.getSpell(spellName, player);
        if (spell == null) {
            player.sendMessage("Spell '" + spellName + "' unknown, Use /spells for spell list");
            return true;
        }
        ItemStack itemStack = new ItemStack(spell.getMaterial(), 1);
        itemStack.addUnsafeEnchantment(MagicEnchantment, 1);
        ItemMeta meta = itemStack.getItemMeta();
        meta.setDisplayName("Spell: " + spell.getName());
        ArrayList<String> lore = new ArrayList<String>();
        lore.add(spell.getCategory());
        lore.add(spell.getDescription());
        meta.setLore(lore);
        itemStack.setItemMeta(meta);
        player.getInventory().addItem(new ItemStack[]{itemStack});
        return true;
    }

    private void showWandHelp(Player player) {
        player.sendMessage("How to use your wand:");
        player.sendMessage(" Type /spells to see what spells you know");
        player.sendMessage(" Place a spell item in your first inventory slot");
        player.sendMessage(" Left-click your wand to cast!");
        player.sendMessage(" Right-click to cycle spells in your inventory");
        if (this.spells.hasPermission(player, "Magic.commands.wand")) {
            player.sendMessage("/wand <spellname> : Give the item necessary to cast a spell");
        }
    }

    public boolean onCast(Player player, String[] castParameters) {
        if (castParameters.length < 1) {
            return false;
        }
        String spellName = castParameters[0];
        String[] parameters = new String[castParameters.length - 1];
        for (int i = 1; i < castParameters.length; ++i) {
            parameters[i - 1] = castParameters[i];
        }
        Spell spell = this.spells.getSpell(spellName, player);
        if (spell == null) {
            return false;
        }
        spell.cast(parameters);
        return true;
    }

    public boolean onReload(CommandSender sender, String[] parameters) {
        this.spells.load();
        sender.sendMessage("Configuration reloaded.");
        return true;
    }

    public boolean onSpells(Player player, String[] parameters) {
        int pageNumber = 1;
        String category = null;
        if (parameters.length > 0) {
            try {
                pageNumber = Integer.parseInt(parameters[0]);
            }
            catch (NumberFormatException ex) {
                pageNumber = 1;
                category = parameters[0];
            }
        }
        this.listSpells(player, pageNumber, category);
        return true;
    }

    public void listSpellsByCategory(Player player, String category) {
        ArrayList<Spell> categorySpells = new ArrayList<Spell>();
        List<Spell> spellVariants = this.spells.getAllSpells();
        for (Spell spell : spellVariants) {
            if (!spell.getCategory().equalsIgnoreCase(category) || !spell.hasSpellPermission(player)) continue;
            categorySpells.add(spell);
        }
        if (categorySpells.size() == 0) {
            player.sendMessage("You don't know any spells");
            return;
        }
        Collections.sort(categorySpells);
        for (Spell spell : categorySpells) {
            player.sendMessage(spell.getName() + " [" + spell.getMaterial().name().toLowerCase() + "] : " + spell.getDescription());
        }
    }

    public void listCategories(Player player) {
        HashMap<String, Integer> spellCounts = new HashMap<String, Integer>();
        ArrayList<String> spellGroups = new ArrayList<String>();
        List<Spell> spellVariants = this.spells.getAllSpells();
        for (Spell spell : spellVariants) {
            if (!spell.hasSpellPermission(player)) continue;
            Integer spellCount = (Integer)spellCounts.get(spell.getCategory());
            if (spellCount == null || spellCount == 0) {
                spellCounts.put(spell.getCategory(), 1);
                spellGroups.add(spell.getCategory());
                continue;
            }
            spellCounts.put(spell.getCategory(), spellCount + 1);
        }
        if (spellGroups.size() == 0) {
            player.sendMessage("You don't know any spells");
            return;
        }
        Collections.sort(spellGroups);
        for (String group : spellGroups) {
            player.sendMessage(group + " [" + spellCounts.get(group) + "]");
        }
    }

    public void listSpells(Player player, int pageNumber, String category) {
        if (category != null) {
            this.listSpellsByCategory(player, category);
            return;
        }
        HashMap<String, SpellGroup> spellGroups = new HashMap<String, SpellGroup>();
        List<Spell> spellVariants = this.spells.getAllSpells();
        int spellCount = 0;
        for (Spell spell : spellVariants) {
            if (!spell.hasSpellPermission(player)) continue;
            ++spellCount;
            SpellGroup group = (SpellGroup)spellGroups.get(spell.getCategory());
            if (group == null) {
                group = new SpellGroup();
                group.groupName = spell.getCategory();
                spellGroups.put(group.groupName, group);
            }
            group.spells.add(spell);
        }
        ArrayList sortedGroups = new ArrayList();
        sortedGroups.addAll(spellGroups.values());
        Collections.sort(sortedGroups);
        int maxLines = 5;
        int maxPages = spellCount / maxLines + 1;
        if (pageNumber > maxPages) {
            pageNumber = maxPages;
        }
        player.sendMessage("You know " + spellCount + " spells. [" + pageNumber + "/" + maxPages + "]");
        int currentPage = 1;
        int lineCount = 0;
        int printedCount = 0;
        block1: for (SpellGroup group : sortedGroups) {
            if (printedCount > maxLines) break;
            boolean isFirst = true;
            Collections.sort(group.spells);
            for (Spell spell : group.spells) {
                if (printedCount > maxLines) continue block1;
                if (currentPage == pageNumber) {
                    if (isFirst) {
                        player.sendMessage(group.groupName + ":");
                        isFirst = false;
                    }
                    player.sendMessage(" " + spell.getName() + " [" + spell.getMaterial().name().toLowerCase() + "] : " + spell.getDescription());
                    ++printedCount;
                }
                if (++lineCount != maxLines) continue;
                lineCount = 0;
                ++currentPage;
            }
        }
    }

    public void onDisable() {
        this.spells.clear();
    }
}

