/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.dao;

import com.elmakers.mine.bukkit.dao.BlockData;
import com.elmakers.mine.bukkit.dao.BoundingBox;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.bukkit.block.Block;
import org.bukkit.util.BlockVector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlockList
implements Collection<BlockData> {
    private static final long serialVersionUID = 1L;
    protected BoundingBox area;
    protected HashSet<Long> blockIdMap;
    protected ArrayList<BlockData> blockList;
    protected HashSet<BlockData> blockMap;
    protected int passesRemaining = 1;
    protected int timeToLive = 0;

    public BlockList() {
    }

    public BlockList(BlockList other) {
        for (BlockData block : other) {
            BlockData newBlock = new BlockData(block);
            this.add(newBlock);
        }
        this.timeToLive = other.timeToLive;
        this.passesRemaining = other.passesRemaining;
    }

    @Override
    public boolean add(Block block) {
        if (this.contains(block)) {
            return true;
        }
        BlockData newBlock = new BlockData(block);
        return this.add(newBlock);
    }

    @Override
    public boolean add(BlockData blockData) {
        if (this.blockMap != null) {
            if (this.blockMap.contains(blockData)) {
                return true;
            }
        } else {
            this.blockMap = new HashSet();
        }
        if (this.blockIdMap == null) {
            this.blockIdMap = new HashSet();
        }
        if (this.blockList == null) {
            this.blockList = new ArrayList();
        }
        BlockVector blockLocation = blockData.getPosition();
        this.area = this.area == null ? new BoundingBox(blockLocation, blockLocation) : this.area.contain(blockLocation);
        this.blockMap.add(blockData);
        this.blockIdMap.add(BlockData.getBlockId(blockData));
        return this.blockList.add(blockData);
    }

    @Override
    public boolean addAll(Collection<? extends BlockData> blocks) {
        boolean added = true;
        for (BlockData blockData : blocks) {
            added = added && this.add(blockData);
        }
        return added;
    }

    @Override
    public void clear() {
        if (this.blockList == null) {
            return;
        }
        this.blockList.clear();
    }

    public boolean contains(Block block) {
        if (this.blockMap == null) {
            return false;
        }
        return this.blockIdMap.contains(BlockData.getBlockId(block));
    }

    public boolean contains(BlockData blockData) {
        if (this.blockMap == null || blockData == null) {
            return false;
        }
        return this.blockMap.contains(blockData);
    }

    @Override
    public boolean contains(Object arg0) {
        return this.blockMap.contains(arg0) || this.blockIdMap.contains(arg0);
    }

    @Override
    public boolean containsAll(Collection<?> arg0) {
        if (this.blockMap == null) {
            return false;
        }
        return this.blockMap.containsAll(arg0);
    }

    public BoundingBox getArea() {
        return this.area;
    }

    public ArrayList<BlockData> getBlockList() {
        return this.blockList;
    }

    @Override
    public boolean isEmpty() {
        if (this.blockList == null) {
            return true;
        }
        return this.blockList.isEmpty();
    }

    @Override
    public Iterator<BlockData> iterator() {
        if (this.blockList == null) {
            return null;
        }
        return this.blockList.iterator();
    }

    @Override
    public boolean remove(Object arg0) {
        if (this.blockList == null) {
            return false;
        }
        return this.blockList.remove(arg0);
    }

    @Override
    public boolean removeAll(Collection<?> arg0) {
        if (this.blockList == null) {
            return false;
        }
        return this.blockList.removeAll(arg0);
    }

    @Override
    public boolean retainAll(Collection<?> arg0) {
        if (this.blockList == null) {
            return false;
        }
        return this.blockList.retainAll(arg0);
    }

    public void setArea(BoundingBox area) {
        this.area = area;
    }

    public void setBlockList(ArrayList<BlockData> blockList) {
        this.blockList = blockList;
        if (blockList != null) {
            this.blockMap = new HashSet();
            this.blockIdMap = new HashSet();
            for (BlockData block : blockList) {
                this.blockMap.add(block);
                this.blockIdMap.add(BlockData.getBlockId(block));
            }
        }
    }

    public void setRepetitions(int repeat) {
        this.passesRemaining = repeat;
    }

    public boolean isComplete() {
        return this.passesRemaining <= 0;
    }

    public void setTimeToLive(int ttl) {
        this.timeToLive = ttl;
    }

    public int getTimeToLive() {
        return this.timeToLive;
    }

    @Override
    public int size() {
        if (this.blockList == null) {
            return 0;
        }
        return this.blockList.size();
    }

    @Override
    public Object[] toArray() {
        if (this.blockList == null) {
            return null;
        }
        return this.blockList.toArray();
    }

    @Override
    public <T> T[] toArray(T[] arg0) {
        if (this.blockList == null) {
            return null;
        }
        return this.blockList.toArray(arg0);
    }

    public boolean undo() {
        if (this.blockList == null) {
            return true;
        }
        --this.passesRemaining;
        for (BlockData block : this.blockList) {
            if (block.undo()) continue;
            return false;
        }
        return true;
    }
}

