/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic;

import com.elmakers.mine.bukkit.dao.MaterialList;
import com.elmakers.mine.bukkit.plugins.magic.CastingCost;
import com.elmakers.mine.bukkit.plugins.magic.Spells;
import com.elmakers.mine.bukkit.plugins.magic.Target;
import com.elmakers.mine.bukkit.utilities.BlockAction;
import com.elmakers.mine.bukkit.utilities.CSVParser;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Spell
implements Comparable<Spell>,
Cloneable {
    protected Player player = null;
    protected Spells spells;
    protected static CSVParser csv = new CSVParser();
    private String name;
    private String description;
    private String category;
    private ConfigurationNode parameters;
    private Material material;
    private List<CastingCost> costs = null;
    private boolean allowMaxRange = false;
    private int range = 200;
    private double viewHeight = 1.65;
    private double step = 0.2;
    private int cooldown = 0;
    private long lastCast = 0L;
    private int verticalSearchDistance = 8;
    private boolean targetingComplete;
    private int targetHeightRequired = 1;
    private Class<? extends Entity> targetEntityType = null;
    private Location playerLocation;
    private double xRotation;
    private double yRotation;
    private double length;
    private double hLength;
    private double xOffset;
    private double yOffset;
    private double zOffset;
    private int lastX;
    private int lastY;
    private int lastZ;
    private int targetX;
    private int targetY;
    private int targetZ;
    private MaterialList targetThroughMaterials = new MaterialList();
    private boolean reverseTargeting = false;
    private boolean usesTargeting = true;

    protected Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException ex) {
            return null;
        }
    }

    protected static String getBuiltinClasspath() {
        String baseClass = Spell.class.getName();
        return baseClass.substring(0, baseClass.lastIndexOf(46));
    }

    public static Spell loadSpell(String name, ConfigurationNode node) {
        Object newObject;
        String builtinClassPath = Spell.getBuiltinClasspath();
        String className = node.getString("class");
        if (className == null) {
            return null;
        }
        if (className.indexOf(46) <= 0) {
            className = String.valueOf(builtinClassPath) + ".spells." + className;
        }
        Class<?> spellClass = null;
        try {
            spellClass = Class.forName(className);
        }
        catch (ClassNotFoundException ex) {
            return null;
        }
        try {
            newObject = spellClass.newInstance();
        }
        catch (InstantiationException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
        if (newObject == null || !(newObject instanceof Spell)) {
            return null;
        }
        Spell newSpell = (Spell)newObject;
        newSpell.load(name, node);
        return newSpell;
    }

    protected void loadAndSave(ConfigurationNode node) {
        this.description = node.getString("description", this.description);
        this.material = node.getMaterial("icon", this.material);
        this.category = node.getString("category", this.category);
        this.parameters = node.getNode("parameters", this.parameters);
        ConfigurationNode properties = node.getNode("properties");
        if (properties == null) {
            properties = node.createChild("properties");
        }
        this.cooldown = properties.getInt("cooldown", this.cooldown);
        this.onLoad(properties);
        if (this.usesTargeting) {
            this.range = properties.getInteger("range", this.range);
            this.allowMaxRange = properties.getBoolean("allow_max_range", this.allowMaxRange);
            this.targetThroughMaterials = new MaterialList(properties.getMaterials("target_through", this.targetThroughMaterials));
        }
    }

    protected void load(String name, ConfigurationNode node) {
        this.name = name;
        this.loadAndSave(node);
        List<Object> costNodes = node.getList("costs");
        if (costNodes != null) {
            if (this.costs == null) {
                this.costs = new ArrayList<CastingCost>();
            }
            this.costs.clear();
            for (Object o : costNodes) {
                if (!(o instanceof Map)) continue;
                Map nodeValues = (Map)o;
                CastingCost cost = new CastingCost(new ConfigurationNode(nodeValues));
                this.costs.add(cost);
            }
        }
        this.targetThrough(Material.AIR);
        this.targetThrough(Material.WATER);
        this.targetThrough(Material.STATIONARY_WATER);
        this.targetThrough(Material.SNOW);
    }

    public void save(ConfigurationNode node) {
        String builtinClassPath;
        String className = this.getClass().getName();
        if (className.contains(builtinClassPath = Spell.getBuiltinClasspath())) {
            className = className.substring(className.lastIndexOf(46) + 1);
        }
        node.setProperty("class", className);
        this.loadAndSave(node);
        if (this.costs != null) {
            ArrayList<Map<String, Object>> costList = new ArrayList<Map<String, Object>>();
            for (CastingCost cost : this.costs) {
                costList.add(cost.export());
            }
            node.setProperty("costs", costList);
        }
        this.onSave(node);
    }

    public void onSave(ConfigurationNode node) {
    }

    public void setPlayer(Player player) {
        this.player = player;
    }

    public final String getName() {
        return this.name;
    }

    public final Material getMaterial() {
        return this.material;
    }

    public final String getDescription() {
        return this.description;
    }

    public final String getCategory() {
        return this.category;
    }

    public boolean isMatch(String spell, String[] params) {
        if (params == null) {
            params = new String[]{};
        }
        return this.name.equalsIgnoreCase(spell) && this.parameters.equals(params);
    }

    @Override
    public int compareTo(Spell other) {
        return this.getName().compareTo(other.getName());
    }

    public boolean cast() {
        return this.cast(new String[0]);
    }

    public static void addParameters(String[] extraParameters, ConfigurationNode parameters) {
        if (extraParameters != null) {
            int i = 0;
            while (i < extraParameters.length - 1) {
                parameters.setProperty(extraParameters[i], extraParameters[i + 1]);
                i += 2;
            }
        }
    }

    public boolean cast(String[] extraParameters) {
        ConfigurationNode parameters = new ConfigurationNode(this.parameters);
        Spell.addParameters(extraParameters, parameters);
        long currentTime = System.currentTimeMillis();
        if (this.lastCast != 0L && this.lastCast > currentTime - (long)this.cooldown) {
            return false;
        }
        if (this.costs != null) {
            for (CastingCost cost : this.costs) {
                if (cost.has(this.player.getInventory())) continue;
                this.sendMessage(this.player, "Not enough " + cost.getDescription());
                return false;
            }
            for (CastingCost cost : this.costs) {
                cost.use(this.player.getInventory());
            }
        }
        this.lastCast = currentTime;
        this.initializeTargeting(this.player);
        return this.onCast(parameters);
    }

    public String getPermissionNode() {
        return "Magic.cast." + this.getName();
    }

    public boolean hasSpellPermission(Player player) {
        if (player == null) {
            return false;
        }
        return this.spells.hasPermission(player, this.getPermissionNode());
    }

    public abstract boolean onCast(ConfigurationNode var1);

    public void onLoad(ConfigurationNode node) {
    }

    public void onCancel() {
    }

    public void onPlayerMove(PlayerMoveEvent event) {
    }

    public void onPlayerQuit(PlayerQuitEvent event) {
    }

    public void onPlayerDeath(EntityDeathEvent event) {
    }

    public void onPlayerDamage(EntityDamageEvent event) {
    }

    public static byte getItemData(ItemStack stack) {
        if (stack == null) {
            return 0;
        }
        return (byte)stack.getDurability();
    }

    public Player getPlayer() {
        return this.player;
    }

    public ItemStack getBuildingMaterial() {
        boolean isAir;
        ItemStack result = null;
        List<Material> buildingMaterials = this.spells.getBuildingMaterials();
        PlayerInventory inventory = this.player.getInventory();
        ItemStack[] contents = inventory.getContents();
        result = contents[8];
        boolean bl = isAir = result == null || result.getType() == Material.AIR;
        if (!isAir && buildingMaterials.contains(result.getType())) {
            return result;
        }
        result = null;
        if (contents[7] == null || contents[7].getType() == Material.AIR) {
            return null;
        }
        return new ItemStack(Material.AIR);
    }

    public void targetEntity(Class<? extends Entity> typeOf) {
        this.targetEntityType = typeOf;
    }

    public void targetThrough(Material mat) {
        this.targetThroughMaterials.add(mat);
    }

    public void noTargetThrough(Material mat) {
        this.targetThroughMaterials.remove(mat);
    }

    public boolean isTargetable(Material mat) {
        boolean targetThrough = this.targetThroughMaterials.contains(mat);
        if (this.reverseTargeting) {
            return targetThrough;
        }
        return !targetThrough;
    }

    public void setReverseTargeting(boolean reverse) {
        this.reverseTargeting = reverse;
    }

    public boolean isReverseTargeting() {
        return this.reverseTargeting;
    }

    public void setTargetHeightRequired(int height) {
        this.targetHeightRequired = height;
    }

    public int getTargetHeightRequired() {
        return this.targetHeightRequired;
    }

    public boolean isOkToStandIn(Material mat) {
        return mat == Material.AIR || mat == Material.WATER || mat == Material.STATIONARY_WATER || mat == Material.SNOW || mat == Material.TORCH || mat == Material.SIGN_POST || mat == Material.REDSTONE_TORCH_ON || mat == Material.REDSTONE_TORCH_OFF || mat == Material.YELLOW_FLOWER || mat == Material.RED_ROSE || mat == Material.RED_MUSHROOM || mat == Material.BROWN_MUSHROOM || mat == Material.LONG_GRASS;
    }

    public boolean isWater(Material mat) {
        return mat == Material.WATER || mat == Material.STATIONARY_WATER;
    }

    public boolean isOkToStandOn(Material mat) {
        return mat != Material.AIR && mat != Material.LAVA && mat != Material.STATIONARY_LAVA;
    }

    public Location findPlaceToStand(Location playerLoc, boolean goUp) {
        int step = goUp ? 1 : -1;
        int x = (int)Math.round(playerLoc.getX() - 0.5);
        int y = (int)Math.round(playerLoc.getY() + (double)step + (double)step);
        int z = (int)Math.round(playerLoc.getZ() - 0.5);
        World world = this.player.getWorld();
        while (4 < y && y < 125) {
            Block block = world.getBlockAt(x, y, z);
            Block blockOneUp = world.getBlockAt(x, y + 1, z);
            Block blockTwoUp = world.getBlockAt(x, y + 2, z);
            if (this.isOkToStandOn(block.getType()) && this.isOkToStandIn(blockOneUp.getType()) && this.isOkToStandIn(blockTwoUp.getType()) && (!goUp || !this.isUnderwater() || !this.isWater(blockOneUp.getType()))) {
                return new Location(world, (double)x + 0.5, (double)y + 1.0, (double)z + 0.5, playerLoc.getYaw(), playerLoc.getPitch());
            }
            y += step;
        }
        return null;
    }

    public static double getDistance(Location source, Location target) {
        return Math.sqrt(Math.pow(source.getX() - target.getX(), 2.0) + Math.pow(source.getY() - target.getY(), 2.0) + Math.pow(source.getZ() - target.getZ(), 2.0));
    }

    public static double getDistance(Player player, Block target) {
        Location loc = player.getLocation();
        return Math.sqrt(Math.pow(loc.getX() - (double)target.getX(), 2.0) + Math.pow(loc.getY() - (double)target.getY(), 2.0) + Math.pow(loc.getZ() - (double)target.getZ(), 2.0));
    }

    public Block getPlayerBlock() {
        Block playerBlock = null;
        Location playerLoc = this.player.getLocation();
        int x = (int)Math.round(playerLoc.getX() - 0.5);
        int y = (int)Math.round(playerLoc.getY() - 0.5);
        int z = (int)Math.round(playerLoc.getZ() - 0.5);
        int dy = 0;
        while (dy > -3 && (playerBlock == null || this.isOkToStandIn(playerBlock.getType()))) {
            playerBlock = this.player.getWorld().getBlockAt(x, y + dy, z);
            --dy;
        }
        return playerBlock;
    }

    public BlockFace getPlayerFacing() {
        float playerRot = this.getPlayerRotation();
        BlockFace direction = BlockFace.NORTH;
        if (playerRot <= 45.0f || playerRot > 315.0f) {
            direction = BlockFace.WEST;
        } else if (playerRot > 45.0f && playerRot <= 135.0f) {
            direction = BlockFace.NORTH;
        } else if (playerRot > 135.0f && playerRot <= 225.0f) {
            direction = BlockFace.EAST;
        } else if (playerRot > 225.0f && playerRot <= 315.0f) {
            direction = BlockFace.SOUTH;
        }
        return direction;
    }

    public static BlockFace goLeft(BlockFace direction) {
        switch (direction) {
            case EAST: {
                return BlockFace.NORTH;
            }
            case NORTH: {
                return BlockFace.WEST;
            }
            case WEST: {
                return BlockFace.SOUTH;
            }
            case SOUTH: {
                return BlockFace.EAST;
            }
        }
        return direction;
    }

    public static BlockFace goRight(BlockFace direction) {
        switch (direction) {
            case EAST: {
                return BlockFace.SOUTH;
            }
            case SOUTH: {
                return BlockFace.WEST;
            }
            case WEST: {
                return BlockFace.NORTH;
            }
            case NORTH: {
                return BlockFace.EAST;
            }
        }
        return direction;
    }

    protected Location getProjectileSpawnLocation() {
        Block spawnBlock = this.getPlayerBlock();
        int height = 2;
        double hLength = 2.0;
        double xOffset = hLength * Math.cos(Math.toRadians(this.xRotation));
        double zOffset = hLength * Math.sin(Math.toRadians(this.xRotation));
        Vector aimVector = new Vector(xOffset + 0.5, (double)height + 0.5, zOffset + 0.5);
        Location location = new Location(this.player.getWorld(), (double)spawnBlock.getX() + aimVector.getX(), (double)spawnBlock.getY() + aimVector.getY(), (double)spawnBlock.getZ() + aimVector.getZ(), this.player.getLocation().getYaw(), this.player.getLocation().getPitch());
        return location;
    }

    public Vector getAimVector() {
        double yaw = Math.toRadians(this.playerLocation.getYaw());
        double pitch = Math.toRadians(this.playerLocation.getPitch());
        Vector aimVector = new Vector(0.0 - Math.sin(yaw), 0.0 - Math.sin(pitch), Math.cos(yaw));
        double y = aimVector.getY();
        if (y >= 1.0 || y <= -1.0) {
            aimVector.setX(0);
            aimVector.setZ(0);
        } else {
            aimVector.normalize();
        }
        return aimVector;
    }

    public double getYRotation() {
        return this.yRotation;
    }

    public double getXRotation() {
        return this.xRotation;
    }

    public float getPlayerRotation() {
        float playerRot = this.player.getLocation().getYaw();
        while (playerRot < 0.0f) {
            playerRot += 360.0f;
        }
        while (playerRot > 360.0f) {
            playerRot -= 360.0f;
        }
        return playerRot;
    }

    public Target getTarget() {
        Block block = this.getTargetBlock();
        Target targetBlock = new Target(this.player, block);
        Target targetEntity = this.getTargetEntity();
        if (targetEntity == null || targetBlock.getDistance() < targetEntity.getDistance()) {
            return targetBlock;
        }
        return targetEntity;
    }

    public Block getTargetBlock() {
        this.findTargetBlock();
        return this.getCurBlock();
    }

    protected Target getTargetEntity() {
        List entities = this.player.getWorld().getEntities();
        ArrayList<Target> scored = new ArrayList<Target>();
        for (Entity entity : entities) {
            Target newScore;
            if (entity == this.player || this.targetEntityType != null && !this.targetEntityType.isAssignableFrom(entity.getClass()) || (newScore = new Target(this.player, entity, this.range)).getScore() <= 0) continue;
            scored.add(newScore);
        }
        if (scored.size() <= 0) {
            return null;
        }
        Collections.sort(scored);
        return (Target)scored.get(0);
    }

    public Block getFaceBlock() {
        this.findTargetBlock();
        if (this.getCurBlock() != null) {
            return this.getLastBlock();
        }
        return null;
    }

    public Block getNextBlock() {
        this.lastX = this.targetX;
        this.lastY = this.targetY;
        this.lastZ = this.targetZ;
        do {
            this.length += this.step;
            this.hLength = this.length * Math.cos(Math.toRadians(this.yRotation));
            this.yOffset = this.length * Math.sin(Math.toRadians(this.yRotation));
            this.xOffset = this.hLength * Math.cos(Math.toRadians(this.xRotation));
            this.zOffset = this.hLength * Math.sin(Math.toRadians(this.xRotation));
            this.targetX = (int)Math.floor(this.xOffset + this.playerLocation.getX());
            this.targetY = (int)Math.floor(this.yOffset + this.playerLocation.getY() + this.viewHeight);
            this.targetZ = (int)Math.floor(this.zOffset + this.playerLocation.getZ());
        } while (this.length <= (double)this.range && this.targetX == this.lastX && this.targetY == this.lastY && this.targetZ == this.lastZ);
        if (this.length > (double)this.range || this.targetY > 255) {
            if (this.allowMaxRange) {
                return this.getBlockAt(this.targetX, this.targetY, this.targetZ);
            }
            return null;
        }
        return this.getBlockAt(this.targetX, this.targetY, this.targetZ);
    }

    public Block getCurBlock() {
        if (this.length > (double)this.range && !this.allowMaxRange) {
            return null;
        }
        return this.getBlockAt(this.targetX, this.targetY, this.targetZ);
    }

    public Block getLastBlock() {
        return this.getBlockAt(this.lastX, this.lastY, this.lastZ);
    }

    public Block getBlockAt(int x, int y, int z) {
        World world = this.player.getWorld();
        return world.getBlockAt(x, y, z);
    }

    public void castMessage(Player player, String message) {
        if (!this.spells.isQuiet() && !this.spells.isSilent()) {
            player.sendMessage(message);
        }
    }

    public void sendMessage(Player player, String message) {
        if (!this.spells.isSilent()) {
            player.sendMessage(message);
        }
    }

    public void setRelativeTime(long time) {
        long margin = (time - this.getTime()) % 24000L;
        if (margin < 0L) {
            margin += 24000L;
        }
        this.player.getWorld().setTime(this.getTime() + margin);
    }

    public long getTime() {
        return this.player.getWorld().getTime();
    }

    public boolean isUnderwater() {
        Block playerBlock = this.getPlayerBlock();
        return (playerBlock = playerBlock.getRelative(BlockFace.UP)).getType() == Material.WATER || playerBlock.getType() == Material.STATIONARY_WATER;
    }

    public void initialize(Spells instance) {
        this.spells = instance;
    }

    public void cancel() {
        this.onCancel();
    }

    protected void initializeTargeting(Player player) {
        this.playerLocation = player.getLocation();
        this.length = 0.0;
        this.targetHeightRequired = 1;
        this.targetEntityType = LivingEntity.class;
        this.xRotation = (this.playerLocation.getYaw() + 90.0f) % 360.0f;
        this.yRotation = this.playerLocation.getPitch() * -1.0f;
        this.reverseTargeting = false;
        this.targetX = (int)Math.floor(this.playerLocation.getX());
        this.targetY = (int)Math.floor(this.playerLocation.getY() + this.viewHeight);
        this.targetZ = (int)Math.floor(this.playerLocation.getZ());
        this.lastX = this.targetX;
        this.lastY = this.targetY;
        this.lastZ = this.targetZ;
        this.targetingComplete = false;
    }

    /*
     * Unable to fully structure code
     */
    protected void findTargetBlock() {
        if (!this.targetingComplete) ** GOTO lbl14
        return;
lbl-1000:
        // 1 sources

        {
            block = this.getCurBlock();
            if (!this.isTargetable(block.getType())) continue;
            enoughSpace = true;
            i = 1;
            while (i < this.targetHeightRequired) {
                if (!this.isTargetable((block = block.getRelative(BlockFace.UP)).getType())) {
                    enoughSpace = false;
                    break;
                }
                ++i;
            }
            if (enoughSpace) break;
lbl14:
            // 3 sources

            ** while (this.getNextBlock() != null && this.length <= (double)this.range)
        }
lbl15:
        // 2 sources

        this.targetingComplete = true;
    }

    protected int getMaxRange() {
        return this.range;
    }

    protected void setMaxRange(int range, boolean allow) {
        this.range = range;
        this.allowMaxRange = allow;
    }

    protected Material getMaterial(String matName, List<Material> materials) {
        Material material = Material.AIR;
        StringBuffer simplify = new StringBuffer("_");
        matName = matName.replace(simplify, new StringBuffer(""));
        for (Material checkMat : materials) {
            String checkName = checkMat.name().replace(simplify, new StringBuffer(""));
            if (!checkName.equalsIgnoreCase(matName)) continue;
            material = checkMat;
            break;
        }
        return material;
    }

    protected boolean giveMaterial(Material materialType, int amount, short damage, byte data) {
        ItemStack itemStack = new ItemStack(materialType, amount, damage, Byte.valueOf(data));
        boolean active = false;
        int i = 8;
        while (i >= 0) {
            ItemStack current = this.player.getInventory().getItem(i);
            if (current == null || current.getType() == Material.AIR) {
                this.player.getInventory().setItem(i, itemStack);
                active = true;
                break;
            }
            --i;
        }
        if (!active) {
            this.player.getInventory().addItem(new ItemStack[]{itemStack});
        }
        return true;
    }

    protected void disableTargeting() {
        this.usesTargeting = false;
    }

    public boolean isInCircle(int x, int z, int R) {
        return x * x + z * z - R * R <= 0;
    }

    /*
     * Unable to fully structure code
     */
    public void coverSurface(Location center, int radius, BlockAction action) {
        y = center.getBlockY();
        dx = -radius;
        while (dx < radius) {
            dz = -radius;
            while (dz < radius) {
                block5: {
                    block6: {
                        if (!this.isInCircle(dx, dz, radius)) break block5;
                        x = center.getBlockX() + dx;
                        z = center.getBlockZ() + dz;
                        block = this.player.getWorld().getBlockAt(x, y, z);
                        depth = 0;
                        if (block.getType() != Material.AIR) ** GOTO lbl19
                        while (depth < this.verticalSearchDistance && block.getType() == Material.AIR) {
                            ++depth;
                            block = block.getRelative(BlockFace.DOWN);
                        }
                        break block6;
lbl-1000:
                        // 1 sources

                        {
                            ++depth;
                            block = block.getRelative(BlockFace.UP);
lbl19:
                            // 2 sources

                            ** while (depth < this.verticalSearchDistance && block.getType() != Material.AIR)
                        }
lbl20:
                        // 1 sources

                        block = block.getRelative(BlockFace.DOWN);
                    }
                    coveringBlock = block.getRelative(BlockFace.UP);
                    if (block.getType() != Material.AIR && coveringBlock.getType() == Material.AIR) {
                        action.perform(block);
                    }
                }
                ++dz;
            }
            ++dx;
        }
    }
}

