/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic;

import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.plugins.magic.SpellEventType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;

public class PlayerSpells {
    protected Player player;
    protected HashMap<String, Spell> spells = new HashMap();
    private final List<Spell> movementListeners = new ArrayList<Spell>();
    private final List<Spell> quitListeners = new ArrayList<Spell>();
    private final List<Spell> deathListeners = new ArrayList<Spell>();
    private final List<Spell> damageListeners = new ArrayList<Spell>();

    public void registerEvent(SpellEventType type, Spell spell) {
        switch (type) {
            case PLAYER_MOVE: {
                if (this.movementListeners.contains(spell)) break;
                this.movementListeners.add(spell);
                break;
            }
            case PLAYER_QUIT: {
                if (this.quitListeners.contains(spell)) break;
                this.quitListeners.add(spell);
                break;
            }
            case PLAYER_DAMAGE: {
                if (this.damageListeners.contains(spell)) break;
                this.damageListeners.add(spell);
                break;
            }
            case PLAYER_DEATH: {
                if (this.deathListeners.contains(spell)) break;
                this.deathListeners.add(spell);
            }
        }
    }

    public void setPlayer(Player player) {
        this.player = player;
    }

    public void unregisterEvent(SpellEventType type, Spell spell) {
        switch (type) {
            case PLAYER_MOVE: {
                this.movementListeners.remove(spell);
                break;
            }
            case PLAYER_DAMAGE: {
                this.damageListeners.remove(spell);
                break;
            }
            case PLAYER_QUIT: {
                this.quitListeners.remove(spell);
                break;
            }
            case PLAYER_DEATH: {
                this.deathListeners.remove(spell);
            }
        }
    }

    public PlayerSpells(Player player) {
        this.player = player;
    }

    public Spell getSpell(String name) {
        return this.spells.get(name);
    }

    protected void addSpell(Spell spell) {
        this.spells.put(spell.getName(), spell);
    }

    public void cancel() {
        for (Spell spell : this.spells.values()) {
            spell.cancel();
        }
    }

    public void onPlayerQuit(PlayerQuitEvent event) {
        ArrayList<Spell> active = new ArrayList<Spell>();
        active.addAll(this.quitListeners);
        for (Spell listener : active) {
            listener.onPlayerQuit(event);
        }
    }

    public void onPlayerMove(PlayerMoveEvent event) {
        ArrayList<Spell> active = new ArrayList<Spell>();
        active.addAll(this.movementListeners);
        for (Spell listener : active) {
            listener.onPlayerMove(event);
        }
    }

    public void onPlayerDeath(EntityDeathEvent event) {
        ArrayList<Spell> active = new ArrayList<Spell>();
        active.addAll(this.deathListeners);
        for (Spell listener : active) {
            if (this.player != listener.getPlayer()) continue;
            listener.onPlayerDeath(event);
        }
    }

    public void onPlayerDamage(EntityDamageEvent event) {
        ArrayList<Spell> active = new ArrayList<Spell>();
        active.addAll(this.damageListeners);
        for (Spell listener : active) {
            listener.onPlayerDamage(event);
        }
    }
}

