/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spells;

import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.plugins.magic.Target;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.craftbukkit.entity.CraftWolf;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.CreatureType;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;

public class WolfSpell
extends Spell {
    private static int maxWolves = 5;
    protected List<CraftWolf> wolves = new ArrayList<CraftWolf>();

    public CraftWolf newWolf(Target target) {
        CraftWolf entity;
        if (target == null) {
            this.castMessage(this.player, "No target");
            return null;
        }
        Block targetBlock = target.getBlock();
        targetBlock = targetBlock.getRelative(BlockFace.UP);
        if (target.isEntity()) {
            targetBlock = targetBlock.getRelative(BlockFace.SOUTH);
        }
        if ((entity = (CraftWolf)this.player.getWorld().spawnCreature(targetBlock.getLocation(), CreatureType.WOLF)) == null) {
            this.sendMessage(this.player, "Your wolfie is DOA");
            return null;
        }
        this.tameWolf(entity);
        this.castMessage(this.player, "You summon a wolfie!");
        return entity;
    }

    public boolean onCast(ConfigurationNode parameters) {
        CraftWolf wolf2;
        this.targetEntity(LivingEntity.class);
        Target target = this.getTarget();
        if (target == null) {
            return false;
        }
        ArrayList<CraftWolf> newWolves = new ArrayList<CraftWolf>();
        for (CraftWolf wolf2 : this.wolves) {
            if (wolf2.isDead()) continue;
            newWolves.add(wolf2);
        }
        this.wolves = newWolves;
        if (this.wolves.size() >= maxWolves) {
            CraftWolf killWolf = this.wolves.remove(0);
            killWolf.setHealth(0);
        }
        if ((wolf2 = this.newWolf(target)) == null) {
            return false;
        }
        this.wolves.add(wolf2);
        Entity e = target.getEntity();
        if (e != null && e instanceof LivingEntity) {
            LivingEntity targetEntity = (LivingEntity)e;
            for (CraftWolf w : this.wolves) {
                w.setTarget(targetEntity);
            }
        }
        return true;
    }

    protected void tameWolf(CraftWolf wolfie) {
        wolfie.setAngry(false);
        wolfie.setHealth(20);
        wolfie.setTamed(true);
        wolfie.setOwner((AnimalTamer)this.player);
    }

    public void onLoad(ConfigurationNode node) {
        maxWolves = node.getInt("max_wolves", maxWolves);
    }
}

